/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.server.entity.dinosaur.MicroraptorEntity;

public class RaptorClimbTreeAI
extends EntityAIBase {
    private static final int CLIMB_INTERVAL = 1200;
    private static final int MAX_TREE_HEIGHT = 14;
    private final MicroraptorEntity entity;
    private final double movementSpeed;
    private final World world;
    private Path path;
    private BlockPos targetTrunk;
    private EnumFacing approachSide;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean gliding;
    private boolean active;
    private boolean reachedTarget;
    private int lastActive = -1200;

    public RaptorClimbTreeAI(MicroraptorEntity entity, double speed) {
        this.entity = entity;
        this.movementSpeed = speed;
        this.world = entity.field_70170_p;
        this.func_75248_a(6);
    }

    public boolean func_75250_a() {
        if (this.active || this.entity.field_70173_aa - this.lastActive < 1) {
            return false;
        }
        BlockPos pos = new BlockPos(this.entity.field_70165_t, this.entity.func_174813_aQ().field_72338_b, this.entity.field_70161_v);
        Random rand = this.entity.func_70681_au();
        block0: for (int i = 0; i < 20; ++i) {
            BlockPos target = pos.func_177982_a(rand.nextInt(14) - 7, -5, rand.nextInt(14) - 7);
            for (int iteration = 0; iteration <= 15; ++iteration) {
                IBlockState state = this.world.func_180495_p(target = target.func_177984_a());
                if (state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151575_d) {
                    for (EnumFacing direction : EnumFacing.field_176754_o) {
                        BlockPos offsetTarget = target.func_177972_a(direction);
                        if (this.world.isSideSolid(offsetTarget, EnumFacing.DOWN)) continue;
                        boolean canTravel = true;
                        boolean woodFound = false;
                        for (int height = 0; height < 14; ++height) {
                            BlockPos trunkPos = target.func_177981_b(height);
                            BlockPos climbPos = offsetTarget.func_177981_b(height);
                            IBlockState climbState = this.world.func_180495_p(climbPos);
                            if (!climbState.func_177230_c().isAir(climbState, (IBlockAccess)this.world, climbPos) && !climbState.func_177230_c().isLeaves(climbState, (IBlockAccess)this.world, climbPos)) {
                                canTravel = false;
                                break;
                            }
                            IBlockState trunkState = this.world.func_180495_p(trunkPos);
                            if (!trunkState.func_177230_c().isWood((IBlockAccess)this.world, trunkPos)) break;
                            woodFound = true;
                        }
                        if (!canTravel || !woodFound) continue;
                        float offsetX = (float)direction.func_82601_c() * (this.entity.field_70130_N + 0.25f) + 0.1f;
                        float offsetZ = (float)direction.func_82599_e() * (this.entity.field_70130_N + 0.25f) + 0.1f;
                        this.targetTrunk = target;
                        this.targetX = (float)target.func_177958_n() + 0.5f + offsetX;
                        this.targetY = target.func_177956_o();
                        this.targetZ = (float)target.func_177952_p() + 0.5f + offsetZ;
                        this.approachSide = direction;
                        AxisAlignedBB bounds = this.getBoundsAtPos(this.targetX, this.targetY, this.targetZ);
                        if (this.entity.field_70170_p.func_184143_b(bounds)) continue;
                        this.path = this.entity.func_70661_as().func_75488_a(this.targetX, this.targetY, this.targetZ);
                        if (this.path == null) continue;
                        return true;
                    }
                    continue;
                }
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, target)) continue block0;
            }
        }
        return false;
    }

    private AxisAlignedBB getBoundsAtPos(double targetX, double targetY, double targetZ) {
        float widthOffset = this.entity.field_70130_N / 2.0f;
        return new AxisAlignedBB(targetX - (double)widthOffset, targetY, targetZ - (double)widthOffset, targetX + (double)widthOffset, targetY + (double)this.entity.field_70131_O, targetZ + (double)widthOffset);
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75484_a(this.path, this.movementSpeed);
        this.active = true;
        this.gliding = false;
    }

    public void func_75246_d() {
        if (this.reachedTarget) {
            BlockPos currentTrunk = new BlockPos((double)this.targetTrunk.func_177958_n(), this.entity.func_174813_aQ().field_72338_b, (double)this.targetTrunk.func_177952_p());
            if (!this.gliding && this.world.func_175623_d(currentTrunk)) {
                Random random = this.entity.func_70681_au();
                if (random.nextFloat() < 0.3f) {
                    this.entity.func_70024_g((float)(-this.approachSide.func_82601_c()) * 0.1f, 0.2f, (float)(-this.approachSide.func_82599_e()) * 0.1f);
                } else {
                    IBlockState targetState;
                    BlockPos position;
                    Vec3d vec;
                    double z;
                    double x;
                    int i;
                    Vec3d pos = null;
                    for (i = 0; i < 100; ++i) {
                        x = ((double)random.nextFloat() - 0.5) * 45.0;
                        z = ((double)random.nextFloat() - 0.5) * 45.0;
                        vec = this.entity.func_174791_d().func_72441_c(x, 0.0, z);
                        position = new BlockPos(vec);
                        vec = vec.func_72441_c(0.5, -vec.field_72448_b + (double)this.world.func_175672_r(position).func_177956_o() + 0.5, 0.5);
                        targetState = this.entity.field_70170_p.func_180495_p(position);
                        if (!(this.entity.func_174791_d().func_72438_d(vec) > 20.0) || !targetState.func_177230_c().isLeaves(targetState, (IBlockAccess)this.world, position)) continue;
                        pos = vec;
                        break;
                    }
                    if (pos == null) {
                        for (i = 0; i < 100; ++i) {
                            x = ((double)random.nextFloat() - 0.5) * 45.0;
                            z = ((double)random.nextFloat() - 0.5) * 45.0;
                            vec = this.entity.func_174791_d().func_72441_c(x, 0.0, z);
                            position = new BlockPos(vec);
                            vec = vec.func_72441_c(0.5, -vec.field_72448_b + (double)this.world.func_175672_r(position).func_177956_o() + 0.5, 0.5);
                            targetState = this.entity.field_70170_p.func_180495_p(position);
                            if (!(this.entity.func_174791_d().func_72438_d(vec) > 20.0) || targetState.func_185904_a().func_76224_d()) continue;
                            pos = vec;
                            break;
                        }
                    }
                    if (pos != null) {
                        this.entity.setGlidingTo(pos);
                        this.entity.func_70024_g((pos.field_72450_a - this.entity.field_70165_t) * 0.02, 0.2f, (pos.field_72449_c - this.entity.field_70161_v) * 0.02);
                        this.gliding = true;
                        this.entity.setAnimation(EntityAnimation.GLIDING.get());
                    }
                }
                this.active = false;
            } else {
                BlockPos top;
                BlockPos testTrunk = this.targetTrunk;
                boolean accepted = true;
                do {
                    IBlockState state;
                    if (this.world.isSideSolid(testTrunk.func_177972_a(this.approachSide).func_177984_a(), EnumFacing.DOWN)) {
                        accepted = false;
                    }
                    if ((state = this.world.func_180495_p(testTrunk)).func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151575_d) continue;
                    accepted = false;
                } while (this.world.isSideSolid(testTrunk = testTrunk.func_177984_a(), this.approachSide));
                if (accepted) {
                    this.entity.func_70605_aq().func_75642_a(this.targetX, this.entity.func_174813_aQ().field_72338_b, this.targetZ, this.movementSpeed);
                    this.entity.setAnimation(EntityAnimation.CLIMBING.get());
                    if (this.entity.field_70123_F || this.world.isSideSolid(currentTrunk, this.approachSide)) {
                        this.entity.field_70181_x = 0.3;
                        this.entity.func_70107_b(this.targetX, this.entity.field_70163_u, this.targetZ);
                        if (this.entity.func_174831_c(currentTrunk) > 2.0) {
                            this.active = false;
                        }
                    }
                }
                if (this.entity.field_70124_G && !this.gliding && this.isBlockLeaves(top = new BlockPos(this.entity.field_70165_t, this.entity.func_174813_aQ().field_72337_e + 0.1, this.entity.field_70161_v))) {
                    if (this.world.func_175623_d(top.func_177984_a())) {
                        this.entity.func_70107_b(this.targetX, (double)MathHelper.func_76143_f((double)(this.entity.field_70163_u + 1.0)) + 0.2, this.targetZ);
                    } else {
                        this.entity.func_70107_b(this.targetX, this.entity.field_70163_u + 0.2, this.targetZ);
                    }
                }
                this.entity.field_70122_E = true;
            }
        } else if (this.path.func_75879_b()) {
            this.entity.setAnimation(EntityAnimation.START_CLIMBING.get());
            this.reachedTarget = true;
            Vec3d origin = this.entity.func_174791_d().func_72441_c(0.0, (double)this.entity.func_70047_e(), 0.0);
            RayTraceResult traceResult = this.world.func_147447_a(origin, new Vec3d(this.targetX, this.targetY, this.targetZ), false, true, false);
            if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.path = null;
            }
        }
    }

    private boolean isBlockLeaves(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_177230_c().isLeaves(state, (IBlockAccess)this.world, pos);
    }

    public boolean func_75253_b() {
        if (this.path == null || this.world.func_184143_b(this.entity.func_174813_aQ()) && !this.isBlockLeaves(this.entity.func_180425_c())) {
            return false;
        }
        if (!(this.reachedTarget || this.path.func_75879_b() || this.path.func_75876_a(this.entity.func_70661_as().func_75505_d()))) {
            return false;
        }
        return this.active && !this.gliding;
    }

    public void func_75251_c() {
        this.lastActive = this.entity.field_70173_aa;
        this.path = null;
        this.targetTrunk = null;
        this.active = false;
        this.reachedTarget = false;
    }
}

