/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;

public class Family {
    private UUID head;
    private final Set<UUID> parents = new HashSet<UUID>();
    private final Set<UUID> children = new HashSet<UUID>();
    private BlockPos home;
    private int stayHome;

    public Family(UUID ... parents) {
        this.head = parents[0];
        Collections.addAll(this.parents, parents);
    }

    public Family(Set<UUID> parents, Set<UUID> children, BlockPos home) {
        this.parents.addAll(parents);
        this.children.addAll(children);
        this.home = home;
    }

    public boolean update(DinosaurEntity entity) {
        if (this.home == null || entity.func_174831_c(this.home) > 4096.0) {
            this.home = entity.func_180425_c();
        }
        World world = entity.field_70170_p;
        double centerX = 0.0;
        double centerZ = 0.0;
        HashSet<UUID> remove = new HashSet<UUID>();
        HashSet<DinosaurEntity> members = new HashSet<DinosaurEntity>();
        for (UUID parent : this.parents) {
            DinosaurEntity parentEntity = this.get(world, parent);
            if (parentEntity == null || parentEntity.field_70128_L || parentEntity.isCarcass()) {
                remove.add(parent);
                continue;
            }
            centerX += parentEntity.field_70165_t;
            centerZ += parentEntity.field_70161_v;
            members.add(parentEntity);
            parentEntity.family = this;
        }
        for (UUID child : this.children) {
            DinosaurEntity childEntity = this.get(world, child);
            if (childEntity == null || childEntity.field_70128_L || childEntity.isCarcass() || childEntity.getAgePercentage() > 50) {
                remove.add(child);
                continue;
            }
            members.add(childEntity);
            childEntity.family = this;
        }
        this.parents.removeAll(remove);
        this.children.removeAll(remove);
        if (this.parents.isEmpty()) {
            return true;
        }
        if (remove.size() > 0 && !this.parents.contains(this.head) || this.head == null) {
            this.head = this.parents.iterator().next();
        }
        centerX /= (double)this.parents.size();
        centerZ /= (double)this.parents.size();
        if (this.stayHome > 0) {
            --this.stayHome;
            centerX = this.home.func_177958_n();
            centerZ = this.home.func_177952_p();
        } else {
            centerX = (double)(this.home.func_177958_n() / 2) + centerX / 2.0;
            centerZ = (double)(this.home.func_177952_p() / 2) + centerZ / 2.0;
        }
        double centerDistance = entity.func_70092_e(centerX, entity.field_70163_u, centerZ);
        Random random = entity.func_70681_au();
        if (random.nextDouble() * centerDistance > 128.0) {
            for (DinosaurEntity member : members) {
                if (member.func_70638_az() != null || !member.func_70661_as().func_75500_f()) continue;
                int travelX = (int)(centerX + (double)random.nextInt(4) - 2.0);
                int travelZ = (int)(centerZ + (double)random.nextInt(4) - 2.0);
                int travelY = world.func_175672_r(new BlockPos(travelX, 0, travelZ)).func_177956_o();
                member.func_70661_as().func_75492_a((double)travelX, (double)travelY, (double)travelZ, 0.8);
            }
        }
        if (entity.func_70681_au().nextInt(50) == 0 && (entity.getDinosaur().getMetadata().shouldBreedAroundOffspring() || this.children.isEmpty())) {
            DinosaurEntity father = null;
            DinosaurEntity mother = null;
            for (DinosaurEntity member : members) {
                if (!this.parents.contains(member.func_110124_au()) || member.shouldSleep() || member.getBreedCooldown() > 0 || member.isBreeding() || !(member.func_110143_aJ() >= member.func_110138_aP()) || member.getGrowthStage() != GrowthStage.ADULT) continue;
                if (member.isMale()) {
                    father = member;
                    continue;
                }
                mother = member;
            }
            if (father != null && mother != null && father.func_70068_e((Entity)mother) < 128.0) {
                father.func_70661_as().func_75497_a(mother, 1.0);
                mother.func_70661_as().func_75497_a(father, 1.0);
                father.breed(mother);
                mother.breed(father);
            }
        }
        return false;
    }

    private DinosaurEntity get(World world, UUID uuid) {
        for (Entity entity : world.field_72996_f) {
            if (!(entity instanceof DinosaurEntity) || !entity.func_110124_au().equals(uuid)) continue;
            return (DinosaurEntity)entity;
        }
        return null;
    }

    public void addChild(UUID child) {
        this.children.add(child);
    }

    public UUID getHead() {
        return this.head;
    }

    public void writeToNBT(NBTTagCompound familyTag) {
        NBTTagList children = new NBTTagList();
        for (UUID child : this.children) {
            NBTTagCompound childTag = new NBTTagCompound();
            childTag.func_186854_a("UUID", child);
            children.func_74742_a((NBTBase)childTag);
        }
        familyTag.func_74782_a("Children", (NBTBase)children);
        NBTTagList parents = new NBTTagList();
        for (UUID parent : this.parents) {
            NBTTagCompound parentTag = new NBTTagCompound();
            parentTag.func_186854_a("UUID", parent);
            parents.func_74742_a((NBTBase)parentTag);
        }
        familyTag.func_74782_a("Parents", (NBTBase)parents);
        if (this.home != null) {
            familyTag.func_74772_a("Home", this.home.func_177986_g());
        }
        familyTag.func_74768_a("StayHome", this.stayHome);
    }

    public static Family readFromNBT(NBTTagCompound familyTag) {
        int i;
        HashSet<UUID> children = new HashSet<UUID>();
        HashSet<UUID> parents = new HashSet<UUID>();
        NBTTagList parentsList = familyTag.func_150295_c("Parents", 10);
        NBTTagList childrenList = familyTag.func_150295_c("Children", 10);
        for (i = 0; i < parentsList.func_74745_c(); ++i) {
            NBTTagCompound parentTag = parentsList.func_150305_b(i);
            parents.add(parentTag.func_186857_a("UUID"));
        }
        for (i = 0; i < childrenList.func_74745_c(); ++i) {
            NBTTagCompound childTag = childrenList.func_150305_b(i);
            children.add(childTag.func_186857_a("UUID"));
        }
        BlockPos home = null;
        if (familyTag.func_74764_b("Home")) {
            home = BlockPos.func_177969_a((long)familyTag.func_74763_f("Home"));
        }
        Family family = new Family(parents, children, home);
        family.stayHome = familyTag.func_74762_e("StayHome");
        return family;
    }

    public void setHome(BlockPos position, int stay) {
        this.home = position;
        this.stayHome = stay;
    }
}

