/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.MathHelper;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.dinosaur.DilophosaurusEntity;

public class DilophosaurusSpitEntityAI
extends EntityAIBase {
    private final DilophosaurusEntity dilophosaurus;
    private EntityLivingBase target;
    private int rangedAttackTime = -1;
    private double speed;
    private int seeTime;
    private int attackInterval;
    private int maxRangedAttackTime;
    private float attackRadius;
    private float maxAttackDistance;
    private int animationTimer = -1;

    public DilophosaurusSpitEntityAI(DilophosaurusEntity dilophosaurus, double speed, int maxAttackTime, float maxAttackDistance) {
        this(dilophosaurus, speed, maxAttackTime, maxAttackTime, maxAttackDistance);
    }

    public DilophosaurusSpitEntityAI(DilophosaurusEntity dilophosaurus, double speed, int attackInterval, int maxAttackTime, float maxAttackDistance) {
        this.dilophosaurus = dilophosaurus;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistance;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.func_75248_a(8);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.dilophosaurus.func_70638_az();
        if (!(target == null || target.field_70128_L || target instanceof DinosaurEntity && ((DinosaurEntity)target).isCarcass() || target.func_110143_aJ() < target.func_110138_aP() * 0.9f && target.func_70644_a(MobEffects.field_76440_q))) {
            this.target = target;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.dilophosaurus.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
        this.animationTimer = -1;
    }

    public void func_75246_d() {
        float scaledDistance;
        double distance = this.dilophosaurus.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        boolean canSee = this.dilophosaurus.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (distance <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.dilophosaurus.func_70661_as().func_75499_g();
        } else {
            this.dilophosaurus.func_70661_as().func_75497_a((Entity)this.target, this.speed);
        }
        this.dilophosaurus.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (distance > (double)this.maxAttackDistance || !canSee) {
                return;
            }
            this.dilophosaurus.func_184185_a(SoundHandler.DILOPHOSAURUS_SPIT, this.dilophosaurus.func_70599_aP(), this.dilophosaurus.func_70647_i());
            this.dilophosaurus.setAnimation(EntityAnimation.DILOPHOSAURUS_SPIT.get());
            this.animationTimer = 20;
        } else if (this.rangedAttackTime < 0) {
            scaledDistance = MathHelper.func_76133_a((double)distance) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(scaledDistance * (float)(this.maxRangedAttackTime - this.attackInterval) + (float)this.attackInterval));
        }
        if (this.animationTimer >= 0) {
            --this.animationTimer;
        }
        if (this.animationTimer == 0) {
            scaledDistance = MathHelper.func_76133_a((double)distance) / this.attackRadius;
            this.dilophosaurus.func_82196_d(this.target, MathHelper.func_76131_a((float)scaledDistance, (float)0.1f, (float)1.0f));
            this.rangedAttackTime = MathHelper.func_76141_d((float)(scaledDistance * (float)(this.maxRangedAttackTime - this.attackInterval) + (float)this.attackInterval));
        }
    }
}

