/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class BlockRingBuffer
extends AbstractCollection<BlockPos> {
    protected final BlockPos[] entry;
    protected int start = 0;
    protected int end = 0;
    protected boolean full = false;
    protected final int size;

    public BlockRingBuffer(int size) {
        this.size = size;
        this.entry = new BlockPos[size];
    }

    @Override
    public int size() {
        int size = 0;
        size = this.end < this.start ? size - this.start + this.end : (this.end == this.start ? (this.full ? size : 0) : this.end - this.start);
        return size;
    }

    @Override
    public boolean add(@Nonnull BlockPos element) {
        if (this.size() == this.size) {
            this.remove();
        }
        this.entry[this.end++] = element;
        if (this.end >= this.size) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public BlockPos remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty buffer");
        }
        BlockPos element = this.entry[this.start];
        if (null != element) {
            this.entry[this.start++] = null;
            if (this.start >= this.size) {
                this.start = 0;
            }
            this.full = false;
        }
        return element;
    }

    private int increase(int index) {
        if (++index >= this.size) {
            index = 0;
        }
        return index;
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new Iterator<BlockPos>(){
            private int index;
            private int preIndex;
            private boolean isFull;
            {
                this.index = BlockRingBuffer.this.start;
                this.preIndex = -1;
                this.isFull = BlockRingBuffer.this.full;
            }

            @Override
            public boolean hasNext() {
                return this.isFull || this.index != BlockRingBuffer.this.end;
            }

            @Override
            public BlockPos next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Wrongly indexed");
                }
                this.isFull = false;
                this.preIndex = this.index;
                this.index = BlockRingBuffer.this.increase(this.index);
                return BlockRingBuffer.this.entry[this.preIndex];
            }
        };
    }
}

