/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.ai.util.AIUtils;

public class AdvancedSwimEntityAI
extends EntityAIBase {
    private final DinosaurEntity entity;
    private volatile BlockPos shore = null;
    private static ThreadPoolExecutor tpeSwimming = new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private volatile Path path;
    private volatile boolean seti;
    private volatile boolean started = false;

    public AdvancedSwimEntityAI(DinosaurEntity entity) {
        this.entity = entity;
        this.func_75248_a(0);
    }

    public boolean func_75250_a() {
        return this.entity.isSwimming() && this.entity.func_70661_as().func_75500_f() && (this.entity.func_70638_az() == null || this.entity.func_70638_az().field_70128_L) && this.entity.canDinoSwim();
    }

    public void func_75249_e() {
        if (this.started) {
            return;
        }
        if (tpeSwimming.getActiveCount() < 9) {
            try {
                tpeSwimming.execute(new ThreadRunnable(this, this.entity){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        World world = this.entity.field_70170_p;
                        synchronized (world) {
                            this.ai.started = true;
                            BlockPos surface = AIUtils.findSurface((EntityLiving)this.entity);
                            if (surface != null) {
                                this.ai.shore = AIUtils.findShore(this.entity.func_130014_f_(), surface.func_177977_b());
                                if (this.ai.shore != null) {
                                    this.ai.seti = true;
                                }
                            }
                        }
                        this.ai.started = false;
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public boolean func_75253_b() {
        Path currentPath = this.entity.func_70661_as().func_75505_d();
        return this.shore != null && this.path != null && (currentPath == null || !currentPath.func_75879_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_75246_d() {
        block11: {
            try {
                if (this.seti) {
                    this.path = this.entity.func_70661_as().func_179680_a(this.shore.func_177984_a());
                    if (!this.entity.func_70661_as().func_75484_a(this.path, 1.5)) {
                        this.shore = null;
                    }
                    this.seti = false;
                }
                Path currentPath = this.entity.func_70661_as().func_75505_d();
                if (this.shore == null || this.path == null || this.path.func_75876_a(currentPath)) break block11;
                Path path = this.path;
                synchronized (path) {
                    BlockPos blockPos = this.shore;
                    synchronized (blockPos) {
                        Path path2 = this.entity.func_70661_as().func_179680_a(this.shore);
                        if (path2 != null && !path2.func_75876_a(currentPath)) {
                            this.path = path2;
                            this.entity.func_70661_as().func_75484_a(path2, 1.5);
                        }
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    abstract class ThreadRunnable
    implements Runnable {
        final DinosaurEntity entity;
        final AdvancedSwimEntityAI ai;

        ThreadRunnable(AdvancedSwimEntityAI wanderAI, DinosaurEntity entity) {
            this.ai = wanderAI;
            this.entity = entity;
        }
    }
}

