/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

public enum SleepTime {
    DIURNAL(SleepTime.fromTimeToTicks(6, 0), SleepTime.fromTimeToTicks(22, 0)),
    NOCTURNAL(SleepTime.fromTimeToTicks(18, 0), SleepTime.fromTimeToTicks(6, 0)),
    CREPUSCULAR(SleepTime.fromTimeToTicks(12, 30), SleepTime.fromTimeToTicks(4, 30)),
    NO_SLEEP(SleepTime.fromTimeToTicks(0, 0), SleepTime.fromTimeToTicks(0, 0));

    private int wakeUpTime;
    private int sleepTime;
    private boolean sleep;

    private SleepTime(int wakeUpTime, int sleepTime) {
        this.wakeUpTime = wakeUpTime;
        this.sleepTime = sleepTime;
        this.sleep = wakeUpTime != sleepTime;
    }

    public static int fromTimeToTicks(int hour, int minute) {
        int ticksPerMinute = 16;
        return (hour - 6) * 1000 + minute * ticksPerMinute;
    }

    public int getWakeUpTime() {
        return this.wakeUpTime;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public boolean shouldSleepNextDay() {
        return this.wakeUpTime > this.sleepTime;
    }

    public boolean shouldSleep() {
        return this.sleep;
    }

    public int getAwakeTime() {
        int newSleepTime = this.sleepTime;
        if (this.shouldSleepNextDay()) {
            newSleepTime += 24000;
        }
        return newSleepTime - this.wakeUpTime;
    }
}

