/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;

public abstract class FlyingDinosaurEntity
extends DinosaurEntity {
    public FlyingDinosaurEntity(World world) {
        super(world);
        this.field_70765_h = new FlyingMoveHelper();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround());
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.inWater()) {
            this.func_191958_b(strafe, forward, 0.02f, 0.0f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.inLava()) {
            this.func_191958_b(strafe, forward, 0.02f, 0.0f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (friction * friction * friction);
            this.func_191958_b(strafe, forward, this.field_70122_E ? f3 * 0.1f : 0.02f, 0.0f);
            friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double moveX = this.field_70165_t - this.field_70169_q;
        double moveZ = this.field_70161_v - this.field_70166_s;
        float dist = MathHelper.func_76133_a((double)(moveX * moveX + moveZ * moveZ)) * 4.0f;
        if (dist > 1.0f) {
            dist = 1.0f;
        }
        this.field_70721_aZ += (dist - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    class AILookAround
    extends EntityAIBase {
        private FlyingDinosaurEntity dino;

        public AILookAround() {
            this.dino = FlyingDinosaurEntity.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.dino.func_70638_az() == null) {
                this.dino.field_70761_aq = this.dino.field_70177_z = -((float)Math.atan2(this.dino.field_70159_w, this.dino.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase attackTarget = this.dino.func_70638_az();
                double maxDistance = 64.0;
                if (attackTarget.func_70068_e((Entity)this.dino) < maxDistance * maxDistance) {
                    double diffX = attackTarget.field_70165_t - this.dino.field_70165_t;
                    double diffZ = attackTarget.field_70161_v - this.dino.field_70161_v;
                    this.dino.field_70761_aq = this.dino.field_70177_z = -((float)Math.atan2(diffX, diffZ)) * 180.0f / (float)Math.PI;
                }
            }
        }
    }

    class FlyingMoveHelper
    extends EntityMoveHelper {
        private FlyingDinosaurEntity parentEntity;
        private int timer;

        public FlyingMoveHelper() {
            super((EntityLiving)FlyingDinosaurEntity.this);
            this.parentEntity = FlyingDinosaurEntity.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double distanceX = this.field_75646_b - this.parentEntity.field_70165_t;
                double distanceY = this.field_75647_c - this.parentEntity.field_70163_u;
                double distanceZ = this.field_75644_d - this.parentEntity.field_70161_v;
                double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
                if (this.timer-- <= 0) {
                    this.timer += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, distance = (double)MathHelper.func_76133_a((double)distance))) {
                        this.parentEntity.field_70159_w += distanceX / distance * 0.1;
                        this.parentEntity.field_70181_x += distanceY / distance * 0.1;
                        this.parentEntity.field_70179_y += distanceZ / distance * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double distance) {
            double d0 = (x - this.parentEntity.field_70165_t) / distance;
            double d1 = (y - this.parentEntity.field_70163_u) / distance;
            double d2 = (z - this.parentEntity.field_70161_v) / distance;
            AxisAlignedBB bounds = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < distance) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, bounds = bounds.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class AIRandomFly
    extends EntityAIBase {
        private FlyingDinosaurEntity dino;

        public AIRandomFly() {
            this.dino = FlyingDinosaurEntity.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double moveZ;
            double moveY;
            EntityMoveHelper moveHelper = this.dino.func_70605_aq();
            if (!moveHelper.func_75640_a()) {
                return true;
            }
            double moveX = moveHelper.func_179917_d() - this.dino.field_70165_t;
            double distance = moveX * moveX + (moveY = moveHelper.func_179919_e() - this.dino.field_70163_u) * moveY + (moveZ = moveHelper.func_179918_f() - this.dino.field_70161_v) * moveZ;
            return distance < 1.0 || distance > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.dino.func_70681_au();
            double destinationX = this.dino.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double destinationY = this.dino.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double destinationZ = this.dino.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.dino.func_70605_aq().func_75642_a(destinationX, destinationY, destinationZ, 1.0);
        }
    }
}

