/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import java.util.ArrayList;
import java.util.List;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.SleepTime;
import org.jurassicraft.server.food.FoodType;

public enum DinosaurStatus {
    CARNIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getDiet().canEat(entity, FoodType.MEAT);
        }
    }
    ,
    PISCIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getDiet().canEat(entity, FoodType.FISH);
        }
    }
    ,
    HERBIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getDiet().canEat(entity, FoodType.PLANT);
        }
    }
    ,
    INSECTIVOROUS{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getDiet().canEat(entity, FoodType.INSECT);
        }
    }
    ,
    DIURNAL{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getSleepTime() == SleepTime.DIURNAL;
        }
    }
    ,
    NOCTURNAL{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getSleepTime() == SleepTime.NOCTURNAL;
        }
    }
    ,
    CREPUSCULAR{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getMetadata().getSleepTime() == SleepTime.CREPUSCULAR;
        }
    }
    ,
    TAMED{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.getOwner() != null;
        }
    }
    ,
    LOW_HEALTH{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.func_110143_aJ() < entity.func_110138_aP() / 4.0f || entity.isCarcass();
        }
    }
    ,
    HUNGRY{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.hungry;
        }
    }
    ,
    THIRSTY{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.thirsty;
        }
    }
    ,
    POISONED{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.poisoned;
        }
    }
    ,
    DROWNING{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return !entity.getMetadata().isMarineCreature() && entity.func_70086_ai() < 200;
        }
    }
    ,
    SLEEPY{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return entity.shouldSleep();
        }
    }
    ,
    FLOCKING{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.flocking;
        }
    }
    ,
    SCARED{

        @Override
        public boolean apply(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
            return info.scared;
        }
    };


    public static List<DinosaurStatus> getActiveStatuses(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo info) {
        ArrayList<DinosaurStatus> statuses = new ArrayList<DinosaurStatus>();
        for (DinosaurStatus status : DinosaurStatus.values()) {
            if (!status.apply(entity, info)) continue;
            statuses.add(status);
        }
        return statuses;
    }

    public abstract boolean apply(DinosaurEntity var1, DinosaurEntity.FieldGuideInfo var2);
}

