/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Vector3f;
import mcp.MethodsReturnNonnullByDefault;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.client.model.animation.PoseHandler;
import org.jurassicraft.client.model.animation.entity.FixedChainBuffer;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.client.proxy.UsernameCache;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.machine.FeederBlock;
import org.jurassicraft.server.conf.JurassiCraftConfig;
import org.jurassicraft.server.damage.DinosaurDamageSource;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.DinosaurAttributes;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.entity.InventoryDinosaur;
import org.jurassicraft.server.entity.LegSolver;
import org.jurassicraft.server.entity.MetabolismContainer;
import org.jurassicraft.server.entity.SleepTime;
import org.jurassicraft.server.entity.ai.AdvancedSwimEntityAI;
import org.jurassicraft.server.entity.ai.AssistOwnerEntityAI;
import org.jurassicraft.server.entity.ai.DefendOwnerEntityAI;
import org.jurassicraft.server.entity.ai.DinosaurAttackMeleeEntityAI;
import org.jurassicraft.server.entity.ai.DinosaurLookHelper;
import org.jurassicraft.server.entity.ai.DinosaurWanderAvoidWater;
import org.jurassicraft.server.entity.ai.DinosaurWanderEntityAI;
import org.jurassicraft.server.entity.ai.EscapeWireEntityAI;
import org.jurassicraft.server.entity.ai.Family;
import org.jurassicraft.server.entity.ai.FleeEntityAI;
import org.jurassicraft.server.entity.ai.FollowOwnerEntityAI;
import org.jurassicraft.server.entity.ai.Herd;
import org.jurassicraft.server.entity.ai.MateEntityAI;
import org.jurassicraft.server.entity.ai.ProtectInfantEntityAI;
import org.jurassicraft.server.entity.ai.Relationship;
import org.jurassicraft.server.entity.ai.RespondToAttackEntityAI;
import org.jurassicraft.server.entity.ai.SelectTargetEntityAI;
import org.jurassicraft.server.entity.ai.SleepEntityAI;
import org.jurassicraft.server.entity.ai.SmartBodyHelper;
import org.jurassicraft.server.entity.ai.TargetCarcassEntityAI;
import org.jurassicraft.server.entity.ai.TemptNonAdultEntityAI;
import org.jurassicraft.server.entity.ai.animations.CallAnimationAI;
import org.jurassicraft.server.entity.ai.animations.HeadCockAnimationAI;
import org.jurassicraft.server.entity.ai.animations.LookAnimationAI;
import org.jurassicraft.server.entity.ai.animations.RoarAnimationAI;
import org.jurassicraft.server.entity.ai.metabolism.DrinkEntityAI;
import org.jurassicraft.server.entity.ai.metabolism.EatFoodItemEntityAI;
import org.jurassicraft.server.entity.ai.metabolism.FeederEntityAI;
import org.jurassicraft.server.entity.ai.metabolism.GrazeEntityAI;
import org.jurassicraft.server.entity.ai.navigation.DinosaurJumpHelper;
import org.jurassicraft.server.entity.ai.navigation.DinosaurMoveHelper;
import org.jurassicraft.server.entity.ai.navigation.DinosaurPathNavigate;
import org.jurassicraft.server.entity.ai.util.OnionTraverser;
import org.jurassicraft.server.entity.dinosaur.MicroraptorEntity;
import org.jurassicraft.server.entity.dinosaur.TyrannosaurusEntity;
import org.jurassicraft.server.entity.item.DinosaurEggEntity;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.food.FoodType;
import org.jurassicraft.server.genetics.GeneticsHelper;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.message.BiPacketOrder;
import org.jurassicraft.server.message.SetOrderMessage;
import org.jurassicraft.server.plugin.waila.IWailaProvider;
import org.jurassicraft.server.util.GameRuleHandler;
import org.jurassicraft.server.util.LangUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class DinosaurEntity
extends EntityCreature
implements IEntityAdditionalSpawnData,
Animatable,
IWailaProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataParameter<Boolean> WATCHER_IS_CARCASS = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WATCHER_AGE = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> WATCHER_IS_SLEEPING = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATCHER_HAS_TRACKER = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> WATCHER_OWNER_IDENTIFIER = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> WATCHER_CURRENT_ORDER = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> WATCHER_IS_RUNNING = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATCHER_WAS_FED = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATCHER_WAS_MOVED = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    public HashMap<Animation, Byte> variants = new HashMap();
    private final InventoryDinosaur inventory;
    private final MetabolismContainer metabolism;
    protected Dinosaur dinosaur;
    protected int dinosaurAge;
    protected int prevAge;
    protected EntityAITasks animationTasks;
    protected Order order = Order.WANDER;
    private int growthSpeedOffset;
    private boolean isCarcass;
    private boolean wasMoved;
    private int carcassHealth;
    private String genetics;
    private int geneticsQuality;
    private boolean isMale;
    private boolean hasTracker;
    private UUID owner;
    private boolean isSleeping;
    private int tranquilizerTicks;
    private int stayAwakeTime;
    private boolean useInertialTweens;
    private List<Class<? extends EntityLivingBase>> attackTargets = new ArrayList<Class<? extends EntityLivingBase>>();
    private boolean deserializing;
    private int ticksUntilDeath;
    private int attackCooldown;
    @SideOnly(value=Side.CLIENT)
    public FixedChainBuffer tailBuffer;
    public Herd herd;
    public Family family;
    public Set<Relationship> relationships = new HashSet<Relationship>();
    public int wireTicks;
    public int disableHerdingTicks;
    private boolean isSittingNaturally;
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private DinosaurLookHelper lookHelper;
    private BlockPos closestFeeder;
    private int feederSearchTick;
    private boolean inLava;
    private DinosaurAttributes attributes;
    private int breedCooldown;
    private DinosaurEntity breeding;
    private Set<DinosaurEntity> children = new HashSet<DinosaurEntity>();
    private int pregnantTime;
    private int jumpHeight;
    private final LegSolver legSolver;
    private boolean isSkeleton;
    private byte skeletonVariant;
    private boolean isFossile;
    public boolean isRendered;
    private int moveTicks = -5;

    public DinosaurEntity(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70765_h = new DinosaurMoveHelper(this);
        this.field_70767_i = new DinosaurJumpHelper(this);
        this.setFullyGrown();
        this.updateAttributes();
        this.field_70699_by = new DinosaurPathNavigate(this, this.field_70170_p);
        ((DinosaurPathNavigate)this.field_70699_by).func_179693_d(true);
        this.lookHelper = new DinosaurLookHelper(this);
        this.legSolver = this.field_70170_p == null || !this.field_70170_p.field_72995_K ? null : this.createLegSolver();
        this.metabolism = new MetabolismContainer(this);
        this.inventory = new InventoryDinosaur(this);
        this.genetics = GeneticsHelper.randomGenetics(this.field_70146_Z);
        this.isMale = this.field_70146_Z.nextBoolean();
        this.resetAttackCooldown();
        this.animationTick = 0;
        this.setAnimation(EntityAnimation.IDLE.get());
        this.setUseInertialTweens(true);
        this.animationTasks = new EntityAITasks(world.field_72984_F);
        DinosaurMetadata metadata = this.dinosaur.getMetadata();
        if (!metadata.isMarineCreature()) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AdvancedSwimEntityAI(this));
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EscapeWireEntityAI(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinosaurWanderAvoidWater(this, 0.8));
        if (metadata.getDiet().canEat(this, FoodType.PLANT)) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new GrazeEntityAI(this));
        }
        if (metadata.getDiet().canEat(this, FoodType.MEAT)) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new TargetCarcassEntityAI(this));
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RespondToAttackEntityAI(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new TemptNonAdultEntityAI(this, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        if (metadata.shouldDefendOwner()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DefendOwnerEntityAI(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AssistOwnerEntityAI(this));
        }
        if (metadata.shouldFlee()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new FleeEntityAI(this));
        }
        this.field_70714_bg.func_75776_a(2, new ProtectInfantEntityAI<DinosaurEntity>(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinosaurWanderEntityAI(this, 0.8f, 10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new FollowOwnerEntityAI(this));
        this.field_70714_bg.func_75776_a(3, this.getAttackAI());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.animationTasks.func_75776_a(0, (EntityAIBase)new SleepEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new DrinkEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new MateEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new EatFoodItemEntityAI(this));
        this.animationTasks.func_75776_a(1, (EntityAIBase)new FeederEntityAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new CallAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new RoarAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new LookAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new HeadCockAnimationAI(this));
        if (world.field_72995_K) {
            this.initClient();
        }
        this.field_70158_ak = true;
        this.setSkeleton(false);
    }

    @Nullable
    protected LegSolver createLegSolver() {
        return null;
    }

    protected EntityBodyHelper func_184650_s() {
        return new SmartBodyHelper((EntityLiving)this);
    }

    public EntityLookHelper func_70671_ap() {
        return this.lookHelper;
    }

    private void initClient() {
        this.tailBuffer = new FixedChainBuffer();
    }

    public boolean shouldSleep() {
        if (this.metabolism.isDehydrated() || this.metabolism.isStarving()) {
            return false;
        }
        SleepTime sleepTime = this.getMetadata().getSleepTime();
        return sleepTime.shouldSleep() && this.getDinosaurTime() > sleepTime.getAwakeTime() && !this.hasPredators() && (this.herd == null || this.herd.enemies.isEmpty());
    }

    private boolean hasPredators() {
        for (EntityLiving predator : this.field_70170_p.func_175647_a(EntityLiving.class, new AxisAlignedBB(this.field_70165_t - 10.0, this.field_70163_u - 5.0, this.field_70161_v - 10.0, this.field_70165_t + 10.0, this.field_70163_u + 5.0, this.field_70161_v + 10.0), e -> e != this)) {
            DinosaurEntity dinosaur;
            boolean hasDinosaurPredator = false;
            if (predator instanceof DinosaurEntity && (!(dinosaur = (DinosaurEntity)predator).isCarcass() || dinosaur.isSleeping)) {
                for (Class<? extends EntityLivingBase> target : dinosaur.getAttackTargets()) {
                    if (!target.isAssignableFrom(this.getClass())) continue;
                    hasDinosaurPredator = true;
                    break;
                }
            }
            if (this.func_110144_aD() != predator && predator.func_70638_az() != this && !hasDinosaurPredator) continue;
            return true;
        }
        return false;
    }

    public int getDinosaurTime() {
        SleepTime sleepTime = this.getMetadata().getSleepTime();
        long time = this.field_70170_p.func_72820_D() % 24000L - (long)sleepTime.getWakeUpTime();
        if (time < 0L) {
            time += 24000L;
        }
        return (int)time;
    }

    public boolean hasTracker() {
        return this.hasTracker;
    }

    public void setHasTracker(boolean hasTracker) {
        this.hasTracker = hasTracker;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(EntityPlayer player) {
        if (this.getMetadata().isImprintable()) {
            UUID prevOwner = this.owner;
            this.owner = player.func_110124_au();
            if (!this.owner.equals(prevOwner)) {
                player.func_145747_a((ITextComponent)new TextComponentString(LangUtils.translate(LangUtils.TAME, new Object[0]).replace("{dinosaur}", LangUtils.getDinoName(this.dinosaur))));
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isCarcass()) {
            this.setAnimation(EntityAnimation.EATING.get());
        } else {
            this.setAnimation(EntityAnimation.ATTACKING.get());
        }
        while (entity.func_184187_bx() != null) {
            entity = entity.func_184187_bx();
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entity.func_70097_a((DamageSource)new DinosaurDamageSource("mob", (Entity)this), damage)) {
            if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isCarcass()) {
                DinosaurEntity dinosaur = (DinosaurEntity)entity;
                if (dinosaur.herd != null && this.herd != null && dinosaur.herd.fleeing && dinosaur.herd.enemies.contains(this)) {
                    this.herd.enemies.removeAll(dinosaur.herd.members);
                    for (DinosaurEntity member : this.herd) {
                        if (member.func_70638_az() == null || !dinosaur.herd.members.contains(member.func_70638_az())) continue;
                        member.func_70624_b(null);
                    }
                    this.herd.state = Herd.State.IDLE;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean canHarmInCreative = damageSource.func_76357_e();
        Entity attacker = damageSource.func_76346_g();
        if (!this.isCarcass()) {
            if (this.func_110143_aJ() - amount <= 0.0f) {
                if (!canHarmInCreative) {
                    this.func_184185_a(this.getSoundForAnimation(EntityAnimation.DYING.get()), this.func_70599_aP(), this.func_70647_i());
                    this.func_70606_j(this.func_110138_aP());
                    this.setCarcass(true);
                    return true;
                }
                if (attacker instanceof DinosaurEntity) {
                    this.getRelationship(attacker, true).onAttacked(amount);
                }
                return super.func_70097_a(damageSource, amount);
            }
            if (this.getAnimation() == EntityAnimation.RESTING.get() && !this.field_70170_p.field_72995_K) {
                this.setAnimation(EntityAnimation.IDLE.get());
                this.isSittingNaturally = false;
            }
            if (!this.field_70170_p.field_72995_K && !((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f)) {
                this.setAnimation(EntityAnimation.INJURED.get());
            }
            if (this.shouldSleep()) {
                this.disturbSleep();
            }
            if (attacker instanceof EntityLivingBase) {
                this.respondToAttack((EntityLivingBase)attacker);
            }
            return super.func_70097_a(damageSource, amount);
        }
        if (!this.field_70170_p.field_72995_K && !((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f)) {
            if (damageSource != DamageSource.field_76369_e) {
                if (!this.field_70729_aU && this.carcassHealth >= 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    this.dropMeat(attacker);
                }
                if (this.carcassHealth <= 0) {
                    this.func_70645_a(damageSource);
                    this.func_70106_y();
                }
                --this.carcassHealth;
            }
            if (canHarmInCreative) {
                return super.func_70097_a(damageSource, amount);
            }
            if ((float)this.field_70172_ad <= (float)this.field_70771_an / 2.0f) {
                this.field_70738_aO = 10;
                this.field_70737_aN = 10;
            }
        }
        return false;
    }

    private Relationship getRelationship(Entity entity, boolean create) {
        for (Relationship relationship : this.relationships) {
            if (!relationship.getUUID().equals(entity.func_110124_au())) continue;
            return relationship;
        }
        if (create) {
            Relationship relationship = new Relationship(entity.func_110124_au(), 0);
            this.relationships.add(relationship);
            return relationship;
        }
        return null;
    }

    private void dropMeat(Entity attacker) {
        int fortune = 0;
        if (attacker instanceof EntityLivingBase) {
            fortune = EnchantmentHelper.func_185283_h((EntityLivingBase)((EntityLivingBase)attacker));
        }
        int count = this.field_70146_Z.nextInt(2) + 1 + fortune;
        boolean burning = this.func_70027_ad();
        for (int i = 0; i < count; ++i) {
            int meta = EntityHandler.getDinosaurId(this.dinosaur);
            if (burning) {
                this.func_70099_a(new ItemStack((Item)ItemHandler.DINOSAUR_STEAK, 1, meta), 0.0f);
                continue;
            }
            this.dropStackWithGenetics(new ItemStack((Item)ItemHandler.DINOSAUR_MEAT, 1, meta));
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && !this.isCarcass() && !this.isSleeping();
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190916_E() != 0 && stack.func_77973_b() != null) {
            Random rand = new Random();
            EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(rand.nextFloat() * this.field_70130_N - this.field_70130_N / 2.0f), this.field_70163_u + (double)offsetY, this.field_70161_v + (double)(rand.nextFloat() * this.field_70130_N - this.field_70130_N / 2.0f), stack);
            item.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(item);
            } else {
                this.field_70170_p.func_72838_d((Entity)item);
            }
            return item;
        }
        return null;
    }

    public void func_70653_a(Entity entity, float p_70653_2_, double motionX, double motionZ) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float distance = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            float multiplier = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= motionX / (double)distance * (double)multiplier;
            this.field_70179_y -= motionZ / (double)distance * (double)multiplier;
        }
    }

    public void func_70645_a(DamageSource cause) {
        UUID head;
        super.func_70645_a(cause);
        if (this.herd != null) {
            if (this.herd.leader == this) {
                this.herd.updateLeader();
            }
            this.herd.members.remove(this);
        }
        if (this.family != null && ((head = this.family.getHead()) == null || head.equals(this.func_110124_au()))) {
            this.family.update(this);
        }
        if (cause.func_76346_g() instanceof EntityLivingBase) {
            this.respondToAttack((EntityLivingBase)cause.func_76346_g());
        }
    }

    public void func_70642_aH() {
        if (this.getAnimation() == EntityAnimation.IDLE.get()) {
            this.setAnimation(EntityAnimation.SPEAK.get());
            super.func_70642_aH();
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_IS_CARCASS, (Object)this.isCarcass);
        this.field_70180_af.func_187214_a(WATCHER_AGE, (Object)this.dinosaurAge);
        this.field_70180_af.func_187214_a(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
        this.field_70180_af.func_187214_a(WATCHER_HAS_TRACKER, (Object)this.hasTracker);
        this.field_70180_af.func_187214_a(WATCHER_OWNER_IDENTIFIER, (Object)"");
        this.field_70180_af.func_187214_a(WATCHER_CURRENT_ORDER, (Object)0);
        this.field_70180_af.func_187214_a(WATCHER_IS_RUNNING, (Object)false);
        this.field_70180_af.func_187214_a(WATCHER_WAS_FED, (Object)false);
        this.field_70180_af.func_187214_a(WATCHER_WAS_MOVED, (Object)this.wasMoved);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.dinosaur = EntityHandler.getDinosaurByClass(this.getClass());
        this.attributes = DinosaurAttributes.create(this);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public void updateAttributes() {
        DinosaurMetadata metadata = this.getMetadata();
        double prevHealth = this.func_110138_aP();
        double newHealth = Math.max(1.0, this.interpolate(metadata.getBabyHealth(), metadata.getAdultHealth()) * (double)this.attributes.getHealthModifier());
        double speed = this.interpolate(metadata.getBabySpeed(), metadata.getAdultSpeed()) * (double)this.attributes.getSpeedModifier();
        double strength = this.getAttackDamage() * (double)this.attributes.getDamageModifier();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(strength);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        if (prevHealth != newHealth) {
            this.func_70691_i((float)(newHealth - prevHealth));
        }
    }

    private void updateBounds() {
        DinosaurMetadata metadata = this.getMetadata();
        float scale = this.attributes.getScaleModifier();
        float width = MathHelper.func_76131_a((float)((float)this.interpolate(metadata.getBabySizeX(), metadata.getAdultSizeX()) * scale), (float)0.3f, (float)4.0f);
        float height = MathHelper.func_76131_a((float)((float)this.interpolate(metadata.getBabySizeY(), metadata.getAdultSizeY()) * scale), (float)0.3f, (float)4.0f);
        this.field_70138_W = Math.max(1.0f, (float)(Math.ceil(height / 2.0f) / 2.0));
        if (this.isCarcass) {
            this.func_70105_a(Math.min(5.0f, height), width);
        } else {
            this.func_70105_a(width, height);
        }
    }

    public double interpolate(double baby, double adult) {
        int dinosaurAge = this.dinosaurAge;
        int maxAge = this.getMetadata().getMaximumAge();
        if (dinosaurAge > maxAge) {
            dinosaurAge = maxAge;
        }
        return (adult - baby) / (double)maxAge * (double)dinosaurAge + baby;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public void setupDisplay(boolean isMale) {
        this.setFullyGrown();
        this.setMale(isMale);
        this.field_70173_aa = 4;
    }

    public int func_70627_aG() {
        return 200;
    }

    public float func_70647_i() {
        return (float)this.interpolate(2.5, 1.0) + (this.field_70146_Z.nextFloat() - 0.5f) * 0.125f;
    }

    public float func_70599_aP() {
        return this.isCarcass() || this.isSleeping ? 0.0f : 2.0f * (float)this.interpolate(0.2f, 1.0);
    }

    public String getGenetics() {
        return this.genetics;
    }

    public void setGenetics(String genetics) {
        this.genetics = genetics;
    }

    public boolean isEntityFreindly(Entity entity) {
        return this.getClass().isAssignableFrom(entity.getClass());
    }

    public boolean canEatEntity(Entity entity) {
        if (entity instanceof EntityPlayer && (((EntityPlayer)entity).func_184812_l_() || ((EntityPlayer)entity).func_175149_v())) {
            return false;
        }
        return !this.isEntityFreindly(entity);
    }

    @Override
    public void setAnimationWithVariant(Animation newAnimation, byte variant) {
        if (this.isSleeping()) {
            newAnimation = EntityAnimation.SLEEPING.get();
        }
        if (this.isCarcass()) {
            newAnimation = EntityAnimation.DYING.get();
        }
        Animation oldAnimation = this.animation;
        if (!this.field_70170_p.field_72995_K) {
            this.addVariant(newAnimation, variant);
        }
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.dinosaur.getPoseHandler().getAnimationLength(newAnimation, this.getGrowthStage(), this.getAnimationVariant(newAnimation));
            EntityHandler.sendSpecialAnimationMessage(this, newAnimation, this.getAnimationVariant(newAnimation));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this instanceof TyrannosaurusEntity) {
            if (this.moveTicks > 0) {
                --this.moveTicks;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70159_w += (double)MathHelper.func_76126_a((float)(-((float)Math.toRadians(this.field_70177_z - 90.0f)))) * 0.03;
                this.field_70179_y += (double)MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z - 90.0f))) * 0.03;
                this.field_70159_w *= 6.3;
                this.field_70179_y *= 6.3;
            }
            if (this.moveTicks > -5) {
                --this.moveTicks;
                if (this.moveTicks == -4) {
                    this.wasMoved = true;
                }
            }
        }
        if (this.isCarcass() && (!(this instanceof TyrannosaurusEntity) || this.wasMoved) && !(this instanceof MicroraptorEntity)) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.breedCooldown > 0) {
            --this.breedCooldown;
        }
        DinosaurMetadata metadata = this.getMetadata();
        if (!this.field_70170_p.field_72995_K && metadata.getDiet().canEat(this, FoodType.MEAT) && this.getMetabolism().isHungry()) {
            this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0), this::canEatEntity).stream().findAny().ifPresent(arg_0 -> ((DinosaurEntity)this).func_70624_b(arg_0));
        }
        if (!this.isMale() && !this.field_70170_p.field_72995_K) {
            if (this.isPregnant() && --this.pregnantTime <= 0) {
                this.field_70699_by.func_75499_g();
                this.setAnimation(metadata.givesDirectBirth() ? EntityAnimation.GIVING_BIRTH.get() : EntityAnimation.LAYING_EGG.get());
                if (this.family != null) {
                    this.family.setHome(this.func_180425_c(), 6000);
                }
            }
            if ((this.getAnimation() == EntityAnimation.LAYING_EGG.get() || this.getAnimation() == EntityAnimation.GIVING_BIRTH.get()) && this.animationTick == this.getAnimationLength() / 2) {
                for (DinosaurEntity child : this.children) {
                    IEntityAdditionalSpawnData entity;
                    if (metadata.givesDirectBirth()) {
                        entity = child;
                        child.setAge(0);
                        if (this.family != null) {
                            this.family.addChild(entity.func_110124_au());
                        }
                    } else {
                        entity = new DinosaurEggEntity(this.field_70170_p, child, this);
                    }
                    entity.func_70107_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70163_u + 0.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - 0.5f));
                    this.field_70170_p.func_72838_d((Entity)entity);
                }
            }
        }
        if (this.breeding != null) {
            boolean dead;
            if (this.field_70173_aa % 10 == 0) {
                this.func_70661_as().func_75497_a((Entity)this.breeding, 1.0);
            }
            boolean bl = dead = this.breeding.field_70128_L || this.breeding.isCarcass();
            if (dead || this.func_174813_aQ().func_72326_a(this.breeding.func_174813_aQ().func_72321_a(3.0, 3.0, 3.0))) {
                if (!dead) {
                    this.breedCooldown = metadata.getBreedCooldown();
                    if (!this.isMale()) {
                        int minClutch = metadata.getMinClutch();
                        int maxClutch = metadata.getMaxClutch();
                        for (int i = 0; i < this.field_70146_Z.nextInt(maxClutch - minClutch) + minClutch; ++i) {
                            try {
                                DinosaurEntity child = (DinosaurEntity)this.getClass().getConstructor(World.class).newInstance(this.field_70170_p);
                                child.setAge(0);
                                child.setMale(this.field_70146_Z.nextDouble() > 0.5);
                                child.setDNAQuality(Math.min(100, this.getDNAQuality() + this.breeding.getDNAQuality()));
                                DinosaurAttributes attributes = DinosaurAttributes.combine(this, this.getAttributes(), this.breeding.getAttributes());
                                StringBuilder genetics = new StringBuilder();
                                for (int c = 0; c < this.genetics.length(); ++c) {
                                    if (this.field_70146_Z.nextBoolean()) {
                                        genetics.append(this.genetics.charAt(i));
                                        continue;
                                    }
                                    genetics.append(this.breeding.genetics.charAt(i));
                                }
                                child.setGenetics(genetics.toString());
                                child.setAttributes(attributes);
                                this.children.add(child);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.pregnantTime = 9600;
                    }
                }
                this.breeding = null;
            }
        }
        if (this.field_70173_aa % 10 == 0) {
            this.inLava = this.func_180799_ab();
        }
        if (this.isClimbing()) {
            this.field_184618_aE = this.field_70721_aZ;
            double deltaY = (this.field_70163_u - this.field_70167_r) * 4.0;
            if (deltaY > 1.0) {
                deltaY = 1.0;
            }
            this.field_70721_aZ = (float)((double)this.field_70721_aZ + (deltaY - (double)this.field_70721_aZ) * (double)0.4f);
            this.field_184619_aG += this.field_70721_aZ;
        }
        if (!this.isCarcass) {
            if (this.field_70148_d) {
                this.updateAttributes();
            }
            this.updateGrowth();
            if (!this.field_70170_p.field_72995_K) {
                if (this.metabolism.isHungry()) {
                    List entitiesWithinAABB = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0));
                    for (EntityItem itemEntity : entitiesWithinAABB) {
                        Item item = itemEntity.func_92059_d().func_77973_b();
                        if (!FoodHelper.isEdible(this, metadata.getDiet(), item)) continue;
                        this.setAnimation(EntityAnimation.EATING.get());
                        if (itemEntity.func_92059_d().func_190916_E() > 1) {
                            itemEntity.func_92059_d().func_190918_g(1);
                        } else {
                            itemEntity.func_70106_y();
                        }
                        this.getMetabolism().eat(FoodHelper.getHealAmount(item));
                        FoodHelper.applyEatEffects(this, item);
                        this.func_70691_i(10.0f);
                        break;
                    }
                }
                this.metabolism.update();
            }
            if (this.field_70173_aa % 62 == 0) {
                this.func_184185_a(this.getBreathingSound(), this.func_70599_aP(), this.func_70647_i());
            }
            if (!metadata.isMarineCreature()) {
                AxisAlignedBB detectionBox;
                Path path;
                if (this.func_70055_a(Material.field_151586_h) || this.func_70661_as().func_75500_f() && this.inWater() || this.inLava()) {
                    this.func_70683_ar().func_75660_a();
                } else if (this.isSwimming() && (path = this.func_70661_as().func_75505_d()) != null && this.field_70170_p.func_184143_b(detectionBox = this.func_174813_aQ().func_72321_a(0.5, 0.5, 0.5))) {
                    List colliding = this.field_70170_p.func_184144_a((Entity)this.func_94060_bK(), detectionBox);
                    boolean swimUp = false;
                    for (AxisAlignedBB bound : colliding) {
                        if (!(bound.field_72337_e > this.func_174813_aQ().field_72338_b)) continue;
                        swimUp = true;
                        break;
                    }
                    if (swimUp) {
                        this.func_70683_ar().func_75660_a();
                    }
                }
            }
            if (this.herd == null) {
                this.herd = new Herd(this);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.order == Order.WANDER) {
                    if (this.herd.state == Herd.State.IDLE && this.func_70638_az() == null && !this.metabolism.isThirsty() && !this.metabolism.isHungry() && this.func_70661_as().func_75500_f()) {
                        if (!this.isSleeping && this.field_70122_E && !this.func_70090_H() && this.getAnimation() == EntityAnimation.IDLE.get() && this.field_70146_Z.nextInt(800) == 0) {
                            this.setAnimation(EntityAnimation.RESTING.get());
                            this.isSittingNaturally = true;
                        }
                    } else if (this.getAnimation() == EntityAnimation.RESTING.get()) {
                        this.setAnimation(EntityAnimation.IDLE.get());
                        this.isSittingNaturally = false;
                    }
                }
                if (this == this.herd.leader) {
                    this.herd.update();
                }
                if (this.field_70173_aa % 10 == 0) {
                    if (this.family != null && (this.family.getHead() == null || this.family.getHead().equals(this.func_110124_au()))) {
                        if (this.family.update(this)) {
                            this.family = null;
                        }
                    } else if (this.family == null && this.func_70638_az() == null && this.relationships.size() > 0 && this.field_70146_Z.nextDouble() > 0.9) {
                        Object chosen = null;
                        Relationship chosenRelationship = null;
                        for (Relationship relationship : this.relationships) {
                            DinosaurEntity entity;
                            if (!((double)relationship.getScore() > 900.0) || (entity = relationship.get(this)) == null || this.isMale == entity.isMale) continue;
                            chosen = entity;
                            chosenRelationship = relationship;
                            break;
                        }
                        if (chosen != null) {
                            this.family = new Family(this.func_110124_au(), chosen.func_110124_au());
                            chosenRelationship.setFamily();
                            ((DinosaurEntity)chosen).breedCooldown = this.breedCooldown = this.field_70146_Z.nextInt(1000) + 1000;
                        }
                    }
                    if (this.herd != null) {
                        for (DinosaurEntity herdMember : this.herd.members) {
                            if (herdMember == this) continue;
                            Relationship relationship = this.getRelationship((Entity)herdMember, true);
                            relationship.updateHerd(this);
                        }
                        for (EntityLivingBase enemy : this.herd.enemies) {
                            Relationship relationship;
                            if (!(enemy instanceof DinosaurEntity) || this.relationships.contains(relationship = new Relationship(enemy.func_110124_au(), -30))) continue;
                            this.relationships.add(relationship);
                        }
                    }
                    if (this.relationships.size() > 0) {
                        HashSet<Relationship> removal = new HashSet<Relationship>();
                        for (Relationship relationship : this.relationships) {
                            if (!relationship.update(this)) continue;
                            removal.add(relationship);
                        }
                        this.relationships.removeAll(removal);
                    }
                }
                if (!this.func_70661_as().func_75500_f() && this.isSittingNaturally && this.getAnimation() == EntityAnimation.RESTING.get()) {
                    this.setAnimation(EntityAnimation.IDLE.get());
                    this.isSittingNaturally = false;
                }
            }
        }
        if (this.func_70613_aW()) {
            this.lookHelper.func_75649_a();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.field_70180_af.func_187227_b(WATCHER_WAS_FED, (Object)false);
        }
    }

    private void updateGrowth() {
        if (!this.field_70128_L && this.field_70173_aa % 8 == 0 && !this.field_70170_p.field_72995_K) {
            if (GameRuleHandler.DINO_GROWTH.getBoolean(this.field_70170_p)) {
                this.dinosaurAge += Math.min(this.growthSpeedOffset, 960) + 1;
                this.metabolism.decreaseEnergy((int)((double)(Math.min(this.growthSpeedOffset, 960) + 1) * 0.1));
            }
            if (this.growthSpeedOffset > 0) {
                this.growthSpeedOffset -= 10;
                if (this.growthSpeedOffset < 0) {
                    this.growthSpeedOffset = 0;
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && ((Boolean)this.field_70180_af.func_187225_a(WATCHER_WAS_FED)).booleanValue()) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.ticksUntilDeath > 0 && --this.ticksUntilDeath == 0) {
            this.func_184185_a(this.getSoundForAnimation(EntityAnimation.DYING.get()), this.func_70599_aP(), this.func_70647_i());
            this.func_70606_j(this.func_110138_aP());
            this.setCarcass(true);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.animation == EntityAnimation.LEAP.get()) {
                if (this.field_70181_x < 0.0) {
                    this.setAnimation(EntityAnimation.LEAP_LAND.get());
                }
            } else if (this.animation == EntityAnimation.LEAP_LAND.get() && (this.field_70122_E || this.isSwimming())) {
                this.setAnimation(EntityAnimation.IDLE.get());
            }
        }
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean shouldHold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                if (this.animation == EntityAnimation.PREPARE_LEAP.get()) {
                    this.setAnimation(EntityAnimation.LEAP.get());
                } else {
                    this.setAnimation(EntityAnimation.IDLE.get());
                }
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_WAS_MOVED, (Object)this.wasMoved);
            this.field_70180_af.func_187227_b(WATCHER_AGE, (Object)this.dinosaurAge);
            this.field_70180_af.func_187227_b(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
            this.field_70180_af.func_187227_b(WATCHER_IS_CARCASS, (Object)this.isCarcass);
            this.field_70180_af.func_187227_b(WATCHER_HAS_TRACKER, (Object)this.hasTracker);
            this.field_70180_af.func_187227_b(WATCHER_CURRENT_ORDER, (Object)((byte)this.order.ordinal()));
            this.field_70180_af.func_187227_b(WATCHER_OWNER_IDENTIFIER, (Object)(this.owner != null ? this.owner.toString() : ""));
            this.field_70180_af.func_187227_b(WATCHER_IS_RUNNING, (Object)((double)this.func_70689_ay() > this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() ? 1 : 0));
        } else {
            this.updateTailBuffer();
            this.wasMoved = (Boolean)this.field_70180_af.func_187225_a(WATCHER_WAS_MOVED);
            this.dinosaurAge = (Integer)this.field_70180_af.func_187225_a(WATCHER_AGE);
            this.isSleeping = (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_SLEEPING);
            this.isCarcass = (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_CARCASS);
            this.hasTracker = (Boolean)this.field_70180_af.func_187225_a(WATCHER_HAS_TRACKER);
            String owner = (String)this.field_70180_af.func_187225_a(WATCHER_OWNER_IDENTIFIER);
            this.order = Order.values()[(Byte)this.field_70180_af.func_187225_a(WATCHER_CURRENT_ORDER)];
            if (!(owner.length() <= 0 || this.owner != null && owner.equals(this.owner.toString()))) {
                this.owner = UUID.fromString(owner);
            } else if (owner.length() == 0) {
                this.owner = null;
            }
        }
        if (this.field_70173_aa % 20 == 0) {
            this.updateAttributes();
            this.updateBounds();
        }
        if (this.isCarcass) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
        }
        if (this.isSleeping) {
            if (this.getAnimation() != EntityAnimation.SLEEPING.get()) {
                this.setAnimation(EntityAnimation.SLEEPING.get());
            }
        } else if (this.getAnimation() == EntityAnimation.SLEEPING.get()) {
            this.setAnimation(EntityAnimation.IDLE.get());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isCarcass) {
                if (this.getAnimation() != EntityAnimation.DYING.get()) {
                    this.setAnimation(EntityAnimation.DYING.get());
                }
                if (this.field_70173_aa % 1000 == 0) {
                    this.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
            } else {
                if (this.isSleeping) {
                    if (this.field_70173_aa % 20 == 0 && this.stayAwakeTime <= 0 && this.hasPredators()) {
                        this.disturbSleep();
                    }
                    if (!this.shouldSleep() && !this.field_70170_p.field_72995_K && this.tranquilizerTicks-- <= 0) {
                        this.isSleeping = false;
                        this.tranquilizerTicks = 0;
                    }
                } else if (this.getAnimation() == EntityAnimation.SLEEPING.get()) {
                    this.setAnimation(EntityAnimation.IDLE.get());
                }
                if (!this.isSleeping) {
                    if (this.order == Order.SIT) {
                        if (this.getAnimation() != EntityAnimation.RESTING.get()) {
                            this.setAnimation(EntityAnimation.RESTING.get());
                        }
                    } else if (!this.isSittingNaturally && this.getAnimation() == EntityAnimation.RESTING.get() && !this.field_70170_p.field_72995_K) {
                        this.setAnimation(EntityAnimation.IDLE.get());
                    }
                }
            }
        }
        if (!this.shouldSleep() && !this.isSleeping) {
            this.stayAwakeTime = 0;
        }
        if (this.func_70613_aW()) {
            this.animationTasks.func_75774_a();
        }
        if (this.stayAwakeTime > 0) {
            --this.stayAwakeTime;
        }
        if (this.wireTicks > 0) {
            --this.wireTicks;
        }
        if (this.disableHerdingTicks > 0) {
            --this.disableHerdingTicks;
        }
        if (this.legSolver != null) {
            DinosaurMetadata metadata = this.getMetadata();
            double msc = metadata.getScaleInfant() / metadata.getScaleAdult();
            this.legSolver.update((EntityLivingBase)this, (float)this.interpolate(msc, 1.0) * this.getAttributes().getScaleModifier());
        }
        this.prevAge = this.dinosaurAge;
    }

    private void updateTailBuffer() {
        this.tailBuffer.calculateChainSwingBuffer(68.0f, 3, 7.0f, (EntityLivingBase)this);
    }

    public boolean func_70610_aX() {
        return this.isCarcass() || this.isSleeping() || this.animation != null && EntityAnimation.getAnimation(this.animation).doesBlockMovement();
    }

    protected float func_110146_f(float angle, float distance) {
        if (!this.func_70610_aX()) {
            return super.func_110146_f(angle, distance);
        }
        return distance;
    }

    public int getDaysExisted() {
        return (int)Math.floor((float)this.dinosaurAge * 8.0f / 24000.0f);
    }

    public void setFullyGrown() {
        this.setAge(this.getMetadata().getMaximumAge());
    }

    public DinosaurMetadata getMetadata() {
        return this.getDinosaur().getMetadata();
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public int getDinosaurAge() {
        return this.dinosaurAge;
    }

    public void setAge(int age) {
        this.dinosaurAge = age;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_AGE, (Object)this.dinosaurAge);
        }
    }

    public float func_70047_e() {
        DinosaurMetadata metadata = this.getMetadata();
        return (float)this.interpolate(metadata.getBabyEyeHeight(), metadata.getAdultEyeHeight()) * this.attributes.getScaleModifier();
    }

    protected void func_70628_a(boolean playerAttack, int looting) {
        for (String bone : this.getMetadata().getBones()) {
            if (this.field_70146_Z.nextInt(10) == 0) continue;
            this.dropStackWithGenetics(new ItemStack((Item)ItemHandler.FRESH_FOSSILS.get(bone), 1, EntityHandler.getDinosaurId(this.dinosaur)));
        }
    }

    private void dropStackWithGenetics(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("DNAQuality", this.geneticsQuality);
        nbt.func_74768_a("Dinosaur", EntityHandler.getDinosaurId(this.dinosaur));
        nbt.func_74778_a("Genetics", this.genetics);
        stack.func_77982_d(nbt);
        this.func_70099_a(stack, 0.0f);
    }

    @Override
    public boolean isCarcass() {
        return this.isCarcass;
    }

    public void setCarcass(boolean carcass) {
        if (!this.field_70170_p.field_72995_K && carcass != this.isCarcass && !this.wasMoved) {
            this.moveTicks = 18;
        }
        this.isCarcass = carcass;
        boolean carcassAllowed = JurassiCraftConfig.ENTITIES.allowCarcass;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_CARCASS, (Object)this.isCarcass);
        }
        if (carcass && carcassAllowed) {
            this.setAnimation(EntityAnimation.DYING.get());
            this.carcassHealth = MathHelper.func_76125_a((int)Math.max(1, (int)Math.sqrt(this.field_70130_N * this.field_70131_O) * 2), (int)0, (int)10);
            this.field_70173_aa = 0;
            this.inventory.dropItems(this.field_70170_p, this.field_70146_Z);
        } else if (carcass) {
            this.setAnimation(EntityAnimation.DYING.get());
            this.carcassHealth = 0;
            this.inventory.dropItems(this.field_70170_p, this.field_70146_Z);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && hand == EnumHand.MAIN_HAND) {
            if (this.isOwner(player)) {
                if (this.getAgePercentage() > 75) {
                    player.func_71007_a((IInventory)this.inventory);
                } else if (this.field_70170_p.field_72995_K) {
                    TextComponentString denied = new TextComponentString(LangUtils.translate("message.too_young.name", new Object[0]));
                    denied.func_150256_b().func_150238_a(TextFormatting.RED);
                    ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)denied);
                }
            } else if (this.field_70170_p.field_72995_K) {
                TextComponentString denied = new TextComponentString(LangUtils.translate("message.not_owned.name", new Object[0]));
                denied.func_150256_b().func_150238_a(TextFormatting.RED);
                ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)denied);
            }
        } else if (stack.func_190926_b() && hand == EnumHand.MAIN_HAND && this.field_70170_p.field_72995_K) {
            if (this.isOwner(player)) {
                JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new BiPacketOrder(this));
            } else {
                TextComponentString denied = new TextComponentString(LangUtils.translate("message.not_owned.name", new Object[0]));
                denied.func_150256_b().func_150238_a(TextFormatting.RED);
                ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)denied);
            }
        } else if (!stack.func_190926_b() && (this.metabolism.isThirsty() || this.metabolism.isHungry()) && !this.field_70170_p.field_72995_K) {
            Item item = stack.func_77973_b();
            boolean fed = false;
            if (item == Items.field_151068_bn) {
                fed = true;
                this.metabolism.increaseWater(1000);
                this.setAnimation(EntityAnimation.DRINKING.get());
            } else if (FoodHelper.isEdible(this, this.getMetadata().getDiet(), item)) {
                fed = true;
                this.metabolism.eat(FoodHelper.getHealAmount(item));
                this.setAnimation(EntityAnimation.EATING.get());
                FoodHelper.applyEatEffects(this, item);
            }
            if (fed) {
                this.field_70180_af.func_187227_b(WATCHER_WAS_FED, (Object)true);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (item == Items.field_151068_bn) {
                        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                    }
                }
                if (!this.isOwner(player) && (double)this.field_70146_Z.nextFloat() < 0.3) {
                    if (this.getMetadata().getDinosaurType() == Dinosaur.DinosaurType.AGGRESSIVE) {
                        if (this.field_70146_Z.nextFloat() * 4.0f < (float)this.herd.members.size() / (float)this.getMetadata().getMaxHerdSize()) {
                            this.herd.enemies.add((EntityLivingBase)player);
                        } else {
                            this.func_70652_k((Entity)player);
                        }
                    } else if (this.getMetadata().getDinosaurType() == Dinosaur.DinosaurType.SCARED) {
                        this.herd.fleeing = true;
                        this.herd.enemies.add((EntityLivingBase)player);
                    }
                }
                player.func_184609_a(hand);
            }
        }
        return false;
    }

    public boolean isOwner(EntityPlayer player) {
        return player.func_110124_au().equals(this.getOwner());
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && (double)this.field_70130_N < 1.5;
    }

    public int getDNAQuality() {
        return this.geneticsQuality;
    }

    public void setDNAQuality(int quality) {
        this.geneticsQuality = quality;
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void addVariant(Animation animation, byte variant) {
        this.variants.put(animation, variant);
    }

    @Override
    public Class getEntityClass() {
        return this.getClass();
    }

    public void setAnimation(Animation newAnimation) {
        if (this.isSleeping()) {
            newAnimation = EntityAnimation.SLEEPING.get();
        }
        if (this.isCarcass()) {
            newAnimation = EntityAnimation.DYING.get();
        }
        Animation oldAnimation = this.animation;
        byte variant = 0;
        if (!this.field_70170_p.field_72995_K) {
            variant = EntityAnimation.getAnimation(newAnimation).getVariants(this.getEntityClass()) == 1 ? (byte)Math.round(Math.random()) : (byte)(Math.random() * (double)(EntityAnimation.getAnimation(newAnimation).getVariants(this.getEntityClass()) + 1));
            this.addVariant(newAnimation, variant);
        }
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.dinosaur.getPoseHandler().getAnimationLength(newAnimation, this.getGrowthStage(), this.getAnimationVariant(newAnimation));
            EntityHandler.sendSpecialAnimationMessage(this, newAnimation, this.getAnimationVariant(newAnimation));
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean isBusy() {
        return !this.isAlive() || this.getAnimation() == EntityAnimation.IDLE.get() || this.herd != null && this.herd.isBusy() || this.func_70638_az() != null || this.isSwimming() || this.shouldSleep();
    }

    public boolean isAlive() {
        return !this.isCarcass && !this.field_70128_L;
    }

    public SoundEvent func_184639_G() {
        return this.getSoundForAnimation(EntityAnimation.SPEAK.get());
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.getSoundForAnimation(EntityAnimation.INJURED.get());
    }

    public SoundEvent func_184615_bR() {
        return this.getSoundForAnimation(EntityAnimation.DYING.get());
    }

    public SoundEvent getSoundForAnimation(Animation animation) {
        return null;
    }

    public SoundEvent getBreathingSound() {
        return null;
    }

    public double getAttackDamage() {
        DinosaurMetadata metadata = this.getMetadata();
        return this.interpolate(metadata.getBabyStrength(), metadata.getAdultStrength());
    }

    public boolean isMale() {
        return this.isMale;
    }

    public boolean isPregnant() {
        return !this.isMale() && this.pregnantTime > 0;
    }

    public void setMale(boolean male) {
        this.isMale = male;
    }

    public int getAgePercentage() {
        int age = this.getDinosaurAge();
        return age != 0 ? age * 100 / this.getMetadata().getMaximumAge() : 0;
    }

    @Override
    public GrowthStage getGrowthStage() {
        if (this.isSkeleton) {
            return GrowthStage.SKELETON;
        }
        int percent = this.getAgePercentage();
        return percent > 75 ? GrowthStage.ADULT : (percent > 50 ? GrowthStage.ADOLESCENT : (percent > 25 ? GrowthStage.JUVENILE : GrowthStage.INFANT));
    }

    public void increaseGrowthSpeed() {
        this.growthSpeedOffset += 240;
    }

    public int getBreedCooldown() {
        return this.breedCooldown;
    }

    public void breed(DinosaurEntity partner) {
        this.breeding = partner;
    }

    @Override
    public boolean isSwimming() {
        return (this.func_70090_H() || this.inLava()) && !this.field_70122_E;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        nbt = super.func_189511_e(nbt);
        nbt.func_74768_a("DinosaurAge", this.dinosaurAge);
        nbt.func_74757_a("IsCarcass", this.isCarcass);
        nbt.func_74768_a("DNAQuality", this.geneticsQuality);
        nbt.func_74778_a("Genetics", this.genetics);
        nbt.func_74757_a("IsMale", this.isMale);
        nbt.func_74768_a("GrowthSpeedOffset", this.growthSpeedOffset);
        nbt.func_74768_a("StayAwakeTime", this.stayAwakeTime);
        nbt.func_74757_a("IsSleeping", this.isSleeping);
        nbt.func_74774_a("Order", (byte)this.order.ordinal());
        nbt.func_74768_a("CarcassHealth", this.carcassHealth);
        nbt.func_74768_a("BreedCooldown", this.breedCooldown);
        nbt.func_74768_a("PregnantTime", this.pregnantTime);
        nbt.func_74757_a("WasMoved", this.wasMoved);
        this.metabolism.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("OwnerUUID", this.owner.toString());
        }
        this.inventory.writeToNBT(nbt);
        if (this.family != null && (this.family.getHead() == null || this.family.getHead().equals(this.func_110124_au()))) {
            NBTTagCompound familyTag = new NBTTagCompound();
            this.family.writeToNBT(familyTag);
            nbt.func_74782_a("Family", (NBTBase)familyTag);
        }
        NBTTagList relationshipList = new NBTTagList();
        for (Relationship relationship : this.relationships) {
            NBTTagCompound compound = new NBTTagCompound();
            relationship.writeToNBT(compound);
            relationshipList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Relationships", (NBTBase)relationshipList);
        NBTTagCompound attributes = new NBTTagCompound();
        this.attributes.writeToNBT(attributes);
        nbt.func_74782_a("GeneticAttributes", (NBTBase)attributes);
        if (this.children.size() > 0) {
            NBTTagList children = new NBTTagList();
            for (DinosaurEntity child : this.children) {
                if (child == null) continue;
                children.func_74742_a((NBTBase)child.func_189511_e(new NBTTagCompound()));
            }
            nbt.func_74782_a("Children", (NBTBase)children);
        }
        nbt.func_74768_a("TranquilizerTicks", this.tranquilizerTicks);
        nbt.func_74768_a("TicksUntilDeath", this.ticksUntilDeath);
        return nbt;
    }

    @Override
    public byte getAnimationVariant(Animation animation) {
        return this.variants.getOrDefault(animation, (byte)0);
    }

    @Override
    public HashMap<Animation, Byte> getVariants() {
        return this.variants;
    }

    public void func_70020_e(NBTTagCompound nbt) {
        this.deserializing = true;
        super.func_70020_e(nbt);
        this.wasMoved = nbt.func_74767_n("WasMoved");
        this.setAge(nbt.func_74762_e("DinosaurAge"));
        this.setCarcass(nbt.func_74767_n("IsCarcass"));
        this.geneticsQuality = nbt.func_74762_e("DNAQuality");
        this.genetics = nbt.func_74779_i("Genetics");
        this.isMale = nbt.func_74767_n("IsMale");
        this.growthSpeedOffset = nbt.func_74762_e("GrowthSpeedOffset");
        this.stayAwakeTime = nbt.func_74762_e("StayAwakeTime");
        this.setSleeping(nbt.func_74767_n("IsSleeping"));
        this.carcassHealth = nbt.func_74762_e("CarcassHealth");
        this.order = Order.values()[nbt.func_74771_c("Order")];
        this.breedCooldown = nbt.func_74762_e("BreedCooldown");
        this.pregnantTime = nbt.func_74762_e("PregnantTime");
        this.metabolism.readFromNBT(nbt);
        String ownerUUID = nbt.func_74779_i("OwnerUUID");
        if (ownerUUID.length() > 0) {
            this.owner = UUID.fromString(ownerUUID);
        }
        if (nbt.func_74764_b("Family")) {
            NBTTagCompound familyTag = nbt.func_74775_l("Family");
            this.family = Family.readFromNBT(familyTag);
        }
        this.inventory.readFromNBT(nbt);
        NBTTagList relationships = nbt.func_150295_c("Relationships", 10);
        for (int i = 0; i < relationships.func_74745_c(); ++i) {
            NBTTagCompound compound = relationships.func_150305_b(i);
            this.relationships.add(Relationship.readFromNBT(compound));
        }
        if (nbt.func_74764_b("GeneticAttributes")) {
            NBTTagCompound attributes = nbt.func_74775_l("GeneticAttributes");
            this.attributes = DinosaurAttributes.from(attributes);
        }
        if (nbt.func_74764_b("Children")) {
            NBTTagList children = nbt.func_150295_c("Children", 10);
            for (int i = 0; i < children.func_74745_c(); ++i) {
                NBTTagCompound childTag = children.func_150305_b(i);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)childTag, (World)this.field_70170_p);
                if (!(entity instanceof DinosaurEntity)) continue;
                this.children.add((DinosaurEntity)entity);
            }
        }
        this.tranquilizerTicks = nbt.func_74762_e("TranquilizerTicks");
        this.ticksUntilDeath = nbt.func_74762_e("TicksUntilDeath");
        this.updateAttributes();
        this.updateBounds();
        this.deserializing = false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.dinosaurAge);
        buffer.writeBoolean(this.isCarcass);
        buffer.writeInt(this.geneticsQuality);
        buffer.writeBoolean(this.isMale);
        buffer.writeInt(this.growthSpeedOffset);
        this.attributes.write(buffer);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.dinosaurAge = additionalData.readInt();
        this.isCarcass = additionalData.readBoolean();
        this.geneticsQuality = additionalData.readInt();
        this.isMale = additionalData.readBoolean();
        this.growthSpeedOffset = additionalData.readInt();
        this.attributes = DinosaurAttributes.from(additionalData);
        if (this.isCarcass) {
            this.setAnimation(EntityAnimation.DYING.get());
        }
        this.updateAttributes();
        this.updateBounds();
    }

    public MetabolismContainer getMetabolism() {
        return this.metabolism;
    }

    public boolean setSleepLocation(BlockPos sleepLocation, boolean moveTo) {
        return !moveTo || this.func_70661_as().func_75492_a((double)sleepLocation.func_177958_n(), (double)sleepLocation.func_177956_o(), (double)sleepLocation.func_177952_p(), 1.0);
    }

    @Override
    public boolean isSleeping() {
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.isSleeping = sleeping;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
        }
    }

    public void tranquilize(int ticks) {
        this.tranquilizerTicks = 50 + ticks + this.field_70146_Z.nextInt(50);
        this.setSleeping(true);
    }

    public int getStayAwakeTime() {
        return this.stayAwakeTime;
    }

    public void disturbSleep() {
        if (this.tranquilizerTicks == 0) {
            this.isSleeping = false;
            this.stayAwakeTime = 400;
        }
    }

    public void writeStatsToLog() {
        LOGGER.info((Object)this);
    }

    public String toString() {
        return "DinosaurEntity{ " + this.dinosaur.getIdentifier() + ", id=" + this.func_145782_y() + ", remote=" + this.func_130014_f_().field_72995_K + ", isDead=" + this.field_70128_L + ", isCarcass=" + this.isCarcass + ", isSleeping=" + this.isSleeping + ", stayAwakeTime=" + this.stayAwakeTime + "\n    , dinosaurAge=" + this.dinosaurAge + ", prevAge=" + this.prevAge + ", maxAge" + this.getMetadata().getMaximumAge() + ", ticksExisted=" + this.field_70173_aa + ", entityAge=" + this.field_70708_bq + ", isMale=" + this.isMale + ", growthSpeedOffset=" + this.growthSpeedOffset + "\n    , food=" + this.metabolism.getEnergy() + " / " + this.metabolism.getMaxEnergy() + " (" + (double)this.metabolism.getMaxEnergy() * 0.875 + "), water=" + this.metabolism.getWater() + " / " + this.metabolism.getMaxWater() + " (" + (double)this.metabolism.getMaxWater() * 0.875 + "), digestingFood=" + this.metabolism.getDigestingFood() + " / " + 3000 + ", health=" + this.func_110143_aJ() + " / " + this.func_110138_aP() + "\n    , pos=" + this.func_180425_c() + ", eyePos=" + this.getHeadPos() + ", eyeHeight=" + this.func_70047_e() + ", lookX=" + this.func_70671_ap().func_180423_e() + ", lookY=" + this.func_70671_ap().func_180422_f() + ", lookZ=" + this.func_70671_ap().func_180421_g() + "\n    , width=" + this.field_70130_N + ", bb=" + this.func_174813_aQ() + " }";
    }

    public Vec3d getHeadPos() {
        DinosaurMetadata metadata = this.getMetadata();
        double scale = this.interpolate(metadata.getScaleInfant(), metadata.getScaleAdult());
        double[] headPos = this.dinosaur.getHeadPosition(this.getGrowthStage(), (360.0f - this.field_70759_as) % 360.0f - 180.0f);
        double headX = (headPos[0] * 0.0625 - (double)metadata.getOffsetX()) * scale;
        double headY = ((24.0 - headPos[1]) * 0.0625 - (double)metadata.getOffsetY()) * scale;
        double headZ = (headPos[2] * 0.0625 - (double)metadata.getOffsetZ()) * scale;
        return new Vec3d(this.field_70165_t + headX, this.field_70163_u + headY, this.field_70161_v + headZ);
    }

    public boolean areEyelidsClosed() {
        return this.field_70173_aa == 4 ? false : !this.getMetadata().isMarineCreature() && (this.isCarcass || this.isSleeping || this.field_70173_aa % 100 < this.getMetadata().getEyeTime());
    }

    @Override
    public boolean shouldUseInertia() {
        return this.useInertialTweens;
    }

    public void setUseInertialTweens(boolean parUseInertialTweens) {
        this.useInertialTweens = parUseInertialTweens;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)ItemHandler.SPAWN_EGG, 1, EntityHandler.getDinosaurId(this.dinosaur));
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        if (this.inWater() && !this.canDinoSwim()) {
            friction *= 10.0f;
        }
        super.func_191958_b(strafe, up, forward, friction);
    }

    public void giveBirth() {
        this.pregnantTime = 1;
    }

    public void setDeathIn(int ticks) {
        this.ticksUntilDeath = ticks;
        this.func_70690_d(new PotionEffect(MobEffects.field_76436_u, ticks));
    }

    public void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.isSleeping && !this.func_184223_x(entity) && !entity.field_70145_X && !this.field_70145_X && entity.getClass() != this.getClass()) {
            this.disturbSleep();
        }
    }

    protected void func_70105_a(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float prevWidth = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (!this.deserializing) {
                AxisAlignedBB bounds = this.func_174813_aQ();
                AxisAlignedBB newBounds = new AxisAlignedBB(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, bounds.field_72340_a + (double)this.field_70130_N, bounds.field_72338_b + (double)this.field_70131_O, bounds.field_72339_c + (double)this.field_70130_N);
                if (!this.field_70170_p.func_184143_b(newBounds)) {
                    this.func_174826_a(newBounds);
                    if (this.field_70130_N > prevWidth && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                        this.func_70091_d(MoverType.SELF, prevWidth - this.field_70130_N, 0.0, prevWidth - this.field_70130_N);
                    }
                }
            } else {
                float halfWidth = this.field_70130_N / 2.0f;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)halfWidth, this.field_70163_u, this.field_70161_v - (double)halfWidth, this.field_70165_t + (double)halfWidth, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)halfWidth));
            }
        }
    }

    @Override
    public List<String> getWailaData(List<String> list) {
        list.add(TextFormatting.GOLD + LangUtils.translate("gender.name", new Object[0]) + ": " + TextFormatting.WHITE + LangUtils.getGenderMode(this.isMale() ? 1 : 2));
        String name = "<MALFORMED>";
        if (this.getOwner() == null) {
            name = LangUtils.translate("message.not_imprinted.name", new Object[0]);
        } else {
            String temp = UsernameCache.getPlayerName(this.getOwner());
            if (temp != null && !temp.equals("")) {
                name = temp;
            }
        }
        list.add(TextFormatting.GOLD + LangUtils.translate("status.owner.name", new Object[0]) + ": " + TextFormatting.WHITE + name);
        list.add(TextFormatting.GOLD + LangUtils.translate("order.name", new Object[0]) + ": " + TextFormatting.WHITE + LangUtils.translate("order." + this.getOrder().name().toLowerCase(Locale.ENGLISH) + ".name", new Object[0]));
        return list;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setFieldOrder(Order order) {
        this.order = order;
        this.field_70180_af.func_187227_b(WATCHER_CURRENT_ORDER, (Object)((byte)order.ordinal()));
    }

    public void setOrder(Order order) {
        if (this.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (this.owner != null && (player = this.field_70170_p.func_152378_a(this.owner)) != null) {
                TextComponentString change = new TextComponentString(LangUtils.translate(LangUtils.SET_ORDER, new Object[0]).replace("{order}", LangUtils.translate(LangUtils.ORDER_VALUE.get(order.name().toLowerCase(Locale.ENGLISH)), new Object[0])));
                change.func_150256_b().func_150238_a(TextFormatting.GOLD);
                ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new SetOrderMessage(this));
        }
    }

    @SafeVarargs
    public final void target(Class<? extends EntityLivingBase> ... targets) {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new SelectTargetEntityAI(this, targets));
        this.attackTargets.addAll(Lists.newArrayList((Object[])targets));
    }

    public EntityAIBase getAttackAI() {
        return new DinosaurAttackMeleeEntityAI(this, this.getMetadata().getAttackSpeed(), false);
    }

    public List<Class<? extends EntityLivingBase>> getAttackTargets() {
        return this.attackTargets;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.metabolism.setEnergy(this.metabolism.getMaxEnergy());
        this.metabolism.setWater(this.metabolism.getMaxWater());
        this.genetics = GeneticsHelper.randomGenetics(this.field_70146_Z);
        this.setFullyGrown();
        this.setMale(this.field_70146_Z.nextBoolean());
        this.setDNAQuality(100);
        this.updateBounds();
        return data;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void resetAttackCooldown() {
        this.attackCooldown = 50 + this.func_70681_au().nextInt(20);
    }

    public void respondToAttack(EntityLivingBase attacker) {
        if (!(attacker == null || attacker.field_70128_L || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71075_bZ.field_75098_d)) {
            LinkedList<EntityLivingBase> enemies = new LinkedList<EntityLivingBase>();
            if (attacker instanceof DinosaurEntity) {
                DinosaurEntity enemyDinosaur = (DinosaurEntity)attacker;
                if (enemyDinosaur.herd != null) {
                    enemies.addAll(enemyDinosaur.herd.members);
                }
            } else {
                enemies.add(attacker);
            }
            if (enemies.size() > 0) {
                Herd herd = this.herd;
                if (herd != null) {
                    herd.fleeing = !herd.shouldDefend(enemies) || this.getMetadata().shouldFlee();
                    for (EntityLivingBase entity : enemies) {
                        if (herd.enemies.contains(entity)) continue;
                        herd.enemies.add(entity);
                    }
                } else {
                    this.func_70624_b((EntityLivingBase)enemies.get(this.func_70681_au().nextInt(enemies.size())));
                }
            }
        }
    }

    public int getAnimationLength() {
        return this.animationLength;
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_RUNNING);
    }

    public boolean func_70601_bi() {
        return this.field_71093_bK == 0;
    }

    public boolean shouldEscapeWaterFast() {
        return true;
    }

    public BlockPos getClosestFeeder() {
        if (this.field_70173_aa - this.feederSearchTick > 200) {
            this.feederSearchTick = this.field_70173_aa;
            OnionTraverser traverser = new OnionTraverser(this.func_180425_c(), 32);
            for (BlockPos pos : traverser) {
                Path path;
                FeederBlockEntity feeder;
                TileEntity tile;
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof FeederBlock) || !((tile = this.field_70170_p.func_175625_s(pos)) instanceof FeederBlockEntity) || !(feeder = (FeederBlockEntity)tile).canFeedDinosaur(this) || feeder.getFeeding() != null || feeder.openAnimation != 0 || (path = this.func_70661_as().func_179680_a(pos)) == null || path.func_75874_d() == 0) continue;
                this.closestFeeder = pos;
                return this.closestFeeder;
            }
        }
        return this.closestFeeder;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    @Override
    public boolean isMoving() {
        float deltaX = (float)(this.field_70165_t - this.field_70169_q);
        float deltaZ = (float)(this.field_70161_v - this.field_70166_s);
        return deltaX * deltaX + deltaZ * deltaZ > 0.001f;
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return this.dinosaur.doesSupportGrowthStage(growthStage);
    }

    @Override
    public boolean isMarineCreature() {
        return this.getMetadata().isMarineCreature();
    }

    @Override
    public <ENTITY extends EntityLivingBase> PoseHandler<ENTITY> getPoseHandler() {
        return this.dinosaur.getPoseHandler();
    }

    @Override
    public boolean inWater() {
        return this.func_70090_H();
    }

    @Override
    public boolean inLava() {
        return this.inLava;
    }

    public DinosaurAttributes getAttributes() {
        return this.attributes;
    }

    public boolean isBreeding() {
        return this.breeding != null;
    }

    public void setAttributes(DinosaurAttributes attributes) {
        this.attributes = attributes;
    }

    public void setJumpHeight(int jumpHeight) {
        this.jumpHeight = jumpHeight;
    }

    protected float func_175134_bD() {
        return (float)Math.sqrt(((double)this.jumpHeight + 0.2) * 0.27);
    }

    public boolean isSkeleton() {
        return this.getGrowthStage() == GrowthStage.SKELETON;
    }

    public void setSkeleton(boolean isSkeleton) {
        this.isSkeleton = isSkeleton;
    }

    public void setSkeletonVariant(byte variant) {
        this.skeletonVariant = variant;
    }

    public byte getSkeletonVariant() {
        return this.skeletonVariant;
    }

    public void setIsFossile(boolean isFossile) {
        this.isFossile = isFossile;
    }

    public boolean getIsFossile() {
        return this.isFossile;
    }

    public boolean canDinoSwim() {
        return this.getGrowthStage() != GrowthStage.INFANT && this.getGrowthStage() != GrowthStage.JUVENILE;
    }

    public Vector3f getDinosaurCultivatorRotation() {
        return new Vector3f();
    }

    protected void func_70629_bd() {
        if (this.canDinoSwim()) {
            super.func_70629_bd();
        }
    }

    public static enum Order {
        WANDER,
        FOLLOW,
        SIT;

    }

    public static class FieldGuideInfo {
        public int hunger;
        public int thirst;
        public boolean flocking;
        public boolean scared;
        public boolean hungry;
        public boolean thirsty;
        public boolean poisoned;

        public static FieldGuideInfo deserialize(ByteBuf buf) {
            FieldGuideInfo info = new FieldGuideInfo();
            info.flocking = buf.readBoolean();
            info.scared = buf.readBoolean();
            info.hunger = buf.readInt();
            info.thirst = buf.readInt();
            info.hungry = buf.readBoolean();
            info.thirsty = buf.readBoolean();
            info.poisoned = buf.readBoolean();
            return info;
        }

        public static FieldGuideInfo serialize(ByteBuf buf, DinosaurEntity entity) {
            MetabolismContainer metabolism = entity.getMetabolism();
            Herd herd = entity.herd;
            FieldGuideInfo info = new FieldGuideInfo();
            info.flocking = herd != null && herd.members.size() > 1 && herd.state == Herd.State.MOVING;
            info.scared = herd != null && herd.fleeing;
            info.hunger = metabolism.getEnergy();
            info.thirst = metabolism.getWater();
            info.hungry = metabolism.isHungry();
            info.thirsty = metabolism.isThirsty();
            info.poisoned = entity.func_70644_a(MobEffects.field_76436_u);
            buf.writeBoolean(info.flocking);
            buf.writeBoolean(info.scared);
            buf.writeInt(info.hunger);
            buf.writeInt(info.thirst);
            buf.writeBoolean(info.hungry);
            buf.writeBoolean(info.thirsty);
            buf.writeBoolean(info.poisoned);
            return info;
        }
    }
}

