/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import org.jurassicraft.server.entity.DinosaurEntity;

public class DinosaurAttributes {
    private static final float MINIMUM_SCALE = 0.8f;
    private static final float MAXIMUM_SCALE = 1.2f;
    private static final float MINIMUM_DAMAGE = 0.8f;
    private static final float MAXIMUM_DAMAGE = 1.2f;
    private static final float MINIMUM_HEALTH = 0.8f;
    private static final float MAXIMUM_HEALTH = 1.2f;
    private static final float MINIMUM_SPEED = 0.8f;
    private static final float MAXIMUM_SPEED = 1.2f;
    private float scaleModifier;
    private float damageModifier;
    private float healthModifier;
    private float speedModifier;

    private DinosaurAttributes(float scaleModifier, float damageModifier, float healthModifier, float speedModifier) {
        this.scaleModifier = scaleModifier;
        this.damageModifier = damageModifier;
        this.healthModifier = healthModifier;
        this.speedModifier = speedModifier;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74776_a("Scale", this.scaleModifier);
        compound.func_74776_a("Damage", this.damageModifier);
        compound.func_74776_a("Health", this.healthModifier);
        compound.func_74776_a("Speed", this.speedModifier);
    }

    public void write(ByteBuf buf) {
        buf.writeFloat(this.scaleModifier);
    }

    public static DinosaurAttributes combine(DinosaurEntity entity, DinosaurAttributes attributes1, DinosaurAttributes attributes2) {
        Random random = entity.func_70681_au();
        float scale = DinosaurAttributes.random(random, attributes1.scaleModifier, attributes2.scaleModifier);
        if (random.nextInt(3) == 0) {
            scale = DinosaurAttributes.random(random, 0.8f, 1.2f);
        }
        float scaleStat = (2.0f + scale) / 3.0f;
        float damage = DinosaurAttributes.random(random, attributes1.damageModifier, attributes2.damageModifier);
        if (random.nextInt(3) == 0) {
            damage = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        }
        float health = DinosaurAttributes.random(random, attributes1.healthModifier, attributes2.healthModifier);
        if (random.nextInt(3) == 0) {
            health = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        }
        float speed = DinosaurAttributes.random(random, attributes1.speedModifier, attributes2.speedModifier);
        if (random.nextInt(3) == 0) {
            speed = DinosaurAttributes.random(random, 0.8f, 1.2f) / scaleStat;
        }
        return new DinosaurAttributes(scale, damage, health, speed);
    }

    public static DinosaurAttributes create(DinosaurEntity entity) {
        Random random = entity.func_70681_au();
        float scale = DinosaurAttributes.random(random, 0.8f, 1.2f);
        float scaleStat = (2.0f + scale) / 3.0f;
        float damage = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        float health = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        float speed = DinosaurAttributes.random(random, 0.8f, 1.2f) / scaleStat;
        return new DinosaurAttributes(scale, damage, health, speed);
    }

    public static DinosaurAttributes from(NBTTagCompound compound) {
        float scaleModifier = compound.func_74760_g("Scale");
        float damageModifier = compound.func_74760_g("Damage");
        float healthModifier = compound.func_74760_g("Health");
        float speedModifier = compound.func_74760_g("Speed");
        return new DinosaurAttributes(scaleModifier, damageModifier, healthModifier, speedModifier);
    }

    public static DinosaurAttributes from(ByteBuf buf) {
        float scale = buf.readFloat();
        return new DinosaurAttributes(scale, 1.0f, 1.0f, 1.0f);
    }

    private static float random(Random random, float v1, float v2) {
        float minimum = Math.min(v1, v2);
        float maximum = Math.max(v1, v2);
        float range = maximum - minimum;
        return (float)(random.nextDouble() * (double)range + (double)minimum);
    }

    public float getScaleModifier() {
        return this.scaleModifier;
    }

    public float getHealthModifier() {
        return this.healthModifier;
    }

    public float getDamageModifier() {
        return this.damageModifier;
    }

    public float getSpeedModifier() {
        return this.speedModifier;
    }

    public void setScaleModifier(float scaleModifier) {
        this.scaleModifier = scaleModifier;
    }
}

