/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.AnimalMetadata;

public abstract class Animal
implements Comparable<Animal> {
    private final AnimalMetadata metadata = this.buildMetadata();

    protected abstract AnimalMetadata buildMetadata();

    public int hashCode() {
        return this.metadata.getIdentifier().hashCode();
    }

    @Override
    public int compareTo(Animal dinosaur) {
        return this.getIdentifier().compareTo(dinosaur.getIdentifier());
    }

    public boolean equals(Object object) {
        return object instanceof Animal && ((Animal)object).getIdentifier().equals((Object)this.getIdentifier());
    }

    public EntityLivingBase construct(World world) {
        return this.metadata.construct(world);
    }

    public AnimalMetadata getMetadata() {
        return this.metadata;
    }

    public ResourceLocation getIdentifier() {
        return this.getMetadata().getIdentifier();
    }

    public String getLocalizedName() {
        ResourceLocation identifier = this.metadata.getIdentifier();
        return I18n.func_74838_a((String)("entity." + identifier.func_110624_b() + "." + identifier.func_110623_a() + ".name"));
    }
}

