/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.dinosaur;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.PoseHandler;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.api.GrowthStageGenderContainer;
import org.jurassicraft.server.api.SkeletonOverlayContainer;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.entity.OverlayType;
import org.jurassicraft.server.tabula.TabulaModelHelper;

public abstract class Dinosaur
implements Comparable<Dinosaur> {
    private final Map<GrowthStage, ResourceLocation> maleTextures = new EnumMap<GrowthStage, ResourceLocation>(GrowthStage.class);
    private final Map<GrowthStage, ResourceLocation> femaleTextures = new EnumMap<GrowthStage, ResourceLocation>(GrowthStage.class);
    private final Map<GrowthStage, TabulaModelContainer> models = new EnumMap<GrowthStage, TabulaModelContainer>(GrowthStage.class);
    private final Map<String, TabulaModelContainer> skeletonModels = new HashMap<String, TabulaModelContainer>();
    private final Map<OverlayType, Map<GrowthStageGenderContainer, ResourceLocation>> overlayTextures = new HashMap<OverlayType, Map<GrowthStageGenderContainer, ResourceLocation>>();
    private final Map<OverlayType, Map<SkeletonOverlayContainer, ResourceLocation>> skeletonOverlays = new HashMap<OverlayType, Map<SkeletonOverlayContainer, ResourceLocation>>();
    private final DinosaurMetadata metadata = this.buildMetadata();
    private boolean shouldRegister = true;
    private PoseHandler<?> poseHandler;

    protected abstract DinosaurMetadata buildMetadata();

    public static Matrix4d getParentRotationMatrix(TabulaModelContainer model, TabulaCubeContainer cube, boolean includeParents, boolean ignoreSelf, float rot) {
        ArrayList<TabulaCubeContainer> parentCubes = new ArrayList<TabulaCubeContainer>();
        do {
            if (ignoreSelf) {
                ignoreSelf = false;
                continue;
            }
            parentCubes.add(cube);
        } while (includeParents && cube.getParentIdentifier() != null && (cube = TabulaModelHelper.getCubeByIdentifier(cube.getParentIdentifier(), model)) != null);
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        Matrix4d transform = new Matrix4d();
        transform.rotY((double)(rot / 180.0f) * Math.PI);
        mat.mul(transform);
        for (int i = parentCubes.size() - 1; i >= 0; --i) {
            cube = (TabulaCubeContainer)parentCubes.get(i);
            transform.setIdentity();
            transform.setTranslation(new Vector3d(cube.getPosition()));
            mat.mul(transform);
            double rotX = cube.getRotation()[0];
            double rotY = cube.getRotation()[1];
            double rotZ = cube.getRotation()[2];
            transform.rotZ(rotZ / 180.0 * Math.PI);
            mat.mul(transform);
            transform.rotY(rotY / 180.0 * Math.PI);
            mat.mul(transform);
            transform.rotX(rotX / 180.0 * Math.PI);
            mat.mul(transform);
        }
        return mat;
    }

    private static double[][] getTransformation(Matrix4d matrix) {
        double cosRotationAngleZ;
        double sinRotationAngleZ;
        double cosRotationAngleX;
        double sinRotationAngleX;
        double sinRotationAngleY = -matrix.m20;
        double cosRotationAngleY = Math.sqrt(1.0 - sinRotationAngleY * sinRotationAngleY);
        if (Math.abs(cosRotationAngleY) > 1.0E-4) {
            sinRotationAngleX = matrix.m21 / cosRotationAngleY;
            cosRotationAngleX = matrix.m22 / cosRotationAngleY;
            sinRotationAngleZ = matrix.m10 / cosRotationAngleY;
            cosRotationAngleZ = matrix.m00 / cosRotationAngleY;
        } else {
            sinRotationAngleX = -matrix.m12;
            cosRotationAngleX = matrix.m11;
            sinRotationAngleZ = 0.0;
            cosRotationAngleZ = 1.0;
        }
        double rotationAngleX = Dinosaur.epsilon(Math.atan2(sinRotationAngleX, cosRotationAngleX)) / Math.PI * 180.0;
        double rotationAngleY = Dinosaur.epsilon(Math.atan2(sinRotationAngleY, cosRotationAngleY)) / Math.PI * 180.0;
        double rotationAngleZ = Dinosaur.epsilon(Math.atan2(sinRotationAngleZ, cosRotationAngleZ)) / Math.PI * 180.0;
        return new double[][]{{Dinosaur.epsilon(matrix.m03), Dinosaur.epsilon(matrix.m13), Dinosaur.epsilon(matrix.m23)}, {rotationAngleX, rotationAngleY, rotationAngleZ}};
    }

    private static double epsilon(double x) {
        return x < 0.0 ? (x > -1.0E-4 ? 0.0 : x) : (x < 1.0E-4 ? 0.0 : x);
    }

    public void init() {
        for (OverlayType overlayType : this.metadata.getOverlays()) {
            if (this.overlayTextures.get((Object)overlayType) == null) {
                this.overlayTextures.put(overlayType, new HashMap());
            }
            if (this.skeletonOverlays.get((Object)overlayType) != null) continue;
            this.skeletonOverlays.put(overlayType, new HashMap());
        }
        for (Enum enum_ : GrowthStage.VALUES) {
            if (this.doesSupportGrowthStage((GrowthStage)enum_)) {
                if (enum_ == GrowthStage.SKELETON) {
                    this.getSkeletonModels().entrySet().stream().forEach(entry -> this.skeletonModels.put((String)entry.getKey(), (TabulaModelContainer)entry.getValue()));
                    continue;
                }
                this.setModelContainer((GrowthStage)enum_, this.parseModel(((GrowthStage)enum_).getKey()));
                continue;
            }
            this.setModelContainer((GrowthStage)enum_, this.getModelContainer(GrowthStage.ADULT));
        }
        ResourceLocation identifier = this.getMetadata().getIdentifier();
        String domain = identifier.func_110624_b();
        String name = identifier.func_110623_a();
        String string = "textures/entities/" + name + "/";
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            for (GrowthStage growthStage : GrowthStage.values()) {
                String growthStageName = growthStage.getKey();
                if (!this.doesSupportGrowthStage(growthStage)) {
                    growthStageName = GrowthStage.ADULT.getKey();
                }
                this.maleTextures.put(growthStage, new ResourceLocation(domain, string + name + "_male_" + growthStageName + ".png"));
                this.femaleTextures.put(growthStage, new ResourceLocation(domain, string + name + "_female_" + growthStageName + ".png"));
                for (OverlayType type : this.metadata.getOverlays()) {
                    Map<Object, ResourceLocation> overlay;
                    if (growthStage != GrowthStage.SKELETON) {
                        overlay = this.overlayTextures.get((Object)type);
                        ResourceLocation female = new ResourceLocation(domain, string + name + "_female_" + growthStageName + "_" + type.toString() + ".png");
                        ResourceLocation male = new ResourceLocation(domain, string + name + "_male_" + growthStageName + "_" + type.toString() + ".png");
                        try {
                            ClientProxy.MC.func_110442_L().func_110536_a(female).func_110527_b();
                            ClientProxy.MC.func_110442_L().func_110536_a(male).func_110527_b();
                            overlay.put(new GrowthStageGenderContainer(growthStage, false), female);
                            overlay.put(new GrowthStageGenderContainer(growthStage, true), male);
                            this.overlayTextures.put(type, overlay);
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    overlay = this.skeletonOverlays.get((Object)type);
                    ResourceLocation fresh = new ResourceLocation(domain, string + name + "_fresh_skeleton_" + type.toString() + ".png");
                    ResourceLocation fossilized = new ResourceLocation(domain, string + name + "_fossilized_skeleton_" + type.toString() + ".png");
                    try {
                        ClientProxy.MC.func_110442_L().func_110536_a(fresh).func_110527_b();
                        ClientProxy.MC.func_110442_L().func_110536_a(fossilized).func_110527_b();
                        if (!type.isGenderSpecific()) {
                            overlay.put((GrowthStageGenderContainer)((Object)new SkeletonOverlayContainer(false, false)), fresh);
                            overlay.put(new SkeletonOverlayContainer(true, false), fossilized);
                            overlay.put(new SkeletonOverlayContainer(false, true), fresh);
                            overlay.put(new SkeletonOverlayContainer(true, true), fossilized);
                            this.skeletonOverlays.put(type, overlay);
                            continue;
                        }
                        if (type.getGenderSpec() == 1) {
                            overlay.put(new SkeletonOverlayContainer(false, true), fresh);
                            overlay.put(new SkeletonOverlayContainer(true, true), fossilized);
                        } else {
                            overlay.put(new SkeletonOverlayContainer(false, false), fresh);
                            overlay.put(new SkeletonOverlayContainer(true, false), fossilized);
                        }
                        this.skeletonOverlays.put(type, overlay);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        this.poseHandler = new PoseHandler(this);
    }

    @Nullable
    protected TabulaModelContainer parseModel(String growthStage) {
        ResourceLocation identifier = this.getIdentifier();
        String domain = identifier.func_110624_b();
        String path = identifier.func_110623_a();
        ResourceLocation location = new ResourceLocation(domain, "models/entities/" + path + "/" + growthStage + "/" + path + "_" + growthStage + "_idle");
        try {
            return TabulaModelHelper.loadTabulaModel(location);
        }
        catch (Exception e) {
            JurassiCraft.getLogger().fatal("Couldn't load model " + location, (Throwable)e);
            return null;
        }
    }

    @Nonnull
    protected HashMap<String, TabulaModelContainer> getSkeletonModels() {
        HashMap<String, TabulaModelContainer> models = new HashMap<String, TabulaModelContainer>();
        ResourceLocation identifier = this.getIdentifier();
        String domain = identifier.func_110624_b();
        String path = identifier.func_110623_a();
        ResourceLocation location = new ResourceLocation(domain, "models/entities/" + path + "/skeleton/" + path + "_skeleton_idle");
        try {
            models.put("idle", TabulaModelHelper.loadTabulaModel(location));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String type : this.getMetadata().skeletonPoses()) {
            ResourceLocation furtherLocation = new ResourceLocation(domain, "models/entities/" + path + "/skeleton/" + path + "_skeleton_" + type);
            try {
                models.put(type, TabulaModelHelper.loadTabulaModel(furtherLocation));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return models;
    }

    public ResourceLocation getMaleTexture(GrowthStage stage) {
        return this.maleTextures.get((Object)stage);
    }

    public ResourceLocation getFemaleTexture(GrowthStage stage) {
        return this.femaleTextures.get((Object)stage);
    }

    public void disableRegistry() {
        this.shouldRegister = false;
    }

    public boolean shouldRegister() {
        return this.shouldRegister;
    }

    public int hashCode() {
        return this.metadata.getIdentifier().hashCode();
    }

    protected int fromDays(int days) {
        return days * 24000 / 8;
    }

    @Override
    public int compareTo(Dinosaur dinosaur) {
        return this.getIdentifier().compareTo(dinosaur.getIdentifier());
    }

    public ResourceLocation getOverlayTextures(OverlayType type, DinosaurEntity entity) {
        boolean isMale = entity.isMale();
        if (entity.getGrowthStage() == GrowthStage.SKELETON) {
            return this.skeletonOverlays.get((Object)type).get(new SkeletonOverlayContainer(entity.getIsFossile(), isMale));
        }
        return this.overlayTextures.get((Object)type).get(new GrowthStageGenderContainer(entity.getGrowthStage(), isMale));
    }

    public boolean equals(Object object) {
        return object instanceof Dinosaur && ((Dinosaur)object).getIdentifier().equals((Object)this.getIdentifier());
    }

    public double[] getCubePosition(String cubeName, GrowthStage stage) {
        TabulaModelContainer model = this.getModelContainer(stage);
        TabulaCubeContainer cube = TabulaModelHelper.getCubeByName(cubeName, model);
        if (cube != null) {
            return cube.getPosition();
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    public double[] getParentedCubePosition(String cubeName, GrowthStage stage, float rot) {
        TabulaModelContainer model = this.getModelContainer(stage);
        TabulaCubeContainer cube = TabulaModelHelper.getCubeByName(cubeName, model);
        if (cube != null) {
            return Dinosaur.getTransformation(Dinosaur.getParentRotationMatrix(model, cube, true, false, rot))[0];
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    public double[] getHeadPosition(GrowthStage stage, float rot) {
        return this.getParentedCubePosition(this.metadata.getHeadCubeName(), stage, rot);
    }

    public TabulaModelContainer getModelContainer(GrowthStage stage) {
        TabulaModelContainer model = this.models.get((Object)stage);
        if (model == null) {
            return this.models.get((Object)GrowthStage.ADULT);
        }
        return model;
    }

    public Map<String, TabulaModelContainer> getSkeletonModel() {
        Map<String, TabulaModelContainer> model = this.skeletonModels;
        return model;
    }

    private void setModelContainer(GrowthStage stage, TabulaModelContainer model) {
        this.models.put(stage, model);
    }

    public PoseHandler<?> getPoseHandler() {
        return this.poseHandler;
    }

    public DinosaurEntity construct(World world) {
        return this.metadata.construct(world);
    }

    public void applyMeatEffect(EntityPlayer player, boolean cooked) {
    }

    public DinosaurMetadata getMetadata() {
        return this.metadata;
    }

    public boolean doesSupportGrowthStage(GrowthStage stage) {
        return stage == GrowthStage.ADULT || stage == GrowthStage.SKELETON;
    }

    public List<GrowthStage> getSupportedStages() {
        ArrayList<GrowthStage> supportedStages = new ArrayList<GrowthStage>(4);
        for (GrowthStage stage : GrowthStage.VALUES) {
            if (!this.doesSupportGrowthStage(stage)) continue;
            supportedStages.add(stage);
        }
        return supportedStages;
    }

    public ResourceLocation getIdentifier() {
        return this.getMetadata().getIdentifier();
    }

    public String getLocalizedName() {
        ResourceLocation identifier = this.metadata.getIdentifier();
        return I18n.func_74838_a((String)("entity." + identifier.func_110624_b() + "." + identifier.func_110623_a() + ".name"));
    }

    public static enum BirthType {
        LIVE_BIRTH,
        EGG_LAYING;

    }

    public static enum DinosaurType {
        AGGRESSIVE,
        NEUTRAL,
        PASSIVE,
        SCARED;

    }
}

