/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.conf;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.proxy.ServerProxy;
import org.jurassicraft.server.world.structure.StructureGenerationHandler;

@Config(modid="jurassicraft", category="")
@Mod.EventBusSubscriber(modid="jurassicraft")
public class JurassiCraftConfig {
    @Config.Name(value="entities")
    public static final Entities ENTITIES = new Entities();
    @Config.Name(value="mineral Generation")
    public static final MineralGeneration MINERAL_GENERATION = new MineralGeneration();
    @Config.Name(value="plant Generation")
    public static final PlantGeneration PLANT_GENERATION = new PlantGeneration();
    @Config.Name(value="structure Generation")
    public static final StructureGeneration STRUCTURE_GENERATION = new StructureGeneration();
    @Config.Name(value="items")
    public static final Items ITEMS = new Items();
    @Config.Name(value="vehicles")
    public static final Vehicles VEHICLES = new Vehicles();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("jurassicraft".equals(event.getModID())) {
            ConfigManager.sync((String)"jurassicraft", (Config.Type)Config.Type.INSTANCE);
            StructureGenerationHandler.reloadGenerators();
            EntityHandler.reinitSpawns();
            ServerProxy.reinitSpawns();
        }
    }

    public static class Vehicles {
        @Config.Name(value="Helicopter Explosion")
        public boolean helicopterExplosion;
        @Config.Name(value="Helicopter zoom-out")
        @Config.Comment(value={"Experimental: This is still incompatible with Optifine"})
        public boolean helicopterZoomout = false;
        @Config.Name(value="Enable Tour Rail Blocks")
        public boolean tourRailBlockEnabled = true;
        @Config.Name(value="Vehicles destroying blocks")
        public boolean destroyBlocks = true;
    }

    public static class Items {
        @Config.Name(value="Disable Growth Serum")
        public boolean disableGrowthSerum = false;
        @Config.Name(value="Loot Spawnrate (percentage)")
        @Config.Comment(value={"This represents the percentage of loot items in dungeons (restart required)"})
        public int lootSpawnrate = 100;
    }

    public static class StructureGeneration {
        @Config.Name(value="Visitor Center Generation")
        public boolean visitorcentergeneration = true;
        @Config.Name(value="Raptor Paddock Generation")
        public boolean raptorgeneration = true;
        @Config.Name(value="Raptor Paddock Rarity")
        @Config.Comment(value={"Tested between 1/50 and 1/infinite (The default rarity is 1/4000)"})
        public int paddockRarity = 4000;
    }

    public static class PlantGeneration {
        @Config.Name(value="Moss Generation")
        public boolean mossGeneration = true;
        @Config.Name(value="Peat Generation")
        public boolean peatGeneration = true;
        @Config.Name(value="Flower Generation")
        public boolean flowerGeneration = true;
        @Config.Name(value="Gracilaria Generation")
        public boolean gracilariaGeneration = true;
    }

    public static class MineralGeneration {
        @Config.Name(value="Fossil Generation")
        public boolean fossilGeneration = true;
        @Config.Name(value="Nest Fossil Generation")
        public boolean nestFossilGeneration = true;
        @Config.Name(value="Fossilized Trackway Generation")
        public boolean trackwayGeneration = true;
        @Config.Name(value="Plant Fossil Generation")
        public boolean plantFossilGeneration = true;
        @Config.Name(value="Amber Generation")
        public boolean amberGeneration = true;
        @Config.Name(value="Ice Shard Generation")
        public boolean iceShardGeneration = true;
        @Config.Name(value="Gypsum Generation")
        public boolean gypsumGeneration = true;
        @Config.Name(value="Petrified Tree Generation")
        public boolean petrifiedTreeGeneration = true;
    }

    public static class Entities {
        @Config.Name(value="Dinosaur Spawning")
        public boolean naturalSpawning_D = false;
        @Config.Name(value="Goat Spawning")
        public boolean naturalSpawning_G = false;
        @Config.Name(value="Only Hunt when Hungry")
        public boolean huntWhenHungry = false;
        @Config.Name(value="Allow Carcass Spawning")
        public boolean allowCarcass = true;
    }
}

