/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.EntityAnimation;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.entity.DinosaurEntity;

public class ForceAnimationCommand
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();

    public ForceAnimationCommand() {
        this.aliases.add("animate");
        this.aliases.add("anim");
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }

    public String func_71517_b() {
        return "animate";
    }

    public String func_71518_a(ICommandSender parSender) {
        return "animate <AnimID> [<entitySelector>] <variant>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (!world.field_72995_K) {
            JurassiCraft.getLogger().debug("Processing on Server side");
            if (args.length < 1) {
                throw new WrongUsageException("Missing the animation to set", new Object[0]);
            }
            String entitySelector = args.length < 2 ? "@e[c=1]" : args[1];
            List entities = EntitySelector.func_179656_b((ICommandSender)new ProxySender(server, sender), (String)entitySelector, EntityLivingBase.class);
            if (entities.size() == 0) {
                throw new EntityNotFoundException("No DinosaurEntity to animate");
            }
            for (EntityLivingBase entity : entities) {
                if (!(entity instanceof Animatable)) continue;
                Animatable animatable = (Animatable)entity;
                try {
                    if (args.length == 3) {
                        byte variant = (byte)Integer.parseInt(args[2]);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Animating entity " + entity.func_145782_y() + " with animation type " + args[0] + " and variant " + variant));
                        animatable.setAnimationWithVariant(EntityAnimation.valueOf(args[0].toUpperCase(Locale.ENGLISH)).get(), variant);
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Animating entity " + entity.func_145782_y() + " with animation type " + args[0]));
                        animatable.setAnimation(EntityAnimation.valueOf(args[0].toUpperCase(Locale.ENGLISH)).get());
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandException(args[0] + " is not a valid animation.", new Object[0]);
                }
                entity.func_184185_a(((DinosaurEntity)entity).getSoundForAnimation(EntityAnimation.valueOf(args[0].toUpperCase(Locale.ENGLISH)).get()), 1.0f, 1.0f);
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList animations = Lists.newArrayList();
            String current = args[0].toLowerCase(Locale.ENGLISH);
            for (EntityAnimation animation : EntityAnimation.values()) {
                if (!animation.name().toLowerCase(Locale.ENGLISH).startsWith(current)) continue;
                animations.add(animation.name());
            }
            return animations;
        }
        return null;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    private static class ProxySender
    implements ICommandSender {
        private final ICommandSender original;
        private MinecraftServer server;

        public ProxySender(MinecraftServer server, ICommandSender proxy) {
            this.original = Objects.requireNonNull(proxy);
            this.server = server;
        }

        public void func_145747_a(ITextComponent component) {
            this.original.func_145747_a(component);
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return commandName.equals("@") || this.original.func_70003_b(permLevel, commandName);
        }

        public Entity func_174793_f() {
            return this.original.func_174793_f();
        }

        public String func_70005_c_() {
            return this.original.func_70005_c_();
        }

        public ITextComponent func_145748_c_() {
            return this.original.func_145748_c_();
        }

        public World func_130014_f_() {
            return this.original.func_130014_f_();
        }

        public BlockPos func_180425_c() {
            return this.original.func_180425_c();
        }

        public Vec3d func_174791_d() {
            return this.original.func_174791_d();
        }

        public boolean func_174792_t_() {
            return this.original.func_174792_t_();
        }

        public void func_174794_a(CommandResultStats.Type type, int amount) {
            this.original.func_174794_a(type, amount);
        }

        public MinecraftServer func_184102_h() {
            return this.server;
        }
    }
}

