/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.SubBlocksBlock;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.tree.AncientLogBlock;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.item.block.AncientItemLeaves;
import org.jurassicraft.server.tab.TabHandler;

public class AncientLeavesBlock
extends BlockLeaves
implements SubBlocksBlock {
    private TreeType treeType;
    protected int[] field_150128_a;

    public AncientLeavesBlock(TreeType type) {
        this.treeType = type;
        this.func_149663_c(type.name().toLowerCase(Locale.ENGLISH) + "_leaves");
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        this.func_149647_a(TabHandler.PLANTS);
    }

    public TreeType getTreeType() {
        return this.treeType;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            int maxBlocks = 7;
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            int cubeLength = 32;
            int cubeLengthSq = cubeLength * cubeLength;
            int halfCubeLength = cubeLength / 2;
            if (this.field_150128_a == null) {
                this.field_150128_a = new int[cubeLength * cubeLength * cubeLength];
            }
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175697_a(pos, maxBlocks + 2)) {
                BlockPos.MutableBlockPos tempBlockPos = new BlockPos.MutableBlockPos();
                for (int offsetX = -maxBlocks; offsetX <= maxBlocks; ++offsetX) {
                    for (int offsetY = -maxBlocks; offsetY <= maxBlocks; ++offsetY) {
                        for (int offsetZ = -maxBlocks; offsetZ <= maxBlocks; ++offsetZ) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)tempBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ));
                            Block block = iblockstate.func_177230_c();
                            int index = (offsetX + halfCubeLength) * cubeLengthSq + (offsetY + halfCubeLength) * cubeLength + offsetZ + halfCubeLength;
                            this.field_150128_a[index] = BlockHandler.ANCIENT_LOGS.values().contains(block) && ((AncientLogBlock)block).getType() == this.getTreeType() ? 0 : (this == block ? -2 : -1);
                        }
                    }
                }
                for (int i3 = 1; i3 <= maxBlocks; ++i3) {
                    for (int offsetX = -maxBlocks; offsetX <= maxBlocks; ++offsetX) {
                        for (int offsetY = -maxBlocks; offsetY <= maxBlocks; ++offsetY) {
                            for (int offsetZ = -maxBlocks; offsetZ <= maxBlocks; ++offsetZ) {
                                if (this.field_150128_a[(offsetX + halfCubeLength) * cubeLengthSq + (offsetY + halfCubeLength) * cubeLength + offsetZ + halfCubeLength] != i3 - 1) continue;
                                for (int dirX = -1; dirX <= 1; ++dirX) {
                                    for (int dirY = -1; dirY <= 1; ++dirY) {
                                        for (int dirZ = -1; dirZ <= 1; ++dirZ) {
                                            int index;
                                            if (dirX == 0 && dirY == 0 && dirZ == 0 || this.field_150128_a[index = (offsetX + halfCubeLength + dirX) * cubeLengthSq + (offsetY + halfCubeLength + dirY) * cubeLength + offsetZ + dirZ + halfCubeLength] != -2) continue;
                                            this.field_150128_a[index] = i3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.field_150128_a[halfCubeLength * cubeLengthSq + halfCubeLength * cubeLength + halfCubeLength] >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.treeType.getDropChance();
        if (fortune > 0 && (chance -= 2 << fortune) < 2) {
            chance = 2;
        }
        if (rand.nextInt(chance) == 0) {
            ItemStack drop = this.treeType.getDrop();
            drops.add(new ItemStack(drop.func_77973_b(), drop.func_190916_E()));
        }
        this.captureDrops(true);
        drops.addAll((Collection<ItemStack>)this.captureDrops(false));
        return drops;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.treeType.getDrop().func_77973_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(meta == 0 || meta == 1)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(meta == 0 || meta == 4));
    }

    public int func_176201_c(IBlockState state) {
        boolean decayable = (Boolean)state.func_177229_b((IProperty)field_176237_a);
        boolean checkDecay = (Boolean)state.func_177229_b((IProperty)field_176236_b);
        if (decayable && checkDecay) {
            return 0;
        }
        if (decayable) {
            return 1;
        }
        if (checkDecay) {
            return 4;
        }
        return 8;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1, 0)});
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.BIRCH;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new AncientItemLeaves(this);
    }
}

