/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.plant;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.util.GameRuleHandler;

public class GracilariaBlock
extends BlockBush {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);
    private static final int DENSITY_PER_AREA = 5;
    private static final int GOOD_LIGHT_SPREAD_CHANCE = 10;
    private static final int BAD_LIGHT_SPREAD_CHANCE = 1;
    private static final int SPREAD_RADIUS = 4;
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.8f, (double)0.4f, (double)0.8f);

    public GracilariaBlock() {
        super(Material.field_151586_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(null);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemHandler.GRACILARIA;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)ItemHandler.GRACILARIA);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    private boolean canPlaceBlockOn(Block ground) {
        return ground == Blocks.field_150354_m || ground == Blocks.field_150435_aG || ground == Blocks.field_150351_n || ground == Blocks.field_150346_d;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block down = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block here = worldIn.func_180495_p(pos).func_177230_c();
        Block up = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.canPlaceBlockOn(down) && here == Blocks.field_150355_j && up == Blocks.field_150355_j;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        Block down = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block up = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.canPlaceBlockOn(down) && up == Blocks.field_150355_j;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (GameRuleHandler.PLANT_SPREADING.getBoolean(world)) {
            int spreadChance = 1;
            int light = world.func_175699_k(pos);
            if (light >= 5 && light <= 11) {
                spreadChance = 10;
            }
            if (rand.nextInt(100) <= spreadChance) {
                int i = 5;
                for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -3, -4), (BlockPos)pos.func_177982_a(4, 3, 4))) {
                    if (world.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                    return;
                }
                BlockPos nextPos = null;
                for (int placementAttempts = 3; nextPos == null && placementAttempts > 0; --placementAttempts) {
                    int doubleRadius = 8;
                    BlockPos tmp = pos.func_177982_a(rand.nextInt(doubleRadius) - 4, -4, rand.nextInt(doubleRadius) - 4);
                    nextPos = this.findGround(world, tmp);
                }
                if (nextPos != null) {
                    world.func_175656_a(nextPos, this.func_176223_P());
                }
            }
        }
    }

    private BlockPos findGround(World world, BlockPos start) {
        BlockPos pos = start;
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block here = world.func_180495_p(pos).func_177230_c();
        Block up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        for (int i = 0; i < 8; ++i) {
            if (this.canPlaceBlockOn(down) && here == Blocks.field_150355_j && up == Blocks.field_150355_j) {
                return pos;
            }
            down = here;
            here = up;
            pos = pos.func_177984_a();
            up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        }
        return null;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        BlockPos beside = pos.func_177972_a(face);
        Block blockBeside = world.func_180495_p(beside).func_177230_c();
        return blockBeside instanceof BlockGlass;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        BlockPos beside = pos.func_177972_a(side);
        IBlockState state = blockAccess.func_180495_p(beside);
        Block blockBeside = state.func_177230_c();
        return blockBeside instanceof BlockGlass;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }
}

