/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.plant;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.plant.AncientPlantBlock;
import org.jurassicraft.server.util.GameRuleHandler;

public class AncientCoralBlock
extends AncientPlantBlock {
    private static final int DENSITY_PER_AREA = 5;
    private static final int SPREAD_RADIUS = 6;
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);

    public AncientCoralBlock() {
        super(Material.field_151586_h);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(null);
    }

    private boolean canPlaceBlockOn(Block ground) {
        return ground == Blocks.field_150354_m || ground == Blocks.field_150435_aG || ground == Blocks.field_150351_n || ground == Blocks.field_150346_d;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block down = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block here = worldIn.func_180495_p(pos).func_177230_c();
        Block up = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.canPlaceBlockOn(down) && here == Blocks.field_150355_j && up == Blocks.field_150355_j;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        Block down = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block up = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.canPlaceBlockOn(down) && up == Blocks.field_150355_j;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int light;
        if (GameRuleHandler.PLANT_SPREADING.getBoolean(world) && (light = world.func_175699_k(pos)) >= 5 && rand.nextInt((15 - light) / 2 + 10) == 0) {
            int i = 5;
            BlockPos nextPos = null;
            for (int placementAttempts = 3; nextPos == null && placementAttempts > 0; --placementAttempts) {
                int doubleRadius = 12;
                BlockPos tmp = pos.func_177982_a(rand.nextInt(doubleRadius) - 6, -6, rand.nextInt(doubleRadius) - 6);
                nextPos = this.findGround(world, tmp);
            }
            if (nextPos != null) {
                for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-6, -3, -6), (BlockPos)pos.func_177982_a(6, 3, 6))) {
                    if (!(world.func_180495_p(blockpos).func_177230_c() instanceof AncientCoralBlock) || --i > 0) continue;
                    return;
                }
            }
            if (nextPos != null) {
                world.func_175656_a(nextPos, this.func_176223_P());
            }
        }
    }

    @Override
    protected BlockPos findGround(World world, BlockPos start) {
        BlockPos pos = start;
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block here = world.func_180495_p(pos).func_177230_c();
        Block up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        for (int i = 0; i < 8; ++i) {
            if (this.canPlaceBlockOn(down) && here == Blocks.field_150355_j && up == Blocks.field_150355_j) {
                return pos;
            }
            down = here;
            here = up;
            pos = pos.func_177984_a();
            up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        }
        return null;
    }

    @Override
    protected boolean isNearWater(World world, BlockPos nextPos) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        BlockPos beside = pos.func_177972_a(face);
        Block blockBeside = world.func_180495_p(beside).func_177230_c();
        return blockBeside instanceof BlockGlass;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        BlockPos beside = pos.func_177972_a(side);
        IBlockState state = blockAccess.func_180495_p(beside);
        Block blockBeside = state.func_177230_c();
        return blockBeside instanceof BlockGlass;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @Override
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }
}

