/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jurassicraft.server.block.entity.ISyncable;

public abstract class MachineBaseBlockEntity
extends TileEntityLockable
implements ISyncable,
ITickable,
ISidedInventory {
    protected String customName;
    protected int[] processTime = new int[this.getProcessCount()];
    protected int[] totalProcessTime = new int[this.getProcessCount()];
    IItemHandler handler = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory, int index) {
        return inventory.func_174887_a_(index) > 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        NonNullList slots = NonNullList.func_191196_a();
        for (i = 0; i < this.func_70302_i_(); ++i) {
            slots.add((Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            slots.set((int)slot, (Object)new ItemStack(item));
        }
        for (i = 0; i < this.getProcessCount(); ++i) {
            this.processTime[i] = compound.func_74765_d("ProcessTime" + i);
            this.totalProcessTime[i] = compound.func_74765_d("ProcessTimeTotal" + i);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.setSlots((NonNullList<ItemStack>)slots);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.func_74777_a("ProcessTime" + i, (short)this.processTime[i]);
            compound.func_74777_a("ProcessTimeTotal" + i, (short)this.totalProcessTime[i]);
        }
        NonNullList<ItemStack> slots = this.getSlots();
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (((ItemStack)slots.get(slot)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            ((ItemStack)slots.get(slot)).func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.getSlots().get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        NonNullList<ItemStack> slots = this.getSlots();
        return ItemStackHelper.func_188382_a(slots, (int)index, (int)count);
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        return fields;
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        NonNullList<ItemStack> slots = this.getSlots();
        boolean stacksEqual = !stack.func_190926_b() && stack.func_77969_a((ItemStack)slots.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)slots.get(index)));
        slots.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!stacksEqual) {
            int process = this.getProcess(index);
            if (process >= 0 && process < this.getProcessCount()) {
                this.totalProcessTime[process] = this.getStackProcessTime(stack);
                if (!this.canProcess(process)) {
                    this.processTime[process] = 0;
                }
                this.func_70296_d();
            }
            this.onSlotUpdate();
        }
    }

    private boolean isInput(int slot) {
        int[] inputs;
        for (int input : inputs = this.getInputs()) {
            if (input != slot) continue;
            return true;
        }
        return false;
    }

    private boolean isOutput(int slot) {
        int[] outputs;
        for (int output : outputs = this.getOutputs()) {
            if (output != slot) continue;
            return true;
        }
        return false;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public int func_70302_i_() {
        return this.getSlots().size();
    }

    public boolean isProcessing(int index) {
        return this.processTime[index] > 0;
    }

    public void func_73660_a() {
        NonNullList<ItemStack> slots = this.getSlots();
        if (!this.field_145850_b.field_72995_K) {
            for (int process = 0; process < this.getProcessCount(); ++process) {
                boolean flag = this.isProcessing(process);
                boolean dirty = false;
                boolean hasInput = false;
                for (int input : this.getInputs(process)) {
                    if (((ItemStack)slots.get(input)).func_190926_b()) continue;
                    hasInput = true;
                    break;
                }
                if (hasInput && this.canProcess(process)) {
                    int n = process;
                    this.processTime[n] = this.processTime[n] + 1;
                    if (this.processTime[process] >= this.totalProcessTime[process]) {
                        this.processTime[process] = 0;
                        int total = 0;
                        for (int input : this.getInputs()) {
                            ItemStack stack = (ItemStack)slots.get(input);
                            if (stack.func_190926_b()) continue;
                            total = this.getStackProcessTime(stack);
                            break;
                        }
                        this.totalProcessTime[process] = total;
                        if (!this.field_145850_b.field_72995_K) {
                            this.processItem(process);
                            this.onSlotUpdate();
                        }
                    }
                    dirty = true;
                } else if (this.isProcessing(process)) {
                    if (this.shouldResetProgress()) {
                        this.processTime[process] = 0;
                    } else if (this.processTime[process] > 0) {
                        int n = process;
                        this.processTime[n] = this.processTime[n] - 1;
                    }
                    dirty = true;
                }
                if (flag != this.isProcessing(process)) {
                    dirty = true;
                }
                if (!dirty || this.field_145850_b.field_72995_K) continue;
                this.func_70296_d();
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !this.isOutput(index);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.getOutputs() : this.getInputs();
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    protected int getProcess(int slot) {
        return slot;
    }

    protected boolean canProcess(int process) {
        return true;
    }

    protected void processItem(int process) {
    }

    protected int getMainOutput(int process) {
        return 0;
    }

    protected int getStackProcessTime(ItemStack stack) {
        return 0;
    }

    protected int getProcessCount() {
        return 0;
    }

    protected abstract int[] getInputs();

    protected abstract int[] getInputs(int var1);

    protected abstract int[] getOutputs();

    protected abstract NonNullList<ItemStack> getSlots();

    public boolean hasOutputSlot(ItemStack output) {
        return this.getOutputSlot(output) != -1;
    }

    public int getOutputSlot(ItemStack output) {
        int[] outputs;
        NonNullList<ItemStack> slots = this.getSlots();
        for (int slot : outputs = this.getOutputs()) {
            ItemStack stack = (ItemStack)slots.get(slot);
            if (!stack.func_190926_b() && (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)output) || stack.func_190916_E() + output.func_190916_E() > stack.func_77976_d() || stack.func_77973_b() != output.func_77973_b() || stack.func_77952_i() != output.func_77952_i())) continue;
            return slot;
        }
        return -1;
    }

    public int func_174887_a_(int id) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            return this.processTime[id];
        }
        if (id < processCount * 2) {
            return this.totalProcessTime[id - processCount];
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            this.processTime[id] = value;
        } else if (id < processCount * 2) {
            this.totalProcessTime[id - processCount] = value;
        }
    }

    public int func_174890_g() {
        return this.getProcessCount() * 2;
    }

    public void func_174888_l() {
        NonNullList<ItemStack> slots = this.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            slots.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    protected void mergeStack(int slot, ItemStack stack) {
        NonNullList<ItemStack> slots = this.getSlots();
        ItemStack previous = (ItemStack)slots.get(slot);
        if (previous.func_190926_b()) {
            slots.set(slot, (Object)stack);
        } else if (ItemStack.func_179545_c((ItemStack)previous, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)previous, (ItemStack)stack)) {
            previous.func_190920_e(previous.func_190916_E() + stack.func_190916_E());
        }
    }

    protected void decreaseStackSize(int slot) {
        NonNullList<ItemStack> slots = this.getSlots();
        ((ItemStack)slots.get(slot)).func_190918_g(1);
        if (((ItemStack)slots.get(slot)).func_190916_E() <= 0) {
            slots.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    protected boolean shouldResetProgress() {
        return true;
    }

    protected void setSlots(NonNullList<ItemStack> slots) {
    }

    protected void onSlotUpdate() {
    }

    public boolean func_191420_l() {
        return false;
    }

    public String func_70005_c_() {
        return "jurassicraft:machine_base_block";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return null;
    }

    public String func_174875_k() {
        return null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void packetDataHandler(ByteBuf dataStream) {
    }
}

