/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.api.IncubatorEnvironmentItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.block.entity.TemperatureControl;
import org.jurassicraft.server.container.IncubatorContainer;
import org.jurassicraft.server.item.DinosaurEggItem;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.message.TileEntityFieldsMessage;
import org.jurassicraft.server.plugin.waila.IWailaProvider;

public class IncubatorBlockEntity
extends MachineBaseBlockEntity
implements TemperatureControl,
IWailaProvider {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4};
    private static final int[] ENVIRONMENT = new int[]{5};
    private int[] temperature = new int[5];
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    IItemHandler handlerPull = new IncubatorWrapper(this, this, null){

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stackInSlot;
            if (Ints.asList((int[])INPUTS).contains(slot) && (stackInSlot = this.inv.func_70301_a(slot)) != null && stackInSlot.func_77973_b() == ItemHandler.HATCHED_EGG) {
                ItemStack extract = super.extractItem(slot, amount, simulate);
                BlockPos pos = this.getTile().func_174877_v();
                JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getTile().getSyncFields(NonNullList.func_191196_a()), (TileEntity)this.getTile()), new NetworkRegistry.TargetPoint(((IncubatorBlockEntity)this.getTile()).field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0));
                return extract;
            }
            return ItemStack.field_190927_a;
        }
    };

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            this.temperature[i] = compound.func_74765_d("Temperature" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.func_74777_a("Temperature" + i, (short)this.temperature[i]);
        }
        return compound;
    }

    @Override
    protected int getProcess(int slot) {
        if (slot == 5) {
            return -1;
        }
        return slot;
    }

    @Override
    protected boolean canProcess(int process) {
        Item item;
        ItemStack environment = (ItemStack)this.slots.get(5);
        boolean hasEnvironment = false;
        if (!environment.func_190926_b() && ((item = environment.func_77973_b()) instanceof IncubatorEnvironmentItem || Block.func_149634_a((Item)item) instanceof IncubatorEnvironmentItem)) {
            hasEnvironment = true;
        }
        return hasEnvironment && !((ItemStack)this.slots.get(process)).func_190926_b() && ((ItemStack)this.slots.get(process)).func_190916_E() > 0 && ((ItemStack)this.slots.get(process)).func_77973_b() instanceof DinosaurEggItem;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process) && !this.field_145850_b.field_72995_K) {
            ItemStack egg = (ItemStack)this.slots.get(process);
            ItemStack incubatedEgg = new ItemStack((Item)ItemHandler.HATCHED_EGG, 1, egg.func_77952_i());
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("Gender", this.temperature[process] > 50);
            if (egg.func_77978_p() != null) {
                compound.func_74778_a("Genetics", egg.func_77978_p().func_74779_i("Genetics"));
                compound.func_74768_a("DNAQuality", egg.func_77978_p().func_74762_e("DNAQuality"));
            }
            incubatedEgg.func_77982_d(compound);
            this.decreaseStackSize(5);
            this.func_70299_a(process, incubatedEgg);
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 0;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 8000;
    }

    @Override
    protected int getProcessCount() {
        return 5;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return new int[]{process};
    }

    @Override
    protected int[] getOutputs() {
        return ENVIRONMENT;
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slots) {
        this.slots = slots;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new IncubatorContainer(playerInventory, (TileEntity)this);
    }

    @Override
    public String func_174875_k() {
        return "jurassicraft:incubator";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.incubator";
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < 5) {
            return this.processTime[id];
        }
        if (id < 10) {
            return this.totalProcessTime[id - 5];
        }
        if (id < 15) {
            return this.temperature[id - 10];
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < 5) {
            this.processTime[id] = value;
        } else if (id < 10) {
            this.totalProcessTime[id - 5] = value;
        } else if (id < 15) {
            this.temperature[id - 10] = value;
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return ArrayUtils.addAll((int[])INPUTS, (int[])ENVIRONMENT);
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return Ints.asList((int[])INPUTS).contains(slotID) ? itemstack != null && itemstack.func_77973_b() == ItemHandler.EGG : Ints.asList((int[])ENVIRONMENT).contains(slotID) && (itemstack != null && itemstack.func_77973_b() instanceof IncubatorEnvironmentItem || Block.func_149634_a((Item)itemstack.func_77973_b()) instanceof IncubatorEnvironmentItem);
    }

    @Override
    public void func_73660_a() {
        boolean send = false;
        if (!this.field_145850_b.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % 100 == 0) {
            for (int i = 0; i < 5; ++i) {
                if (!this.isProcessing(i)) continue;
                send = true;
                break;
            }
        }
        super.func_73660_a();
        if (send && !this.field_145850_b.field_72995_K) {
            BlockPos pos = this.func_174877_v();
            JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0));
        }
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerPull;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected boolean shouldResetProgress() {
        return false;
    }

    @Override
    public void setTemperature(int index, int value) {
        this.temperature[index] = value;
    }

    @Override
    public int getTemperature(int index) {
        return this.temperature[index];
    }

    @Override
    public int getTemperatureCount() {
        return this.temperature.length;
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            for (int slot = 0; slot < 5; ++slot) {
                this.func_70299_a(slot, ByteBufUtils.readItemStack((ByteBuf)fields));
            }
            for (int field = 0; field < 10; ++field) {
                this.func_174885_b(field, fields.readInt());
            }
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean send = false;
        if (!this.field_145850_b.field_72995_K && index >= 0 && index <= 4 && ((ItemStack)this.slots.get(index)).func_77973_b() != stack.func_77973_b()) {
            send = true;
        }
        super.func_70299_a(index, stack);
        if (send) {
            BlockPos pos = this.func_174877_v();
            JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0));
        }
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        for (int slot = 0; slot < 5; ++slot) {
            fields.add(this.slots.get(slot));
        }
        for (int field = 0; field < 10; ++field) {
            fields.add((Object)this.func_174887_a_(field));
        }
        return fields;
    }

    @Override
    public List<String> getWailaData(List<String> list) {
        ArrayList<String> content = new ArrayList<String>();
        for (int input = 0; input < INPUTS.length; ++input) {
            ItemStack stack = this.func_70301_a(input);
            if (stack == null || stack.func_190926_b()) continue;
            content.add(input + ";" + stack.func_77973_b().getRegistryName().toString() + ";" + stack.func_77960_j() + ";" + this.getProgress(input) + ";" + (this.temperature[input] > 50) + ";" + (stack.func_77942_o() ? stack.func_77978_p().toString() : "{}"));
        }
        if (content.size() > 0) {
            list.add(SpecialChars.getRenderString((String)"jurassicraft.incubator", (String[])content.toArray(new String[0])));
        }
        return list;
    }

    private int getProgress(int slot) {
        int j = this.func_174887_a_(slot);
        int k = this.func_174887_a_(slot + 5);
        return k != 0 && j != 0 ? j * 14 / k : 0;
    }

    private class IncubatorWrapper
    extends SidedInvWrapper {
        private final IncubatorBlockEntity tile;

        public IncubatorWrapper(IncubatorBlockEntity tile, ISidedInventory inv, EnumFacing side) {
            super(inv, side);
            this.tile = tile;
        }

        public IncubatorBlockEntity getTile() {
            return this.tile;
        }
    }
}

