/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import org.jurassicraft.server.block.fence.ElectricFencePoleBlock;

public class ElectricFenceWireBlockEntity
extends TileEntity
implements ITickable {
    private Set<BlockPos> poweringPoles = new HashSet<BlockPos>();
    private byte ticks;

    public void func_73660_a() {
        this.ticks = (byte)(this.ticks + 1);
        if (this.ticks >= 20) {
            this.removeInvalidPoles();
            this.ticks = 0;
        }
    }

    private void removeInvalidPoles() {
        List<BlockPos> invalid = this.getInvalidPoles();
        for (BlockPos remove : invalid) {
            this.power(remove, false);
        }
    }

    private List<BlockPos> getInvalidPoles() {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>(this.poweringPoles.size());
        for (BlockPos pole : this.poweringPoles) {
            IBlockState state = this.field_145850_b.func_180495_p(pole);
            boolean isInvalid = true;
            if (state.func_177230_c() instanceof ElectricFencePoleBlock && this.field_145850_b.func_175640_z(pole.func_177977_b())) {
                isInvalid = false;
            }
            if (!isInvalid) continue;
            invalid.add(pole);
        }
        return invalid;
    }

    public void checkDisconnect() {
        this.removeInvalidPoles();
        for (BlockPos pole : this.poweringPoles) {
            IBlockState state = this.field_145850_b.func_180495_p(pole);
            Block block = state.func_177230_c();
            if (!(block instanceof ElectricFencePoleBlock)) continue;
            ((ElectricFencePoleBlock)block).updateConnectedWires(this.field_145850_b, pole);
        }
    }

    public void power(BlockPos pole, boolean powered) {
        if (powered) {
            if (!this.poweringPoles.contains(pole)) {
                this.poweringPoles.add(pole);
            }
        } else {
            this.poweringPoles.remove(pole);
        }
    }

    public boolean isPowered() {
        return this.poweringPoles.size() > 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagList poweringList = new NBTTagList();
        for (BlockPos pole : this.poweringPoles) {
            poweringList.func_74742_a((NBTBase)new NBTTagLong(pole.func_177986_g()));
        }
        compound.func_74782_a("Powering", (NBTBase)poweringList);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.poweringPoles.clear();
        NBTTagList poweringList = compound.func_150295_c("Powering", 4);
        for (int i = 0; i < poweringList.func_74745_c(); ++i) {
            this.poweringPoles.add(BlockPos.func_177969_a((long)((NBTTagLong)poweringList.func_179238_g(i)).func_150291_c()));
        }
    }
}

