/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.api.SequencableItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.DNASequencerContainer;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.message.TileEntityFieldsMessage;

public class DNASequencerBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] INPUTS_PROCESS_1 = new int[]{0, 1};
    private static final int[] INPUTS_PROCESS_2 = new int[]{2, 3};
    private static final int[] INPUTS_PROCESS_3 = new int[]{4, 5};
    private static final int[] OUTPUTS = new int[]{6, 7, 8};
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

    @Override
    protected int getProcess(int slot) {
        return Math.min(5, (int)Math.floor(slot / 2));
    }

    @Override
    protected boolean canProcess(int process) {
        int tissue = process * 2;
        ItemStack input = (ItemStack)this.slots.get(tissue);
        ItemStack storage = (ItemStack)this.slots.get(tissue + 1);
        SequencableItem sequencableItem = SequencableItem.getSequencableItem(input);
        return sequencableItem != null && sequencableItem.isSequencable(input) && !storage.func_190926_b() && storage.func_77973_b() == ItemHandler.STORAGE_DISC && ((ItemStack)this.slots.get(process + 6)).func_190926_b();
    }

    @Override
    protected void processItem(int process) {
        Random rand = new Random();
        int tissue = process * 2;
        ItemStack sequencableStack = (ItemStack)this.slots.get(tissue);
        this.mergeStack(process + 6, SequencableItem.getSequencableItem(sequencableStack).getSequenceOutput(sequencableStack, rand));
        this.decreaseStackSize(tissue);
        this.decreaseStackSize(tissue + 1);
        BlockPos pos = this.field_174879_c;
        JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0));
    }

    @Override
    protected int getMainOutput(int process) {
        return process * 2 + 1;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 3;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        if (process == 0) {
            return INPUTS_PROCESS_1;
        }
        if (process == 1) {
            return INPUTS_PROCESS_2;
        }
        return INPUTS_PROCESS_3;
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return Ints.asList((int[])OUTPUTS).contains(slotID);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return Ints.asList((int[])INPUTS).contains(slotID) && (slotID % 2 == 0 ? itemstack != null && SequencableItem.getSequencableItem(itemstack) != null && this.func_70301_a(slotID).func_190916_E() == 0 && SequencableItem.getSequencableItem(itemstack).isSequencable(itemstack) : itemstack != null && itemstack.func_77973_b() == ItemHandler.STORAGE_DISC && (itemstack.func_77978_p() == null || !itemstack.func_77978_p().func_74764_b("DNAQuality")) && this.func_70301_a(slotID).func_190916_E() == 0);
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slots) {
        this.slots = slots;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new DNASequencerContainer(playerInventory, (TileEntity)this);
    }

    @Override
    public String func_174875_k() {
        return "jurassicraft:dna_sequencer";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.dna_sequencer";
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            for (int slot : this.func_180463_a(EnumFacing.UP)) {
                if (slot % 2 != 0) continue;
                this.func_70299_a(slot, ByteBufUtils.readItemStack((ByteBuf)fields));
            }
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean send = false;
        if (!this.field_145850_b.field_72995_K && index % 2 == 0 && ((ItemStack)this.slots.get(index)).func_77973_b() != stack.func_77973_b()) {
            send = true;
        }
        super.func_70299_a(index, stack);
        if (send) {
            JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0));
        }
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        for (int slot : this.func_180463_a(EnumFacing.UP)) {
            if (slot % 2 != 0) continue;
            fields.add(this.slots.get(slot));
        }
        return fields;
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }
}

