/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jurassicraft.server.api.Hybrid;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.DNACombinatorHybridizerContainer;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.genetics.DinoDNA;
import org.jurassicraft.server.genetics.PlantDNA;
import org.jurassicraft.server.item.ItemHandler;

public class DNACombinatorHybridizerBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] HYBRIDIZER_INPUTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMBINATOR_INPUTS = new int[]{8, 9};
    private static final int[] HYBRIDIZER_OUTPUTS = new int[]{10};
    private static final int[] COMBINATOR_OUTPUTS = new int[]{11};
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);
    private boolean hybridizerMode;

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    private Dinosaur getHybrid() {
        return this.getHybrid((ItemStack)this.slots.get(0), (ItemStack)this.slots.get(1), (ItemStack)this.slots.get(2), (ItemStack)this.slots.get(3), (ItemStack)this.slots.get(4), (ItemStack)this.slots.get(5), (ItemStack)this.slots.get(6), (ItemStack)this.slots.get(7));
    }

    private Dinosaur getHybrid(ItemStack ... discs) {
        Dinosaur hybrid = null;
        Dinosaur[] dinosaurs = new Dinosaur[discs.length];
        for (int i = 0; i < dinosaurs.length; ++i) {
            dinosaurs[i] = this.getDino(discs[i]);
        }
        for (Dinosaur dino : EntityHandler.getRegisteredDinosaurs()) {
            if (!(dino instanceof Hybrid)) continue;
            Hybrid dinoHybrid = (Hybrid)((Object)dino);
            int count = 0;
            boolean extra = false;
            ArrayList<Class> usedGenes = new ArrayList<Class>();
            for (Dinosaur discDinosaur : dinosaurs) {
                Class match = null;
                for (Class clazz : dinoHybrid.getDinosaurs()) {
                    if (!clazz.isInstance(discDinosaur) || usedGenes.contains(clazz)) continue;
                    match = clazz;
                }
                if (match != null && match.isInstance(discDinosaur)) {
                    usedGenes.add(match);
                    ++count;
                    continue;
                }
                if (discDinosaur == null) continue;
                extra = true;
            }
            if (extra || count != dinoHybrid.getDinosaurs().length) continue;
            hybrid = dino;
            break;
        }
        return hybrid;
    }

    private Dinosaur getDino(ItemStack disc) {
        if (!disc.func_190926_b() && disc.func_77942_o()) {
            DinoDNA data = DinoDNA.readFromNBT(disc.func_77978_p());
            return data.getDNAQuality() == 100 ? data.getDinosaur() : null;
        }
        return null;
    }

    @Override
    protected boolean canProcess(int process) {
        if (this.hybridizerMode) {
            return ((ItemStack)this.slots.get(10)).func_190926_b() && this.getHybrid() != null;
        }
        ItemStack left = (ItemStack)this.slots.get(8);
        ItemStack right = (ItemStack)this.slots.get(9);
        if (!left.func_190926_b() && left.func_77973_b() == ItemHandler.STORAGE_DISC && !right.func_190926_b() && right.func_77973_b() == ItemHandler.STORAGE_DISC) {
            String leftID = left.func_77978_p().func_74779_i("StorageId");
            String rightID = right.func_77978_p().func_74779_i("StorageId");
            if (left.func_77978_p() != null && right.func_77978_p() != null && ((ItemStack)this.slots.get(11)).func_190926_b() && left.func_77952_i() == right.func_77952_i() && leftID.equals(rightID)) {
                if (leftID.equals("DinoDNA")) {
                    DinoDNA dna1 = DinoDNA.readFromNBT(left.func_77978_p());
                    DinoDNA dna2 = DinoDNA.readFromNBT(right.func_77978_p());
                    if (dna1.getDinosaur() == dna2.getDinosaur()) {
                        return true;
                    }
                } else if (leftID.equals("PlantDNA")) {
                    PlantDNA dna1 = PlantDNA.readFromNBT(left.func_77978_p());
                    PlantDNA dna2 = PlantDNA.readFromNBT(right.func_77978_p());
                    if (dna1.getPlant() == dna2.getPlant()) {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            if (this.hybridizerMode) {
                Dinosaur hybrid = this.getHybrid();
                NBTTagCompound nbt = new NBTTagCompound();
                DinoDNA dna = new DinoDNA(hybrid, 100, ((ItemStack)this.slots.get(0)).func_77978_p().func_74779_i("Genetics"));
                dna.writeToNBT(nbt);
                ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                output.func_77964_b(EntityHandler.getDinosaurId(dna.getDinosaur()));
                output.func_77982_d(nbt);
                this.mergeStack(this.getOutputSlot(output), output);
                for (int i = 0; i < 8; ++i) {
                    this.decreaseStackSize(i);
                }
            } else {
                ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                String storageId = ((ItemStack)this.slots.get(8)).func_77978_p().func_74779_i("StorageId");
                if (storageId.equals("DinoDNA")) {
                    DinoDNA dna1 = DinoDNA.readFromNBT(((ItemStack)this.slots.get(8)).func_77978_p());
                    DinoDNA dna2 = DinoDNA.readFromNBT(((ItemStack)this.slots.get(9)).func_77978_p());
                    int newQuality = dna1.getDNAQuality() + dna2.getDNAQuality();
                    if (newQuality > 100) {
                        newQuality = 100;
                    }
                    DinoDNA newDNA = new DinoDNA(dna1.getDinosaur(), newQuality, dna1.getGenetics());
                    NBTTagCompound outputTag = new NBTTagCompound();
                    newDNA.writeToNBT(outputTag);
                    output.func_77982_d(outputTag);
                } else if (storageId.equals("PlantDNA")) {
                    PlantDNA dna1 = PlantDNA.readFromNBT(((ItemStack)this.slots.get(8)).func_77978_p());
                    PlantDNA dna2 = PlantDNA.readFromNBT(((ItemStack)this.slots.get(9)).func_77978_p());
                    int newQuality = dna1.getDNAQuality() + dna2.getDNAQuality();
                    if (newQuality > 100) {
                        newQuality = 100;
                    }
                    PlantDNA newDNA = new PlantDNA(dna1.getPlant(), newQuality);
                    NBTTagCompound outputTag = new NBTTagCompound();
                    newDNA.writeToNBT(outputTag);
                    output.func_77982_d(outputTag);
                }
                this.mergeStack(11, output);
                this.decreaseStackSize(8);
                this.decreaseStackSize(9);
            }
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return this.hybridizerMode ? 10 : 11;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 1000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return this.hybridizerMode ? HYBRIDIZER_INPUTS : COMBINATOR_INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return this.getInputs();
    }

    @Override
    protected int[] getOutputs() {
        return this.hybridizerMode ? HYBRIDIZER_OUTPUTS : COMBINATOR_OUTPUTS;
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slots) {
        this.slots = slots;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new DNACombinatorHybridizerContainer(playerInventory, (TileEntity)this);
    }

    @Override
    public String func_174875_k() {
        return "jurassicraft:dna_comb_hybrid";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.dna_combinator_hybridizer";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hybridizerMode = nbt.func_74767_n("HybridizerMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74757_a("HybridizerMode", this.hybridizerMode);
        return nbt;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return Ints.asList((int[])(this.hybridizerMode ? HYBRIDIZER_OUTPUTS : COMBINATOR_OUTPUTS)).contains(slotID);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return Ints.asList((int[])(this.hybridizerMode ? HYBRIDIZER_INPUTS : COMBINATOR_INPUTS)).contains(slotID) && itemstack != null && itemstack.func_77973_b() == ItemHandler.STORAGE_DISC && this.func_70301_a(slotID).func_190916_E() == 0 && itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("DNAQuality");
    }

    public boolean getMode() {
        return this.hybridizerMode;
    }

    public void setMode(boolean mode) {
        this.hybridizerMode = mode;
        this.processTime[0] = 0;
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.hybridizerMode ? "container.dna_hybridizer" : "container.dna_combinator", new Object[0]);
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }
}

