/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.particle.WashingParticle;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.api.CleanableItem;
import org.jurassicraft.server.block.OrientedBlock;
import org.jurassicraft.server.block.entity.ISyncable;
import org.jurassicraft.server.container.CleaningStationContainer;
import org.jurassicraft.server.message.TileEntityFieldsMessage;

public class CleaningStationBlockEntity
extends TileEntityLockable
implements ITickable,
ISidedInventory,
ISyncable {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{7, 6, 5, 4, 3, 2};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private int cleaningStationWaterTime;
    private int currentItemWaterTime;
    private int cleanTime;
    private int totalCleanTime;
    private ItemStack cleanedItemResult = ItemStack.field_190927_a;
    private String customName;
    private boolean isCleaning = false;
    private boolean prevIsCleaning = false;
    public float cleaningRotation = 0.0f;
    public float rotationAmount = 0.0f;
    private float prevCleaningRotation;
    IItemHandler handlerPull = new SidedInvWrapper(this, null){

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1 && this.inv.func_70301_a(slot) != null && this.inv.func_70301_a(slot).func_77973_b() == Items.field_151133_ar) {
                return super.extractItem(slot, amount, simulate);
            }
            if (Ints.asList((int[])SLOTS_BOTTOM).contains(slot)) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }
    };

    @SideOnly(value=Side.CLIENT)
    public static boolean isCleaning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151131_as;
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.slots, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.slots.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.slots.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean send = false;
        if (!this.field_145850_b.field_72995_K && index == 0 && ItemStack.field_190927_a == stack) {
            send = true;
        }
        boolean flag = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.slots.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.slots.get(index)));
        this.slots.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCleanTime = this.getStackWashTime(stack);
            this.cleanTime = 0;
            this.func_70296_d();
        }
        if (send) {
            JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0));
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.cleaning_station";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            ItemStack stack = new ItemStack(item);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.size()) continue;
            this.slots.set((int)slot, (Object)stack);
        }
        this.cleaningStationWaterTime = compound.func_74765_d("WaterTime");
        this.cleanTime = compound.func_74765_d("CleanTime");
        this.prevIsCleaning = this.cleanTime > 0;
        this.totalCleanTime = compound.func_74765_d("CleanTimeTotal");
        this.currentItemWaterTime = this.getItemCleanTime((ItemStack)this.slots.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("WaterTime", (short)this.cleaningStationWaterTime);
        compound.func_74777_a("CleanTime", (short)this.cleanTime);
        compound.func_74777_a("CleanTimeTotal", (short)this.totalCleanTime);
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.slots.size(); ++slot) {
            if (((ItemStack)this.slots.get(slot)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            ((ItemStack)this.slots.get(slot)).func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean hasWater() {
        return this.cleaningStationWaterTime > 0;
    }

    public boolean isCleaning() {
        return this.cleanTime > 0;
    }

    public void func_73660_a() {
        boolean isCleaning = this.hasWater();
        boolean dirty = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasWater() && this.canClean()) {
                --this.cleaningStationWaterTime;
                dirty = true;
            }
            if (!this.hasWater() && (((ItemStack)this.slots.get(1)).func_190926_b() || ((ItemStack)this.slots.get(0)).func_190926_b())) {
                if (!this.hasWater() && this.cleanTime > 0) {
                    this.cleanTime = MathHelper.func_76125_a((int)(this.cleanTime - 2), (int)0, (int)this.totalCleanTime);
                    dirty = true;
                }
            } else {
                if (!this.hasWater() && this.canClean() && CleaningStationBlockEntity.isItemFuel((ItemStack)this.slots.get(1))) {
                    this.currentItemWaterTime = this.cleaningStationWaterTime = this.getItemCleanTime((ItemStack)this.slots.get(1));
                    if (this.hasWater()) {
                        dirty = true;
                        if (!((ItemStack)this.slots.get(1)).func_190926_b()) {
                            if (((ItemStack)this.slots.get(1)).func_190916_E() == 1) {
                                this.slots.set(1, (Object)((ItemStack)this.slots.get(1)).func_77973_b().getContainerItem((ItemStack)this.slots.get(1)));
                            } else {
                                ((ItemStack)this.slots.get(1)).func_190918_g(1);
                            }
                        }
                    }
                }
                if (this.hasWater() && this.canClean() && this.cleaningStationWaterTime > 0) {
                    ++this.cleanTime;
                    if (this.cleanTime == this.totalCleanTime) {
                        this.cleanTime = 0;
                        this.totalCleanTime = this.getStackWashTime((ItemStack)this.slots.get(0));
                        this.cleanItem();
                        dirty = true;
                    }
                } else {
                    this.cleanTime = 0;
                    dirty = true;
                }
            }
            if (isCleaning != this.hasWater()) {
                dirty = true;
            }
            if (this.cleaningStationWaterTime == 0) {
                this.cleanTime = 0;
            }
            this.isCleaning = this.isCleaning();
            if (this.isCleaning != this.prevIsCleaning) {
                this.prevIsCleaning = this.isCleaning;
                JurassiCraft.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0));
            }
        } else {
            this.updateRotation();
        }
        if (this.field_145850_b.field_72995_K && this.isCleaning) {
            this.spawnClientWaterParticles();
        }
        if (dirty && !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnClientWaterParticles() {
        boolean isInvertedRotated;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing value = (EnumFacing)state.func_177229_b((IProperty)OrientedBlock.FACING);
        int rot = value.func_176736_b();
        double firstAchsis = 0.5;
        double secondAchsis = 0.34;
        double secondAchsis2 = 1.0 - secondAchsis;
        double velX = 0.0;
        double velZ = 0.07;
        boolean bl = isInvertedRotated = rot == 1 || rot == 3;
        if (!isInvertedRotated) {
            double tmp = firstAchsis;
            firstAchsis = secondAchsis;
            secondAchsis = tmp;
            velX = velZ;
            velZ = 0.0;
        }
        for (int i = 0; i < 3; ++i) {
            Minecraft mc = ClientProxy.MC;
            mc.field_71452_i.func_78873_a((Particle)new WashingParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + firstAchsis, (double)this.field_174879_c.func_177956_o() + 0.64, (double)this.field_174879_c.func_177952_p() + secondAchsis, velX, 0.0, velZ, rot));
            mc.field_71452_i.func_78873_a((Particle)new WashingParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + (isInvertedRotated ? firstAchsis : secondAchsis2), (double)this.field_174879_c.func_177956_o() + 0.64, (double)this.field_174879_c.func_177952_p() + (isInvertedRotated ? secondAchsis2 : secondAchsis), -velX, 0.0, -velZ, rot));
            mc.field_71452_i.func_78873_a((Particle)new WashingParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + firstAchsis, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + secondAchsis, velX, -0.07, velZ, rot));
            mc.field_71452_i.func_78873_a((Particle)new WashingParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + (isInvertedRotated ? firstAchsis : secondAchsis2), (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + (isInvertedRotated ? secondAchsis2 : secondAchsis), -velX, -0.07, -velZ, rot));
        }
    }

    private int getItemCleanTime(ItemStack stack) {
        return 1600;
    }

    public int getStackWashTime(ItemStack stack) {
        return 200;
    }

    private boolean canClean() {
        CleanableItem cleanableItem = CleanableItem.getCleanableItem((ItemStack)this.slots.get(0));
        if (cleanableItem != null && cleanableItem.isCleanable((ItemStack)this.slots.get(0))) {
            if (this.cleanedItemResult.func_190926_b()) {
                this.cleanedItemResult = cleanableItem.getCleanedItem((ItemStack)this.slots.get(0), this.field_145850_b.field_73012_v);
            }
            for (int i = 2; i < 8; ++i) {
                if (!CleaningStationBlockEntity.isStackable((ItemStack)this.slots.get(i), this.cleanedItemResult)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanItem() {
        if (this.canClean()) {
            for (int i = 2; i < 8; ++i) {
                ItemStack slot = (ItemStack)this.slots.get(i);
                if (!CleaningStationBlockEntity.isStackable(slot, this.cleanedItemResult)) continue;
                if (slot.func_190926_b()) {
                    this.slots.set(i, (Object)this.cleanedItemResult.func_77946_l());
                } else {
                    slot.func_190917_f(this.cleanedItemResult.func_190916_E());
                }
                ItemStack shrinked = ((ItemStack)this.slots.get(0)).func_77946_l();
                shrinked.func_190918_g(1);
                this.func_70299_a(0, shrinked);
                this.cleanedItemResult = ItemStack.field_190927_a;
                if (((ItemStack)this.slots.get(0)).func_190916_E() <= 0) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
                this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
                break;
            }
        }
    }

    private static boolean isStackable(ItemStack slotStack, ItemStack insertingStack) {
        return slotStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)insertingStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)insertingStack) && slotStack.func_77952_i() == insertingStack.func_77952_i() && slotStack.func_77976_d() - slotStack.func_190916_E() >= insertingStack.func_190916_E();
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        fields.add((Object)this.isCleaning);
        fields.add(this.slots.get(0));
        return fields;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return ArrayUtils.addAll((int[])SLOTS_TOP, (int[])ArrayUtils.addAll((int[])SLOTS_SIDES, (int[])SLOTS_BOTTOM));
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return Ints.asList((int[])SLOTS_TOP).contains(slotID) ? itemstack != null && CleanableItem.getCleanableItem(itemstack) != null && CleanableItem.getCleanableItem(itemstack).isCleanable(itemstack) : Ints.asList((int[])SLOTS_SIDES).contains(slotID) && itemstack != null && CleaningStationBlockEntity.isItemFuel(itemstack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerPull;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String func_174875_k() {
        return "jurassicraft:cleaning_station";
    }

    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer playerIn) {
        return new CleaningStationContainer(inventory, (TileEntity)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.cleaningStationWaterTime;
            }
            case 1: {
                return this.currentItemWaterTime;
            }
            case 2: {
                return this.cleanTime;
            }
            case 3: {
                return this.totalCleanTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.cleaningStationWaterTime = value;
                break;
            }
            case 1: {
                this.currentItemWaterTime = value;
                break;
            }
            case 2: {
                this.cleanTime = value;
                break;
            }
            case 3: {
                this.totalCleanTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.slots.clear();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_191420_l() {
        return false;
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.isCleaning = fields.readBoolean();
            this.func_70299_a(0, ByteBufUtils.readItemStack((ByteBuf)fields));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRotation() {
        this.prevCleaningRotation = this.cleaningRotation;
        if (!ClientProxy.MC.func_147113_T()) {
            if (this.isCleaning) {
                this.rotationAmount += 0.008f;
                this.rotationAmount *= 1.01f;
            } else {
                this.rotationAmount -= 0.01f;
                this.rotationAmount *= 0.95f;
            }
            if (this.rotationAmount < 0.0f) {
                this.rotationAmount = 0.0f;
            }
            if (this.rotationAmount > 1.2f) {
                this.rotationAmount = 1.2f;
            }
            this.cleaningRotation += this.rotationAmount;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getRenderCleaningRotation(float particialTicks) {
        return this.prevCleaningRotation + (this.cleaningRotation - this.prevCleaningRotation) * particialTicks;
    }
}

