/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jurassicraft.server.block.entity.TourRailBlockEntity;
import org.jurassicraft.server.entity.vehicle.VehicleEntity;
import org.jurassicraft.server.tab.TabHandler;

public final class TourRailBlock
extends Block {
    public static final PropertyEnum<EnumRailDirection> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumRailDirection.class);
    protected static final AxisAlignedBB FLAT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected static final AxisAlignedBB ASCENDING_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private final SpeedType speedType;

    public TourRailBlock(SpeedType speedType) {
        super(Material.field_151594_q);
        this.speedType = speedType;
        this.func_149647_a(TabHandler.BLOCKS);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)((Object)EnumRailDirection.NORTH_SOUTH)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_175625_s(pos) instanceof TourRailBlockEntity ? state.func_177226_a(SHAPE, (Comparable)((Object)TourRailBlock.getRailDirection(worldIn, pos))) : this.func_176223_P();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TourRailBlockEntity();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public SpeedType getSpeedType() {
        return this.speedType;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K) {
            world.func_175685_c(pos, (Block)this, true);
            world.func_175685_c(pos.func_177977_b(), (Block)this, true);
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumRailDirection enumRailDirection = state.func_177230_c() == this ? TourRailBlock.getRailDirection(source, pos) : null;
        return enumRailDirection != null && enumRailDirection.isAscending() ? ASCENDING_AABB : FLAT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.updateDir(worldIn, pos, state, true);
        if (!worldIn.field_72995_K) {
            state.func_189546_a(worldIn, pos, (Block)this, pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            EnumRailDirection dir = TourRailBlock.getRailDirection((IBlockAccess)worldIn, pos);
            boolean flag = false;
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                flag = true;
            }
            if (dir == EnumRailDirection.ASCENDING_EAST && !worldIn.func_180495_p(pos.func_177974_f()).isSideSolid((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.UP)) {
                flag = true;
            } else if (dir == EnumRailDirection.ASCENDING_WEST && !worldIn.func_180495_p(pos.func_177976_e()).isSideSolid((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.UP)) {
                flag = true;
            } else if (dir == EnumRailDirection.ASCENDING_NORTH && !worldIn.func_180495_p(pos.func_177978_c()).isSideSolid((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.UP)) {
                flag = true;
            } else if (dir == EnumRailDirection.ASCENDING_SOUTH && !worldIn.func_180495_p(pos.func_177968_d()).isSideSolid((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.UP)) {
                flag = true;
            }
            if (flag && !worldIn.func_175623_d(pos)) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            } else {
                this.updateState(state, worldIn, pos, blockIn);
            }
        }
    }

    public static EnumRailDirection getRailDirection(IBlockAccess world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof TourRailBlockEntity ? ((TourRailBlockEntity)world.func_175625_s(pos)).getDirection() : EnumRailDirection.NORTH_SOUTH;
    }

    protected void updateState(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185897_m() || new Rail(world, pos, state).countAdjacentRails() == 3) {
            // empty if block
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_185473_a(world, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public static boolean isRailBlock(World worldIn, BlockPos pos) {
        return TourRailBlock.isRailBlock(worldIn.func_180495_p(pos));
    }

    public static boolean isRailBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof TourRailBlock;
    }

    private IBlockState updateDir(World worldIn, BlockPos pos, IBlockState state, boolean initialPlacement) {
        return new Rail(worldIn, pos, state).place(initialPlacement).getBlockState();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum SpeedType {
        NONE(null, -1),
        SLOW(VehicleEntity.Speed.SLOW, 0xA80000),
        MEDIUM(VehicleEntity.Speed.MEDIUM, 16741888),
        FAST(VehicleEntity.Speed.FAST, 43008);

        private final VehicleEntity.Speed speed;
        private final int color;

        private SpeedType(VehicleEntity.Speed speed, int color) {
            this.speed = speed;
            this.color = color;
        }

        @Nonnull
        public VehicleEntity.Speed getSpeed(VehicleEntity.Speed defaultSpeed) {
            return this.speed == null ? defaultSpeed : this.speed;
        }

        @Nonnull
        public int getColor() {
            return this.color;
        }
    }

    public class Rail {
        private final World world;
        private final BlockPos pos;
        private final TourRailBlock block;
        private IBlockState state;
        private final List<BlockPos> connectedRails = Lists.newArrayList();

        public Rail(World worldIn, BlockPos pos, IBlockState state) {
            this.world = worldIn;
            this.pos = pos;
            this.state = state;
            this.block = (TourRailBlock)state.func_177230_c();
            EnumRailDirection TourRailBlock$enumraildirection = TourRailBlock.getRailDirection((IBlockAccess)worldIn, pos);
            this.updateConnectedRails(TourRailBlock$enumraildirection);
        }

        public List<BlockPos> getConnectedRails() {
            return this.connectedRails;
        }

        private void updateConnectedRails(EnumRailDirection railDirection) {
            this.connectedRails.clear();
            switch (railDirection) {
                case NORTH_SOUTH: {
                    this.connectedRails.add(this.pos.func_177978_c());
                    this.connectedRails.add(this.pos.func_177968_d());
                    break;
                }
                case EAST_WEST: {
                    this.connectedRails.add(this.pos.func_177976_e());
                    this.connectedRails.add(this.pos.func_177974_f());
                    break;
                }
                case ASCENDING_EAST: {
                    this.connectedRails.add(this.pos.func_177976_e());
                    this.connectedRails.add(this.pos.func_177974_f().func_177984_a());
                    break;
                }
                case ASCENDING_WEST: {
                    this.connectedRails.add(this.pos.func_177976_e().func_177984_a());
                    this.connectedRails.add(this.pos.func_177974_f());
                    break;
                }
                case ASCENDING_NORTH: {
                    this.connectedRails.add(this.pos.func_177978_c().func_177984_a());
                    this.connectedRails.add(this.pos.func_177968_d());
                    break;
                }
                case ASCENDING_SOUTH: {
                    this.connectedRails.add(this.pos.func_177978_c());
                    this.connectedRails.add(this.pos.func_177968_d().func_177984_a());
                    break;
                }
                case SOUTH_EAST: {
                    this.connectedRails.add(this.pos.func_177974_f());
                    this.connectedRails.add(this.pos.func_177968_d());
                    break;
                }
                case SOUTH_WEST: {
                    this.connectedRails.add(this.pos.func_177976_e());
                    this.connectedRails.add(this.pos.func_177968_d());
                    break;
                }
                case NORTH_WEST: {
                    this.connectedRails.add(this.pos.func_177976_e());
                    this.connectedRails.add(this.pos.func_177978_c());
                    break;
                }
                case NORTH_EAST: {
                    this.connectedRails.add(this.pos.func_177974_f());
                    this.connectedRails.add(this.pos.func_177978_c());
                    break;
                }
                case DIAGONAL_NE_SW: {
                    this.connectedRails.add(this.pos.func_177978_c().func_177974_f());
                    this.connectedRails.add(this.pos.func_177968_d().func_177976_e());
                    break;
                }
                case DIAGONAL_NW_SE: {
                    this.connectedRails.add(this.pos.func_177978_c().func_177976_e());
                    this.connectedRails.add(this.pos.func_177968_d().func_177974_f());
                    break;
                }
                case HORIZONTAL_NE: {
                    this.connectedRails.add(this.pos.func_177976_e());
                    this.connectedRails.add(this.pos.func_177978_c().func_177974_f());
                    break;
                }
                case HORIZONTAL_SE: {
                    this.connectedRails.add(this.pos.func_177976_e());
                    this.connectedRails.add(this.pos.func_177968_d().func_177974_f());
                    break;
                }
                case HORIZONTAL_NW: {
                    this.connectedRails.add(this.pos.func_177974_f());
                    this.connectedRails.add(this.pos.func_177978_c().func_177976_e());
                    break;
                }
                case HORIZONTAL_SW: {
                    this.connectedRails.add(this.pos.func_177974_f());
                    this.connectedRails.add(this.pos.func_177968_d().func_177976_e());
                    break;
                }
                case VERTICAL_NE: {
                    this.connectedRails.add(this.pos.func_177968_d());
                    this.connectedRails.add(this.pos.func_177978_c().func_177974_f());
                    break;
                }
                case VERTICAL_SE: {
                    this.connectedRails.add(this.pos.func_177978_c());
                    this.connectedRails.add(this.pos.func_177968_d().func_177974_f());
                    break;
                }
                case VERTICAL_NW: {
                    this.connectedRails.add(this.pos.func_177968_d());
                    this.connectedRails.add(this.pos.func_177978_c().func_177976_e());
                    break;
                }
                case VERTICAL_SW: {
                    this.connectedRails.add(this.pos.func_177978_c());
                    this.connectedRails.add(this.pos.func_177968_d().func_177976_e());
                }
            }
        }

        private void removeSoftConnections() {
            for (int i = 0; i < this.connectedRails.size(); ++i) {
                Rail TourRailBlock$rail = this.findRailAt(this.connectedRails.get(i));
                if (TourRailBlock$rail != null && TourRailBlock$rail.isConnectedToRail(this)) {
                    this.connectedRails.set(i, TourRailBlock$rail.pos);
                    continue;
                }
                this.connectedRails.remove(i--);
            }
        }

        private boolean hasRailAt(BlockPos pos) {
            return TourRailBlock.isRailBlock(this.world, pos) || TourRailBlock.isRailBlock(this.world, pos.func_177984_a()) || TourRailBlock.isRailBlock(this.world, pos.func_177977_b());
        }

        @Nullable
        private Rail findRailAt(BlockPos pos) {
            Rail rail;
            IBlockState iblockstate = this.world.func_180495_p(pos);
            if (TourRailBlock.isRailBlock(iblockstate)) {
                TourRailBlock tourRailBlock = TourRailBlock.this;
                ((Object)((Object)tourRailBlock)).getClass();
                return tourRailBlock.new Rail(this.world, pos, iblockstate);
            }
            BlockPos lvt_2_1_ = pos.func_177984_a();
            iblockstate = this.world.func_180495_p(lvt_2_1_);
            if (TourRailBlock.isRailBlock(iblockstate)) {
                TourRailBlock tourRailBlock = TourRailBlock.this;
                ((Object)((Object)tourRailBlock)).getClass();
                return tourRailBlock.new Rail(this.world, lvt_2_1_, iblockstate);
            }
            lvt_2_1_ = pos.func_177977_b();
            iblockstate = this.world.func_180495_p(lvt_2_1_);
            if (TourRailBlock.isRailBlock(iblockstate)) {
                TourRailBlock tourRailBlock = TourRailBlock.this;
                ((Object)((Object)tourRailBlock)).getClass();
                rail = tourRailBlock.new Rail(this.world, lvt_2_1_, iblockstate);
            } else {
                rail = null;
            }
            return rail;
        }

        private boolean isConnectedToRail(Rail rail) {
            return this.isConnectedTo(rail.pos);
        }

        private boolean isConnectedTo(BlockPos posIn) {
            for (int i = 0; i < this.connectedRails.size(); ++i) {
                BlockPos blockpos = this.connectedRails.get(i);
                if (blockpos.func_177958_n() != posIn.func_177958_n() || blockpos.func_177952_p() != posIn.func_177952_p()) continue;
                return true;
            }
            return false;
        }

        protected int countAdjacentRails() {
            int i = 0;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                if (!this.hasRailAt(this.pos.func_177972_a(enumfacing))) continue;
                ++i;
            }
            for (int i1 = 0; i1 < 4; ++i1) {
                if (!this.hasRailAt(this.pos.func_177964_d(i1 % 2 == 0 ? 1 : -1).func_177965_g(Math.floorDiv(i1, 2) == 0 ? 1 : -1))) continue;
                ++i;
            }
            return i;
        }

        private boolean canConnectTo(Rail rail) {
            return this.isConnectedToRail(rail) || this.connectedRails.size() != 2;
        }

        private void connectTo(Rail rail) {
            this.connectedRails.add(rail.pos);
            BlockPos blockpos = this.pos.func_177978_c();
            BlockPos blockpos1 = this.pos.func_177968_d();
            BlockPos blockpos2 = this.pos.func_177976_e();
            BlockPos blockpos3 = this.pos.func_177974_f();
            boolean flag = this.isConnectedTo(blockpos);
            boolean flag1 = this.isConnectedTo(blockpos1);
            boolean flag2 = this.isConnectedTo(blockpos2);
            boolean flag3 = this.isConnectedTo(blockpos3);
            EnumRailDirection railDirection = null;
            if (flag || flag1) {
                railDirection = EnumRailDirection.NORTH_SOUTH;
            }
            if (flag2 || flag3) {
                railDirection = EnumRailDirection.EAST_WEST;
            }
            if (flag1 && flag3 && !flag && !flag2) {
                railDirection = EnumRailDirection.SOUTH_EAST;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                railDirection = EnumRailDirection.SOUTH_WEST;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                railDirection = EnumRailDirection.NORTH_WEST;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                railDirection = EnumRailDirection.NORTH_EAST;
            }
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                if (TourRailBlock.isRailBlock(this.world, blockpos.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_NORTH;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos1.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_SOUTH;
                }
            }
            if (railDirection == EnumRailDirection.EAST_WEST) {
                if (TourRailBlock.isRailBlock(this.world, blockpos3.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_EAST;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos2.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_WEST;
                }
            }
            if (railDirection == null) {
                BlockPos nw = this.pos.func_177978_c().func_177976_e();
                BlockPos ne = this.pos.func_177978_c().func_177974_f();
                BlockPos sw = this.pos.func_177968_d().func_177976_e();
                BlockPos se = this.pos.func_177968_d().func_177974_f();
                boolean can_nw = this.isConnectedTo(nw);
                boolean can_ne = this.isConnectedTo(ne);
                boolean can_sw = this.isConnectedTo(sw);
                boolean can_se = this.isConnectedTo(se);
                railDirection = can_ne || can_sw ? EnumRailDirection.DIAGONAL_NE_SW : (can_nw || can_se ? EnumRailDirection.DIAGONAL_NW_SE : EnumRailDirection.NORTH_SOUTH);
            }
            boolean connectDiag = false;
            String connectionName = "";
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                connectionName = connectionName + "VERTICAL_";
                boolean connectedNorth = this.isConnectedTo(this.pos.func_177978_c());
                boolean connectedSouth = this.isConnectedTo(this.pos.func_177968_d());
                if (!connectedNorth || !connectedSouth) {
                    connectionName = connectionName + (connectedNorth ? "S" : "N");
                    BlockPos connectPos = this.pos.func_177964_d(connectedNorth ? -1 : 1);
                    if (this.isConnectedTo(connectPos.func_177974_f())) {
                        connectionName = connectionName + "E";
                        connectDiag = true;
                    } else if (this.isConnectedTo(connectPos.func_177976_e())) {
                        connectionName = connectionName + "W";
                        connectDiag = true;
                    }
                }
            } else if (railDirection == EnumRailDirection.EAST_WEST) {
                connectionName = connectionName + "HORIZONTAL_";
                boolean connectedEast = this.isConnectedTo(this.pos.func_177974_f());
                boolean connectedWest = this.isConnectedTo(this.pos.func_177976_e());
                if (!connectedEast || !connectedWest) {
                    String suffix = connectedEast ? "W" : "E";
                    BlockPos connectPos = this.pos.func_177965_g(connectedEast ? -1 : 1);
                    if (this.isConnectedTo(connectPos.func_177978_c())) {
                        connectionName = connectionName + "N";
                        connectDiag = true;
                    } else if (this.isConnectedTo(connectPos.func_177968_d())) {
                        connectionName = connectionName + "S";
                        connectDiag = true;
                    }
                    connectionName = connectionName + suffix;
                }
            }
            if (connectDiag) {
                railDirection = EnumRailDirection.valueOf(connectionName);
            }
            this.world.func_180501_a(this.pos, this.state, 3);
            ((TourRailBlockEntity)this.world.func_175625_s(this.pos)).setDirection(railDirection);
        }

        private boolean hasNeighborRail(BlockPos posIn) {
            Rail TourRailBlock$rail = this.findRailAt(posIn);
            if (TourRailBlock$rail == null) {
                return false;
            }
            TourRailBlock$rail.removeSoftConnections();
            return TourRailBlock$rail.canConnectTo(this);
        }

        public Rail place(boolean initialPlacement) {
            BlockPos blockpos = this.pos.func_177978_c();
            BlockPos blockpos1 = this.pos.func_177968_d();
            BlockPos blockpos2 = this.pos.func_177976_e();
            BlockPos blockpos3 = this.pos.func_177974_f();
            boolean flag = this.hasNeighborRail(blockpos);
            boolean flag1 = this.hasNeighborRail(blockpos1);
            boolean flag2 = this.hasNeighborRail(blockpos2);
            boolean flag3 = this.hasNeighborRail(blockpos3);
            EnumRailDirection railDirection = null;
            if ((flag || flag1) && !flag2 && !flag3) {
                railDirection = EnumRailDirection.NORTH_SOUTH;
            }
            if ((flag2 || flag3) && !flag && !flag1) {
                railDirection = EnumRailDirection.EAST_WEST;
            }
            if (flag1 && flag3 && !flag && !flag2) {
                railDirection = EnumRailDirection.SOUTH_EAST;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                railDirection = EnumRailDirection.SOUTH_WEST;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                railDirection = EnumRailDirection.NORTH_WEST;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                railDirection = EnumRailDirection.NORTH_EAST;
            }
            if (railDirection == null) {
                if (flag || flag1) {
                    railDirection = EnumRailDirection.NORTH_SOUTH;
                }
                if (flag2 || flag3) {
                    railDirection = EnumRailDirection.EAST_WEST;
                }
            }
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                if (TourRailBlock.isRailBlock(this.world, blockpos.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_NORTH;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos1.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_SOUTH;
                }
            }
            if (railDirection == EnumRailDirection.EAST_WEST) {
                if (TourRailBlock.isRailBlock(this.world, blockpos3.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_EAST;
                }
                if (TourRailBlock.isRailBlock(this.world, blockpos2.func_177984_a())) {
                    railDirection = EnumRailDirection.ASCENDING_WEST;
                }
            }
            if (railDirection == null) {
                BlockPos nw = this.pos.func_177978_c().func_177976_e();
                BlockPos ne = this.pos.func_177978_c().func_177974_f();
                BlockPos sw = this.pos.func_177968_d().func_177976_e();
                BlockPos se = this.pos.func_177968_d().func_177974_f();
                boolean can_nw = this.hasNeighborRail(nw);
                boolean can_ne = this.hasNeighborRail(ne);
                boolean can_sw = this.hasNeighborRail(sw);
                boolean can_se = this.hasNeighborRail(se);
                railDirection = can_ne || can_sw ? EnumRailDirection.DIAGONAL_NE_SW : (can_nw || can_se ? EnumRailDirection.DIAGONAL_NW_SE : EnumRailDirection.NORTH_SOUTH);
            }
            boolean connectDiag = false;
            StringBuilder connectionName = new StringBuilder();
            if (railDirection == EnumRailDirection.NORTH_SOUTH) {
                connectionName.append("VERTICAL_");
                boolean connectedNorth = this.hasNeighborRail(this.pos.func_177978_c());
                boolean connectedSouth = this.hasNeighborRail(this.pos.func_177968_d());
                if (!connectedNorth || !connectedSouth) {
                    connectionName.append(connectedNorth ? "S" : "N");
                    BlockPos connectPos = this.pos.func_177964_d(connectedNorth ? -1 : 1);
                    if (this.hasNeighborRail(connectPos.func_177974_f())) {
                        connectionName.append("E");
                        connectDiag = true;
                    } else if (this.hasNeighborRail(connectPos.func_177976_e())) {
                        connectionName.append("W");
                        connectDiag = true;
                    }
                }
            } else if (railDirection == EnumRailDirection.EAST_WEST) {
                connectionName.append("HORIZONTAL_");
                boolean connectedEast = this.hasNeighborRail(this.pos.func_177974_f());
                boolean connectedWest = this.hasNeighborRail(this.pos.func_177976_e());
                if (!connectedEast || !connectedWest) {
                    String suffix = connectedEast ? "W" : "E";
                    BlockPos connectPos = this.pos.func_177965_g(connectedEast ? -1 : 1);
                    if (this.hasNeighborRail(connectPos.func_177978_c())) {
                        connectionName.append("N");
                        connectDiag = true;
                    } else if (this.hasNeighborRail(connectPos.func_177968_d())) {
                        connectionName.append("S");
                        connectDiag = true;
                    }
                    connectionName.append(suffix);
                }
            }
            if (connectDiag) {
                railDirection = EnumRailDirection.valueOf(connectionName.toString());
            }
            this.updateConnectedRails(railDirection);
            if (initialPlacement || ((TourRailBlockEntity)this.world.func_175625_s(this.pos)).getDirection() != railDirection) {
                this.world.func_180501_a(this.pos, this.state, 3);
                ((TourRailBlockEntity)this.world.func_175625_s(this.pos)).setDirection(railDirection);
                for (int i = 0; i < this.connectedRails.size(); ++i) {
                    Rail TourRailBlock$rail = this.findRailAt(this.connectedRails.get(i));
                    if (TourRailBlock$rail == null) continue;
                    TourRailBlock$rail.removeSoftConnections();
                    if (!TourRailBlock$rail.canConnectTo(this)) continue;
                    TourRailBlock$rail.connectTo(this);
                }
            }
            return this;
        }

        public IBlockState getBlockState() {
            return this.state;
        }
    }

    public static enum EnumRailDirection implements IStringSerializable
    {
        NORTH_SOUTH(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f),
        EAST_WEST(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f),
        ASCENDING_EAST(-1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f),
        ASCENDING_WEST(-1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f),
        ASCENDING_NORTH(0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 1.0f),
        ASCENDING_SOUTH(0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f),
        SOUTH_EAST(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f),
        SOUTH_WEST(0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f),
        NORTH_WEST(0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f),
        NORTH_EAST(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f),
        DIAGONAL_NE_SW(0.5f, 0.0f, -0.5f, -0.5f, 0.0f, 0.5f),
        DIAGONAL_NW_SE(0.5f, 0.0f, 0.5f, -0.5f, 0.0f, -0.5f),
        HORIZONTAL_NE(EnumFacing.NORTH, EnumFacing.EAST, DIAGONAL_NE_SW, EAST_WEST),
        HORIZONTAL_NW(EnumFacing.NORTH, EnumFacing.WEST, DIAGONAL_NW_SE, EAST_WEST),
        HORIZONTAL_SE(EnumFacing.SOUTH, EnumFacing.EAST, DIAGONAL_NW_SE, EAST_WEST),
        HORIZONTAL_SW(EnumFacing.SOUTH, EnumFacing.WEST, DIAGONAL_NE_SW, EAST_WEST),
        VERTICAL_NE(EnumFacing.NORTH, EnumFacing.EAST, DIAGONAL_NE_SW, NORTH_SOUTH),
        VERTICAL_NW(EnumFacing.NORTH, EnumFacing.WEST, DIAGONAL_NW_SE, NORTH_SOUTH),
        VERTICAL_SE(EnumFacing.SOUTH, EnumFacing.EAST, DIAGONAL_NW_SE, NORTH_SOUTH),
        VERTICAL_SW(EnumFacing.SOUTH, EnumFacing.WEST, DIAGONAL_NE_SW, NORTH_SOUTH);

        private final Type type;
        private float forwardX;
        private float forwardY;
        private float forwardZ;
        private float backwardsX;
        private float backwardsY;
        private float backwardsZ;
        private Predicate<EnumFacing> facingPredicate;
        private EnumRailDirection diagonalDirection;
        private EnumRailDirection straightDirection;

        private EnumRailDirection(float forwardX, float forward_y, float forward_z, float backwards_x, float backwards_y, float backwards_z) {
            this.forwardX = forwardX;
            this.forwardY = forward_y;
            this.forwardZ = forward_z;
            this.backwardsX = backwards_x;
            this.backwardsY = backwards_y;
            this.backwardsZ = backwards_z;
            this.type = Type.VALUE;
        }

        private EnumRailDirection(EnumFacing facing, EnumFacing facing2, EnumRailDirection diagonalDirection, EnumRailDirection straightDirection) {
            this.type = Type.COPYCAT;
            this.facingPredicate = face -> face == facing || face == facing2;
            this.diagonalDirection = diagonalDirection;
            this.straightDirection = straightDirection;
        }

        public boolean isAscending() {
            return this == ASCENDING_NORTH || this == ASCENDING_EAST || this == ASCENDING_SOUTH || this == ASCENDING_WEST;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public float getForwardX(EnumFacing face) {
            if (this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getForwardX(null);
            }
            return this.forwardX;
        }

        public float getForwardY(EnumFacing face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getForwardY(null);
            }
            return this.forwardY;
        }

        public float getForwardZ(EnumFacing face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getForwardZ(null);
            }
            return this.forwardZ;
        }

        public float getBackwardsX(EnumFacing face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getBackwardsX(null);
            }
            return this.backwardsX;
        }

        public float getBackwardsY(EnumFacing face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getBackwardsY(null);
            }
            return this.backwardsY;
        }

        public float getBackwardsZ(EnumFacing face) {
            if (this.type == Type.COPYCAT && this.type == Type.COPYCAT) {
                return (this.facingPredicate.test(face) ? this.diagonalDirection : this.straightDirection).getBackwardsZ(null);
            }
            return this.backwardsZ;
        }

        private static enum Type {
            VALUE,
            COPYCAT;

        }
    }
}

