/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.SubBlocksBlock;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.block.FossilItemBlock;
import org.jurassicraft.server.tab.TabHandler;

public class FossilBlock
extends Block
implements SubBlocksBlock {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)15);
    private int start;

    public FossilBlock(int start) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(TabHandler.FOSSILS);
        this.start = start;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        Map<Integer, Dinosaur> dinosaurs = EntityHandler.getDinosaurs();
        for (int i = 0; i < 16; ++i) {
            Dinosaur dinosaur = dinosaurs.get(i + this.start);
            if (dinosaur == null || !dinosaur.shouldRegister()) continue;
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public Dinosaur getDinosaur(int metadata) {
        return EntityHandler.getDinosaurById(this.start + metadata);
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new FossilItemBlock(this);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }
}

