/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.entity.DisplayBlockEntity;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.DisplayBlockItem;
import org.jurassicraft.server.item.ItemHandler;

public class DisplayBlock
extends BlockContainer {
    public DisplayBlock() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(false);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return DisplayBlock.getBounds(blockAccess, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return DisplayBlock.getBounds((IBlockAccess)world, pos).func_186670_a(pos);
    }

    private static AxisAlignedBB getBounds(IBlockAccess world, BlockPos pos) {
        DisplayBlockEntity displayEntity;
        Dinosaur dinosaur;
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof DisplayBlockEntity && (dinosaur = (displayEntity = (DisplayBlockEntity)entity).getEntity().getDinosaur()) != null && !displayEntity.isSkeleton()) {
            DinosaurMetadata metadata = dinosaur.getMetadata();
            float width = MathHelper.func_76131_a((float)(metadata.getAdultSizeX() * 0.25f), (float)0.1f, (float)1.0f);
            float height = MathHelper.func_76131_a((float)(metadata.getAdultSizeY() * 0.25f), (float)0.1f, (float)1.0f);
            float halfWidth = width / 2.0f;
            return new AxisAlignedBB(0.5 - (double)halfWidth, 0.0, 0.5 - (double)halfWidth, (double)halfWidth + 0.5, (double)height, (double)halfWidth + 0.5);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && DisplayBlock.canBlockStay(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.checkAndDropBlock(world, pos, world.func_180495_p(pos));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(world, pos, state);
    }

    private void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!DisplayBlock.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private static boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185914_p();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemHandler.DISPLAY_BLOCK_ITEM;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return DisplayBlock.getItemFromTile(DisplayBlock.getTile((IBlockAccess)world, pos));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new DisplayBlockEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    private static DisplayBlockEntity getTile(IBlockAccess world, BlockPos pos) {
        return (DisplayBlockEntity)world.func_175625_s(pos);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(world, pos, state, 0);
        }
        super.func_176208_a(world, pos, state, player);
    }

    private static ItemStack getItemFromTile(DisplayBlockEntity tile) {
        int metadata = DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(tile.getEntity().getDinosaur()), tile.isFossile(), tile.isSkeleton());
        ItemStack stack = new ItemStack((Item)ItemHandler.DISPLAY_BLOCK_ITEM, 1, metadata);
        NBTTagCompound nbt = new NBTTagCompound();
        stack.func_77982_d(nbt);
        nbt.func_74774_a("Type", tile.getVariant());
        nbt.func_74774_a("Gender", (byte)(tile.isMale() ? 1 : 2));
        return stack;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        DisplayBlockEntity tile = DisplayBlock.getTile(world, pos);
        if (tile != null) {
            drops.add(DisplayBlock.getItemFromTile(tile));
        }
        return drops;
    }
}

