/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.jurassicraft.server.api.SubBlocksBlock;
import org.jurassicraft.server.block.AmberBlock;
import org.jurassicraft.server.block.AncientItemHoldingBlock;
import org.jurassicraft.server.block.BasicBlock;
import org.jurassicraft.server.block.BugCrateBlock;
import org.jurassicraft.server.block.ClearGlassBlock;
import org.jurassicraft.server.block.ClearGlassPaneBlock;
import org.jurassicraft.server.block.DisplayBlock;
import org.jurassicraft.server.block.EncasedFossilBlock;
import org.jurassicraft.server.block.FossilBlock;
import org.jurassicraft.server.block.FossilizedTrackwayBlock;
import org.jurassicraft.server.block.GypsumStoneBlock;
import org.jurassicraft.server.block.IceShardBlock;
import org.jurassicraft.server.block.NestFossilBlock;
import org.jurassicraft.server.block.PaleoBaleBlock;
import org.jurassicraft.server.block.PeatBlock;
import org.jurassicraft.server.block.PeatMossBlock;
import org.jurassicraft.server.block.PlantFossilBlock;
import org.jurassicraft.server.block.ReinforcedGlassBlock;
import org.jurassicraft.server.block.ReinforcedGlassPaneBlock;
import org.jurassicraft.server.block.SkullDisplay;
import org.jurassicraft.server.block.SwarmBlock;
import org.jurassicraft.server.block.TourRailBlock;
import org.jurassicraft.server.block.entity.AncientItemHoldingBlockEntity;
import org.jurassicraft.server.block.entity.BugCrateBlockEntity;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DNASynthesizerBlockEntity;
import org.jurassicraft.server.block.entity.DisplayBlockEntity;
import org.jurassicraft.server.block.entity.ElectricFenceBaseBlockEntity;
import org.jurassicraft.server.block.entity.ElectricFencePoleBlockEntity;
import org.jurassicraft.server.block.entity.ElectricFenceWireBlockEntity;
import org.jurassicraft.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import org.jurassicraft.server.block.entity.EmbryonicMachineBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.FossilGrinderBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.block.entity.SkullDisplayEntity;
import org.jurassicraft.server.block.entity.TourRailBlockEntity;
import org.jurassicraft.server.block.fence.ElectricFenceBaseBlock;
import org.jurassicraft.server.block.fence.ElectricFencePoleBlock;
import org.jurassicraft.server.block.fence.ElectricFenceWireBlock;
import org.jurassicraft.server.block.fence.FenceType;
import org.jurassicraft.server.block.machine.CleaningStationBlock;
import org.jurassicraft.server.block.machine.CultivatorBottomBlock;
import org.jurassicraft.server.block.machine.CultivatorTopBlock;
import org.jurassicraft.server.block.machine.DNACombinatorHybridizerBlock;
import org.jurassicraft.server.block.machine.DNAExtractorBlock;
import org.jurassicraft.server.block.machine.DNASequencerBlock;
import org.jurassicraft.server.block.machine.DNASynthesizerBlock;
import org.jurassicraft.server.block.machine.EmbryoCalcificationMachineBlock;
import org.jurassicraft.server.block.machine.EmbryonicMachineBlock;
import org.jurassicraft.server.block.machine.FeederBlock;
import org.jurassicraft.server.block.machine.FossilGrinderBlock;
import org.jurassicraft.server.block.machine.IncubatorBlock;
import org.jurassicraft.server.block.machine.SkeletonAssemblyBlock;
import org.jurassicraft.server.block.plant.AjuginuculaSmithiiBlock;
import org.jurassicraft.server.block.plant.AncientPlantBlock;
import org.jurassicraft.server.block.plant.AuloporaBlock;
import org.jurassicraft.server.block.plant.BennettitaleanCycadeoideaBlock;
import org.jurassicraft.server.block.plant.CladochonusBlock;
import org.jurassicraft.server.block.plant.CycadZamitesBlock;
import org.jurassicraft.server.block.plant.DicksoniaBlock;
import org.jurassicraft.server.block.plant.DicroidiumZuberiBlock;
import org.jurassicraft.server.block.plant.DictyophyllumBlock;
import org.jurassicraft.server.block.plant.DoublePlantBlock;
import org.jurassicraft.server.block.plant.EnallheliaBlock;
import org.jurassicraft.server.block.plant.EncephalartosBlock;
import org.jurassicraft.server.block.plant.GracilariaBlock;
import org.jurassicraft.server.block.plant.HippuritesRadiosusBlock;
import org.jurassicraft.server.block.plant.LiriodendritesBlock;
import org.jurassicraft.server.block.plant.LithostrotionBlock;
import org.jurassicraft.server.block.plant.MossBlock;
import org.jurassicraft.server.block.plant.OrontiumMackiiBlock;
import org.jurassicraft.server.block.plant.RaphaeliaBlock;
import org.jurassicraft.server.block.plant.RhamnusSalifocifusBlock;
import org.jurassicraft.server.block.plant.ScalyTreeFernBlock;
import org.jurassicraft.server.block.plant.SerennaVeriformansBlock;
import org.jurassicraft.server.block.plant.SmallChainFernBlock;
import org.jurassicraft.server.block.plant.SmallCycadBlock;
import org.jurassicraft.server.block.plant.SmallPlantBlock;
import org.jurassicraft.server.block.plant.SmallRoyalFernBlock;
import org.jurassicraft.server.block.plant.StylopyllopsisBlock;
import org.jurassicraft.server.block.plant.UmaltolepisBlock;
import org.jurassicraft.server.block.plant.WestIndianLilacBlock;
import org.jurassicraft.server.block.plant.WildOnionBlock;
import org.jurassicraft.server.block.plant.WildPotatoBlock;
import org.jurassicraft.server.block.tree.AncientDoorBlock;
import org.jurassicraft.server.block.tree.AncientDoubleSlabBlock;
import org.jurassicraft.server.block.tree.AncientFenceBlock;
import org.jurassicraft.server.block.tree.AncientFenceGateBlock;
import org.jurassicraft.server.block.tree.AncientLeavesBlock;
import org.jurassicraft.server.block.tree.AncientLogBlock;
import org.jurassicraft.server.block.tree.AncientPlanksBlock;
import org.jurassicraft.server.block.tree.AncientSaplingBlock;
import org.jurassicraft.server.block.tree.AncientSlabHalfBlock;
import org.jurassicraft.server.block.tree.AncientStairsBlock;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.conf.JurassiCraftConfig;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.util.JCBlockVine;
import org.jurassicraft.server.util.RegistryHandler;

public class BlockHandler {
    public static final Map<TreeType, AncientPlanksBlock> ANCIENT_PLANKS = new HashMap<TreeType, AncientPlanksBlock>();
    public static final Map<TreeType, AncientLogBlock> ANCIENT_LOGS = new HashMap<TreeType, AncientLogBlock>();
    public static final Map<TreeType, AncientLeavesBlock> ANCIENT_LEAVES = new HashMap<TreeType, AncientLeavesBlock>();
    public static final Map<TreeType, AncientSaplingBlock> ANCIENT_SAPLINGS = new HashMap<TreeType, AncientSaplingBlock>();
    public static final Map<TreeType, AncientSlabHalfBlock> ANCIENT_SLABS = new HashMap<TreeType, AncientSlabHalfBlock>();
    public static final Map<TreeType, AncientDoubleSlabBlock> ANCIENT_DOUBLE_SLABS = new HashMap<TreeType, AncientDoubleSlabBlock>();
    public static final Map<TreeType, AncientStairsBlock> ANCIENT_STAIRS = new HashMap<TreeType, AncientStairsBlock>();
    public static final Map<TreeType, AncientFenceBlock> ANCIENT_FENCES = new HashMap<TreeType, AncientFenceBlock>();
    public static final Map<TreeType, AncientFenceGateBlock> ANCIENT_FENCE_GATES = new HashMap<TreeType, AncientFenceGateBlock>();
    public static final Map<TreeType, AncientDoorBlock> ANCIENT_DOORS = new HashMap<TreeType, AncientDoorBlock>();
    public static final Map<TreeType, AncientLogBlock> PETRIFIED_LOGS = new HashMap<TreeType, AncientLogBlock>();
    public static final List<FossilBlock> FOSSILS = new ArrayList<FossilBlock>();
    public static final List<EncasedFossilBlock> ENCASED_FOSSILS = new ArrayList<EncasedFossilBlock>();
    public static final PlantFossilBlock PLANT_FOSSIL = new PlantFossilBlock();
    public static final JCBlockVine VINES = new JCBlockVine();
    public static final CleaningStationBlock CLEANING_STATION = new CleaningStationBlock();
    public static final FossilGrinderBlock FOSSIL_GRINDER = new FossilGrinderBlock();
    public static final DNASequencerBlock DNA_SEQUENCER = new DNASequencerBlock();
    public static final DNASynthesizerBlock DNA_SYNTHESIZER = new DNASynthesizerBlock();
    public static final EmbryonicMachineBlock EMBRYONIC_MACHINE = new EmbryonicMachineBlock();
    public static final EmbryoCalcificationMachineBlock EMBRYO_CALCIFICATION_MACHINE = new EmbryoCalcificationMachineBlock();
    public static final IncubatorBlock INCUBATOR = new IncubatorBlock();
    public static final DNAExtractorBlock DNA_EXTRACTOR = new DNAExtractorBlock();
    public static final DNACombinatorHybridizerBlock DNA_COMBINATOR_HYBRIDIZER = new DNACombinatorHybridizerBlock();
    public static final AmberBlock AMBER_ORE = new AmberBlock();
    public static final IceShardBlock ICE_SHARD = new IceShardBlock();
    public static final GypsumStoneBlock GYPSUM_STONE = new GypsumStoneBlock();
    public static final Block GYPSUM_COBBLESTONE = new BasicBlock(Material.field_151576_e).func_149711_c(1.5f);
    public static final Block GYPSUM_BRICKS = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_STONE = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_BRICKS = new BasicBlock(Material.field_151576_e).func_149711_c(3.0f);
    public static final CultivatorTopBlock CULTIVATOR_TOP = new CultivatorTopBlock();
    public static final CultivatorBottomBlock CULTIVATOR_BOTTOM = new CultivatorBottomBlock();
    public static final DisplayBlock DISPLAY_BLOCK = new DisplayBlock();
    public static final ClearGlassBlock CLEAR_GLASS = new ClearGlassBlock();
    public static final ClearGlassPaneBlock CLEAR_GLASS_PANE = new ClearGlassPaneBlock();
    public static final ReinforcedGlassBlock REINFORCED_GLASS = new ReinforcedGlassBlock();
    public static final ReinforcedGlassPaneBlock REINFORCED_GLASS_PANE = new ReinforcedGlassPaneBlock();
    public static final FossilizedTrackwayBlock FOSSILIZED_TRACKWAY = new FossilizedTrackwayBlock();
    public static final NestFossilBlock NEST_FOSSIL = new NestFossilBlock(false);
    public static final NestFossilBlock ENCASED_NEST_FOSSIL = new NestFossilBlock(true);
    public static final SmallRoyalFernBlock SMALL_ROYAL_FERN = new SmallRoyalFernBlock();
    public static final SmallChainFernBlock SMALL_CHAIN_FERN = new SmallChainFernBlock();
    public static final SmallCycadBlock SMALL_CYCAD = new SmallCycadBlock();
    public static final BennettitaleanCycadeoideaBlock CYCADEOIDEA = new BennettitaleanCycadeoideaBlock();
    public static final AncientPlantBlock CRY_PANSY = new AncientPlantBlock();
    public static final ScalyTreeFernBlock SCALY_TREE_FERN = new ScalyTreeFernBlock();
    public static final CycadZamitesBlock ZAMITES = new CycadZamitesBlock();
    public static final DicksoniaBlock DICKSONIA = new DicksoniaBlock();
    public static final DicroidiumZuberiBlock DICROIDIUM_ZUBERI = new DicroidiumZuberiBlock();
    public static final AjuginuculaSmithiiBlock AJUGINUCULA_SMITHII = new AjuginuculaSmithiiBlock();
    public static final WildOnionBlock WILD_ONION = new WildOnionBlock();
    public static final DictyophyllumBlock DICTYOPHYLLUM = new DictyophyllumBlock();
    public static final WestIndianLilacBlock WEST_INDIAN_LILAC = new WestIndianLilacBlock();
    public static final SerennaVeriformansBlock SERENNA_VERIFORMANS = new SerennaVeriformansBlock();
    public static final SmallPlantBlock LADINIA_SIMPLEX = new SmallPlantBlock();
    public static final OrontiumMackiiBlock ORONTIUM_MACKII = new OrontiumMackiiBlock();
    public static final UmaltolepisBlock UMALTOLEPIS = new UmaltolepisBlock();
    public static final LiriodendritesBlock LIRIODENDRITES = new LiriodendritesBlock();
    public static final RaphaeliaBlock RAPHAELIA = new RaphaeliaBlock();
    public static final EncephalartosBlock ENCEPHALARTOS = new EncephalartosBlock();
    public static final WildPotatoBlock WILD_POTATO_PLANT = new WildPotatoBlock();
    public static final RhamnusSalifocifusBlock RHAMNUS_SALICIFOLIUS_PLANT = new RhamnusSalifocifusBlock();
    public static final SmallPlantBlock CINNAMON_FERN = new SmallPlantBlock();
    public static final SmallPlantBlock BRISTLE_FERN = new SmallPlantBlock();
    public static final DoublePlantBlock TEMPSKYA = new DoublePlantBlock();
    public static final SmallPlantBlock WOOLLY_STALKED_BEGONIA = new SmallPlantBlock();
    public static final SmallPlantBlock LARGESTIPULE_LEATHER_ROOT = new SmallPlantBlock();
    public static final DoublePlantBlock RHACOPHYTON = new DoublePlantBlock();
    public static final DoublePlantBlock GRAMINIDITES_BAMBUSOIDES = new DoublePlantBlock();
    public static final DoublePlantBlock HELICONIA = new DoublePlantBlock();
    public static final EnallheliaBlock ENALLHELIA = new EnallheliaBlock();
    public static final AuloporaBlock AULOPORA = new AuloporaBlock();
    public static final CladochonusBlock CLADOCHONUS = new CladochonusBlock();
    public static final LithostrotionBlock LITHOSTROTION = new LithostrotionBlock();
    public static final StylopyllopsisBlock STYLOPHYLLOPSIS = new StylopyllopsisBlock();
    public static final HippuritesRadiosusBlock HIPPURITES_RADIOSUS = new HippuritesRadiosusBlock();
    public static final GracilariaBlock GRACILARIA = new GracilariaBlock();
    public static final PeatBlock PEAT = new PeatBlock();
    public static final Block PEAT_MOSS = new PeatMossBlock();
    public static final MossBlock MOSS = new MossBlock();
    public static final FeederBlock FEEDER = new FeederBlock();
    public static final SkullDisplay SKULL_DISPLAY = new SkullDisplay();
    public static final BugCrateBlock BUG_CRATE = new BugCrateBlock();
    public static final SwarmBlock PLANKTON_SWARM = new SwarmBlock(() -> ItemHandler.PLANKTON);
    public static final SwarmBlock KRILL_SWARM = new SwarmBlock(() -> ItemHandler.KRILL);
    public static final TourRailBlock TOUR_RAIL = new TourRailBlock(TourRailBlock.SpeedType.NONE);
    public static final TourRailBlock TOUR_RAIL_SLOW = new TourRailBlock(TourRailBlock.SpeedType.SLOW);
    public static final TourRailBlock TOUR_RAIL_MEDIUM = new TourRailBlock(TourRailBlock.SpeedType.MEDIUM);
    public static final TourRailBlock TOUR_RAIL_FAST = new TourRailBlock(TourRailBlock.SpeedType.FAST);
    public static final SkeletonAssemblyBlock SKELETON_ASSEMBLY = new SkeletonAssemblyBlock();
    public static final ElectricFencePoleBlock LOW_SECURITY_FENCE_POLE = new ElectricFencePoleBlock(FenceType.LOW);
    public static final ElectricFencePoleBlock MED_SECURITY_FENCE_POLE = new ElectricFencePoleBlock(FenceType.MED);
    public static final ElectricFencePoleBlock HIGH_SECURITY_FENCE_POLE = new ElectricFencePoleBlock(FenceType.HIGH);
    public static final ElectricFenceBaseBlock LOW_SECURITY_FENCE_BASE = new ElectricFenceBaseBlock(FenceType.LOW);
    public static final ElectricFenceBaseBlock MED_SECURITY_FENCE_BASE = new ElectricFenceBaseBlock(FenceType.MED);
    public static final ElectricFenceBaseBlock HIGH_SECURITY_FENCE_BASE = new ElectricFenceBaseBlock(FenceType.HIGH);
    public static final ElectricFenceWireBlock LOW_SECURITY_FENCE_WIRE = new ElectricFenceWireBlock(FenceType.LOW);
    public static final ElectricFenceWireBlock MED_SECURITY_FENCE_WIRE = new ElectricFenceWireBlock(FenceType.MED);
    public static final ElectricFenceWireBlock HIGH_SECURITY_FENCE_WIRE = new ElectricFenceWireBlock(FenceType.HIGH);
    public static final PaleoBaleBlock PALEO_BALE_CYCADEOIDEA = new PaleoBaleBlock(PaleoBaleBlock.Variant.CYCADEOIDEA);
    public static final PaleoBaleBlock PALEO_BALE_CYCAD = new PaleoBaleBlock(PaleoBaleBlock.Variant.CYCAD);
    public static final PaleoBaleBlock PALEO_BALE_FERN = new PaleoBaleBlock(PaleoBaleBlock.Variant.FERN);
    public static final PaleoBaleBlock PALEO_BALE_LEAVES = new PaleoBaleBlock(PaleoBaleBlock.Variant.LEAVES);
    public static final PaleoBaleBlock PALEO_BALE_OTHER = new PaleoBaleBlock(PaleoBaleBlock.Variant.OTHER);
    public static final AncientItemHoldingBlock ANCIENT_ITEM_HOLDING_BLOCK = new AncientItemHoldingBlock();

    public static void init() {
        BlockHandler.registerBlock(PLANT_FOSSIL, "Plant Fossil Block");
        BlockHandler.registerBlock(FOSSILIZED_TRACKWAY, "Fossilized Trackway");
        BlockHandler.registerBlock(NEST_FOSSIL, "Nest Fossil");
        BlockHandler.registerBlock(ENCASED_NEST_FOSSIL, "Encased Nest Fossil");
        for (int i = 0; i < (int)Math.ceil((float)EntityHandler.getHighestDinosaurID() / 16.0f); ++i) {
            FossilBlock fossil = new FossilBlock(i * 16);
            EncasedFossilBlock encasedFossil = new EncasedFossilBlock(i * 16);
            FOSSILS.add(fossil);
            ENCASED_FOSSILS.add(encasedFossil);
            BlockHandler.registerBlock(fossil, "Fossil Block " + i);
            BlockHandler.registerBlock(encasedFossil, "Encased Fossil " + i);
        }
        for (TreeType type : TreeType.values()) {
            BlockHandler.registerTreeType(type);
        }
        BlockHandler.registerBlock(AMBER_ORE, "Amber Ore");
        BlockHandler.registerBlock(ICE_SHARD, "Ice Shard");
        BlockHandler.registerBlock(GYPSUM_STONE, "Gypsum Stone");
        BlockHandler.registerBlock(GYPSUM_COBBLESTONE, "Gypsum Cobblestone");
        BlockHandler.registerBlock(GYPSUM_BRICKS, "Gypsum Bricks");
        BlockHandler.registerBlock(REINFORCED_STONE, "Reinforced Stone");
        BlockHandler.registerBlock(REINFORCED_BRICKS, "Reinforced Bricks");
        BlockHandler.registerBlock((Block)AJUGINUCULA_SMITHII, "Ajuginucula Smithii");
        BlockHandler.registerBlock((Block)SMALL_ROYAL_FERN, "Small Royal Fern");
        BlockHandler.registerBlock((Block)SMALL_CHAIN_FERN, "Small Chain Fern");
        BlockHandler.registerBlock((Block)SMALL_CYCAD, "Small Cycad");
        BlockHandler.registerBlock((Block)CYCADEOIDEA, "Bennettitalean Cycadeoidea");
        BlockHandler.registerBlock((Block)CRY_PANSY, "Cry Pansy");
        BlockHandler.registerBlock((Block)SCALY_TREE_FERN, "Scaly Tree Fern");
        BlockHandler.registerBlock((Block)ZAMITES, "Cycad Zamites");
        BlockHandler.registerBlock((Block)DICKSONIA, "Dicksonia");
        BlockHandler.registerBlock((Block)WILD_ONION, "Wild Onion Plant");
        BlockHandler.registerBlock((Block)DICROIDIUM_ZUBERI, "Dicroidium Zuberi");
        BlockHandler.registerBlock((Block)DICTYOPHYLLUM, "Dictyophyllum");
        BlockHandler.registerBlock((Block)WEST_INDIAN_LILAC, "West Indian Lilac");
        BlockHandler.registerBlock((Block)SERENNA_VERIFORMANS, "Serenna Veriformans");
        BlockHandler.registerBlock((Block)LADINIA_SIMPLEX, "Ladinia Simplex");
        BlockHandler.registerBlock((Block)ORONTIUM_MACKII, "Orontium Mackii");
        BlockHandler.registerBlock((Block)UMALTOLEPIS, "Umaltolepis");
        BlockHandler.registerBlock((Block)LIRIODENDRITES, "Liriodendrites");
        BlockHandler.registerBlock((Block)RAPHAELIA, "Raphaelia");
        BlockHandler.registerBlock((Block)ENCEPHALARTOS, "Encephalartos");
        BlockHandler.registerBlock((Block)WILD_POTATO_PLANT, "Wild Potato Plant");
        BlockHandler.registerBlock((Block)RHAMNUS_SALICIFOLIUS_PLANT, "Rhamnus Salicifolius");
        BlockHandler.registerBlock((Block)BRISTLE_FERN, "Bristle Fern");
        BlockHandler.registerBlock((Block)CINNAMON_FERN, "Cinnamon Fern");
        BlockHandler.registerBlock((Block)TEMPSKYA, "Tempskya");
        BlockHandler.registerBlock((Block)WOOLLY_STALKED_BEGONIA, "Woolly Stalked Begonia");
        BlockHandler.registerBlock((Block)LARGESTIPULE_LEATHER_ROOT, "Largestipule Leather Root");
        BlockHandler.registerBlock((Block)RHACOPHYTON, "Rhacophyton");
        BlockHandler.registerBlock((Block)GRAMINIDITES_BAMBUSOIDES, "Graminidites Bambusoides");
        BlockHandler.registerBlock((Block)ENALLHELIA, "Enallhelia");
        BlockHandler.registerBlock((Block)AULOPORA, "Aulopora");
        BlockHandler.registerBlock((Block)GRACILARIA, "Gracilaria Seaweed");
        BlockHandler.registerBlock((Block)CLADOCHONUS, "Cladochonus");
        BlockHandler.registerBlock((Block)LITHOSTROTION, "Lithostrotion");
        BlockHandler.registerBlock((Block)STYLOPHYLLOPSIS, "Stylophyllopsis");
        BlockHandler.registerBlock((Block)HIPPURITES_RADIOSUS, "Hippurites Radiosus");
        BlockHandler.registerBlock((Block)HELICONIA, "Heliconia");
        BlockHandler.registerBlock(MOSS, "Moss");
        BlockHandler.registerBlock(PEAT, "Peat");
        BlockHandler.registerBlock(PEAT_MOSS, "Peat Moss");
        BlockHandler.registerBlock((Block)CLEAR_GLASS, "Clear Glass");
        BlockHandler.registerBlock(CLEAR_GLASS_PANE, "Clear Glass Pane");
        BlockHandler.registerBlock((Block)REINFORCED_GLASS, "Reinforced Glass");
        BlockHandler.registerBlock(REINFORCED_GLASS_PANE, "Reinforced Glass Pane");
        BlockHandler.registerBlock(PLANKTON_SWARM, "Plankton Swarm");
        BlockHandler.registerBlock(KRILL_SWARM, "Krill Swarm");
        if (JurassiCraftConfig.VEHICLES.tourRailBlockEnabled) {
            BlockHandler.registerBlock(TourRailBlockEntity.class, TOUR_RAIL, "Tour Rail");
            BlockHandler.registerBlock(TOUR_RAIL_SLOW, "Tour Rail Slow");
            BlockHandler.registerBlock(TOUR_RAIL_MEDIUM, "Tour Rail Medium");
            BlockHandler.registerBlock(TOUR_RAIL_FAST, "Tour Rail Fast");
        }
        BlockHandler.registerBlock(SKELETON_ASSEMBLY, "Skeleton Assembly");
        BlockHandler.registerBlock(CultivatorBlockEntity.class, (Block)CULTIVATOR_BOTTOM, "Cultivate Bottom");
        BlockHandler.registerBlock((Block)CULTIVATOR_TOP, "Cultivate Top");
        BlockHandler.registerBlock(CleaningStationBlockEntity.class, (Block)CLEANING_STATION, "Cleaning Station");
        BlockHandler.registerBlock(FossilGrinderBlockEntity.class, (Block)FOSSIL_GRINDER, "Fossil Grinder");
        BlockHandler.registerBlock(DNASequencerBlockEntity.class, (Block)DNA_SEQUENCER, "DNA Sequencer");
        BlockHandler.registerBlock(DNASynthesizerBlockEntity.class, (Block)DNA_SYNTHESIZER, "DNA Synthesizer");
        BlockHandler.registerBlock(EmbryonicMachineBlockEntity.class, (Block)EMBRYONIC_MACHINE, "Embryonic Machine");
        BlockHandler.registerBlock(EmbryoCalcificationMachineBlockEntity.class, (Block)EMBRYO_CALCIFICATION_MACHINE, "Embryo Calcification Machine");
        BlockHandler.registerBlock(DNAExtractorBlockEntity.class, (Block)DNA_EXTRACTOR, "DNA Extractor");
        BlockHandler.registerBlock(DNACombinatorHybridizerBlockEntity.class, (Block)DNA_COMBINATOR_HYBRIDIZER, "DNA Combinator Hybridizer");
        BlockHandler.registerBlock(IncubatorBlockEntity.class, (Block)INCUBATOR, "Incubator");
        BlockHandler.registerBlock(DisplayBlockEntity.class, (Block)DISPLAY_BLOCK, "Display Block");
        BlockHandler.registerBlock(SkullDisplayEntity.class, (Block)SKULL_DISPLAY, "Skull Display Block");
        BlockHandler.registerBlock(FeederBlockEntity.class, (Block)FEEDER, "Feeder");
        BlockHandler.registerBlock(BugCrateBlockEntity.class, (Block)BUG_CRATE, "Bug Crate");
        BlockHandler.registerBlock(ElectricFenceWireBlockEntity.class, "tileEntityElectricFence", (Block)LOW_SECURITY_FENCE_WIRE, "Low Security Fence Wire");
        BlockHandler.registerBlock(ElectricFencePoleBlockEntity.class, "tileEntityElectricPole", (Block)LOW_SECURITY_FENCE_POLE, "Low Security Fence Pole");
        BlockHandler.registerBlock(ElectricFenceBaseBlockEntity.class, "tileEntityElectricBase", (Block)LOW_SECURITY_FENCE_BASE, "Low Security Fence Base");
        BlockHandler.registerBlock((Block)PALEO_BALE_OTHER, "Paleo Bale Other");
        BlockHandler.registerBlock((Block)PALEO_BALE_CYCADEOIDEA, "Paleo Bale Cycadeoidea");
        BlockHandler.registerBlock((Block)PALEO_BALE_CYCAD, "Paleo Bale Cycad");
        BlockHandler.registerBlock((Block)PALEO_BALE_FERN, "Paleo Bale Fern");
        BlockHandler.registerBlock((Block)PALEO_BALE_LEAVES, "Paleo Bale Leaves");
        BlockHandler.registerBlock(AncientItemHoldingBlockEntity.class, ANCIENT_ITEM_HOLDING_BLOCK, "Ancient Item Holding Block");
    }

    public static void registerTreeType(TreeType type) {
        AncientPlanksBlock planks = new AncientPlanksBlock(type);
        AncientLogBlock log = new AncientLogBlock(type, false);
        AncientLogBlock petrifiedLog = new AncientLogBlock(type, true);
        AncientLeavesBlock leaves = new AncientLeavesBlock(type);
        AncientSaplingBlock sapling = new AncientSaplingBlock(type);
        AncientStairsBlock stair = new AncientStairsBlock(type, planks.func_176223_P());
        AncientSlabHalfBlock slab = new AncientSlabHalfBlock(type, planks.func_176223_P());
        AncientDoubleSlabBlock doubleSlab = new AncientDoubleSlabBlock(type, (Block)slab, planks.func_176223_P());
        AncientFenceBlock fence = new AncientFenceBlock(type);
        AncientFenceGateBlock fenceGate = new AncientFenceGateBlock(type);
        AncientDoorBlock door = new AncientDoorBlock(type);
        ANCIENT_PLANKS.put(type, planks);
        ANCIENT_LOGS.put(type, log);
        ANCIENT_LEAVES.put(type, leaves);
        ANCIENT_SAPLINGS.put(type, sapling);
        ANCIENT_STAIRS.put(type, stair);
        ANCIENT_SLABS.put(type, slab);
        ANCIENT_DOUBLE_SLABS.put(type, doubleSlab);
        ANCIENT_FENCES.put(type, fence);
        ANCIENT_FENCE_GATES.put(type, fenceGate);
        ANCIENT_DOORS.put(type, door);
        PETRIFIED_LOGS.put(type, petrifiedLog);
        String typeName = type.name();
        BlockHandler.registerBlock(planks, typeName + " Planks");
        BlockHandler.registerBlock((Block)log, typeName + " Log");
        BlockHandler.registerBlock((Block)petrifiedLog, typeName + " Log Petrified");
        BlockHandler.registerBlock((Block)leaves, typeName + " Leaves");
        BlockHandler.registerBlock((Block)sapling, typeName + " Sapling");
        BlockHandler.registerBlock((Block)stair, typeName + " Stairs");
        BlockHandler.registerBlock((Block)slab, typeName + " Slab");
        BlockHandler.registerBlock((Block)doubleSlab, typeName + " Double Slab");
        BlockHandler.registerBlock((Block)fence, typeName + " Fence");
        BlockHandler.registerBlock((Block)fenceGate, typeName + " Fence Gate");
        BlockHandler.registerBlock((Block)door, typeName + " Door");
        Blocks.field_150480_ab.func_180686_a((Block)leaves, 30, 60);
        Blocks.field_150480_ab.func_180686_a((Block)planks, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)log, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)petrifiedLog, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)doubleSlab, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)slab, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)stair, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)fence, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)fenceGate, 5, 20);
    }

    public static void registerOres() {
        for (int i = 0; i < TreeType.values().length; ++i) {
            OreDictionary.registerOre((String)"logWood", (Block)((Block)ANCIENT_LOGS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"logWood", (Block)((Block)PETRIFIED_LOGS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"plankWood", (Block)ANCIENT_PLANKS.get((Object)TreeType.values()[i]));
            OreDictionary.registerOre((String)"treeLeaves", (Block)((Block)ANCIENT_LEAVES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"treeSapling", (Block)((Block)ANCIENT_SAPLINGS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"slabWood", (Block)((Block)ANCIENT_SLABS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"stairWood", (Block)((Block)ANCIENT_STAIRS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"fenceWood", (Block)((Block)ANCIENT_FENCES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"gateWood", (Block)((Block)ANCIENT_FENCE_GATES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"fenceGateWood", (Block)((Block)ANCIENT_FENCE_GATES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"doorWood", (Block)((Block)ANCIENT_DOORS.get((Object)TreeType.values()[i])));
        }
        for (FossilBlock fossil : FOSSILS) {
            OreDictionary.registerOre((String)"fossil", (Block)fossil);
        }
    }

    public static FossilBlock getFossilBlock(Dinosaur dinosaur) {
        return BlockHandler.getFossilBlock(EntityHandler.getDinosaurId(dinosaur));
    }

    private static int getBlockId(int id) {
        return (int)Math.floor(((float)id + 1.0f) / 16.0f - 0.0625f);
    }

    public static EncasedFossilBlock getEncasedFossil(Dinosaur dinosaur) {
        return BlockHandler.getEncasedFossil(EntityHandler.getDinosaurId(dinosaur));
    }

    public static EncasedFossilBlock getEncasedFossil(int id) {
        return ENCASED_FOSSILS.get(BlockHandler.getBlockId(id));
    }

    public static FossilBlock getFossilBlock(int id) {
        return FOSSILS.get(BlockHandler.getBlockId(id));
    }

    public static int getDinosaurId(FossilBlock fossil, int metadata) {
        return FOSSILS.indexOf(fossil) * 16 + metadata;
    }

    public static int getDinosaurId(EncasedFossilBlock fossil, int metadata) {
        return ENCASED_FOSSILS.indexOf(fossil) * 16 + metadata;
    }

    public static int getMetadata(int id) {
        return id % 16;
    }

    public static int getMetadata(Dinosaur dinosaur) {
        return BlockHandler.getMetadata(EntityHandler.getDinosaurId(dinosaur));
    }

    public static void registerBlock(Class<? extends TileEntity> tileEntity, Block block, String name) {
        BlockHandler.registerBlock(tileEntity, name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"), block, name);
    }

    public static void registerBlock(Class<? extends TileEntity> tileEntity, String tileEntityName, Block block, String name) {
        BlockHandler.registerBlock(block, name);
        GameRegistry.registerTileEntity(tileEntity, (ResourceLocation)new ResourceLocation("jurassicraft", tileEntityName));
    }

    public static void registerBlock(Block block, String name) {
        if (block instanceof SubBlocksBlock) {
            RegistryHandler.registerBlockWithCustomItem(block, ((SubBlocksBlock)block).getItemBlock(), name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"));
        } else {
            RegistryHandler.registerBlockWithItem(block, name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"));
        }
    }
}

