/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity.dinosaur;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.model.AnimatableModel;
import org.jurassicraft.client.model.animation.EntityAnimator;
import org.jurassicraft.client.render.entity.DinosaurRenderer;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.AnimalMetadata;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.tabula.TabulaModelHelper;

@SideOnly(value=Side.CLIENT)
public class DinosaurRenderInfo
implements IRenderFactory<DinosaurEntity> {
    private static TabulaModel DEFAULT_EGG_MODEL;
    private static ResourceLocation DEFAULT_EGG_TEXTURE;
    private final Map<GrowthStage, AnimatableModel> animatableModels = new EnumMap<GrowthStage, AnimatableModel>(GrowthStage.class);
    private final Dinosaur dinosaur;
    private final EntityAnimator<?> animator;
    private TabulaModel eggModel;
    private ResourceLocation eggTexture;
    private float shadowSize = 0.65f;
    private AnimatableModel[] skeletonModels = new AnimatableModel[16];

    public DinosaurRenderInfo(Dinosaur dinosaur, EntityAnimator<?> animator, float shadowSize) {
        this.dinosaur = dinosaur;
        this.animator = animator;
        this.shadowSize = shadowSize;
        for (GrowthStage stage : GrowthStage.values()) {
            if (stage != GrowthStage.SKELETON) {
                this.animatableModels.put(stage, new AnimatableModel(this.dinosaur.getModelContainer(stage), (AnimalMetadata)this.getDinosaur().getMetadata(), this.getModelAnimator(stage)));
                continue;
            }
            for (int i = 0; i < dinosaur.getMetadata().skeletonPoses().length; ++i) {
                this.skeletonModels[i] = new AnimatableModel(this.dinosaur.getSkeletonModel().get(dinosaur.getMetadata().skeletonPoses()[i]), (AnimalMetadata)this.getDinosaur().getMetadata(), null);
            }
        }
        try {
            ResourceLocation identifier = dinosaur.getIdentifier();
            String domain = identifier.func_110624_b();
            String path = identifier.func_110623_a();
            this.eggModel = new TabulaModel(TabulaModelHelper.loadTabulaModel(new ResourceLocation(domain, "models/entities/egg/" + path)));
            this.eggTexture = new ResourceLocation(domain, "textures/entities/egg/" + path + ".png");
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            this.eggModel = DEFAULT_EGG_MODEL;
            this.eggTexture = DEFAULT_EGG_TEXTURE;
        }
    }

    public ModelBase getModel(GrowthStage stage, byte variant) {
        if (!this.dinosaur.doesSupportGrowthStage(stage)) {
            return this.getModelAdult();
        }
        if (stage == GrowthStage.SKELETON) {
            return this.skeletonModels[variant];
        }
        return (ModelBase)this.animatableModels.get((Object)stage);
    }

    public ModelBase getEggModel() {
        return this.eggModel;
    }

    public ResourceLocation getEggTexture() {
        return this.eggTexture;
    }

    public EntityAnimator<?> getModelAnimator(GrowthStage stage) {
        return this.animator;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public Render<? super DinosaurEntity> createRenderFor(RenderManager manager) {
        return new DinosaurRenderer(this, manager);
    }

    public AnimatableModel getModelAdult() {
        return this.animatableModels.get((Object)GrowthStage.ADULT);
    }

    static {
        try {
            DEFAULT_EGG_MODEL = new TabulaModel(TabulaModelHelper.loadTabulaModel(new ResourceLocation("jurassicraft", "models/entities/egg/tyrannosaurus")));
            DEFAULT_EGG_TEXTURE = new ResourceLocation("jurassicraft", "textures/entities/egg/tyrannosaurus.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

