/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.entity.vehicle.VehicleEntity;
import org.jurassicraft.server.entity.vehicle.util.WheelParticleData;

@Mod.EventBusSubscriber(modid="jurassicraft", value={Side.CLIENT})
public class TyretrackRenderer {
    public static final List<Material> ALLOWED_MATERIALS = Lists.newArrayList((Object[])new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p});
    public static final ResourceLocation TYRE_TRACKS_LOCATION = new ResourceLocation("jurassicraft", "textures/misc/tyre-tracks.png");
    private static final List<List<WheelParticleData>> DEAD_CARS_LISTS = Lists.newArrayList();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = ClientProxy.MC;
        WorldClient world = mc.field_71441_e;
        EntityPlayerSP player = mc.field_71439_g;
        Vec3d playerPos = player.func_174791_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        mc.func_110434_K().func_110577_a(TYRE_TRACKS_LOCATION);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        buffer.func_178969_c(-d0, -d1, -d2);
        ArrayList runList = Lists.newArrayList();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (Entity entity : Lists.reverse((List)Lists.newArrayList((Iterable)world.field_72996_f))) {
            if (!(entity instanceof VehicleEntity)) continue;
            VehicleEntity car = (VehicleEntity)entity;
            for (List<WheelParticleData> list2 : car.wheelDataList) {
                TyretrackRenderer.renderList(list2, buffer, event.getPartialTicks(), runList);
            }
        }
        DEAD_CARS_LISTS.forEach(list -> TyretrackRenderer.renderList(list, buffer, event.getPartialTicks(), runList));
        runList.sort((o1, o2) -> Comparator.naturalOrder().compare(o2.getLeft(), o1.getLeft()));
        GlStateManager.func_179094_E();
        runList.forEach(pair -> ((Runnable)pair.getRight()).run());
        GlStateManager.func_179121_F();
        tess.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderList(List<WheelParticleData> dataList, BufferBuilder buffer, float partialTicks, List<Pair<Long, Runnable>> list) {
        WorldClient world = ClientProxy.MC.field_71441_e;
        for (int i = 0; i < dataList.size() - 1; ++i) {
            WheelParticleData start = dataList.get(i);
            if (!start.shouldRender()) continue;
            WheelParticleData end = dataList.get(i + 1);
            Vec3d sv = start.getPosition();
            Vec3d ev = end.getPosition();
            Vec3d startOpposite = start.getOppositePosition();
            Vec3d endOpposite = end.getOppositePosition();
            BlockPos position = new BlockPos(sv);
            BlockPos endPosition = new BlockPos(ev);
            if (sv.field_72448_b != ev.field_72448_b || !TyretrackRenderer.isStateAccepted((World)world, position) || !TyretrackRenderer.isStateAccepted((World)world, endPosition)) continue;
            int n = i;
            list.add((Pair<Long, Runnable>)Pair.of((Object)start.getWorldTime(), () -> TyretrackRenderer.lambda$renderList$3(sv, startOpposite, ev, endOpposite, (World)world, position, endPosition, start, partialTicks, end, n, buffer)));
        }
    }

    private static boolean isStateAccepted(World world, BlockPos position) {
        BlockPos downPos = position.func_177977_b();
        IBlockState downState = world.func_180495_p(downPos);
        return !world.func_180495_p(position).func_185904_a().func_76224_d() && downState.isSideSolid((IBlockAccess)world, downPos, EnumFacing.UP) && ALLOWED_MATERIALS.contains(downState.func_185904_a());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onWorldTick(TickEvent.ClientTickEvent event) {
        ArrayList emptyLists = Lists.newArrayList();
        DEAD_CARS_LISTS.forEach(list -> {
            ArrayList markedRemoved = Lists.newArrayList();
            list.forEach(wheel -> wheel.onUpdate(markedRemoved));
            markedRemoved.forEach(list::remove);
            markedRemoved.clear();
            if (list.isEmpty()) {
                emptyLists.add(list);
            }
        });
        emptyLists.forEach(DEAD_CARS_LISTS::remove);
    }

    public static void uploadList(VehicleEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            for (List<WheelParticleData> list : entity.wheelDataList) {
                DEAD_CARS_LISTS.add(0, list);
            }
        }
    }

    private static /* synthetic */ void lambda$renderList$3(Vec3d sv, Vec3d startOpposite, Vec3d ev, Vec3d endOpposite, World world, BlockPos position, BlockPos endPosition, WheelParticleData start, float partialTicks, WheelParticleData end, int n, BufferBuilder buffer) {
        double d = 1.0 / Math.sqrt(Math.pow(sv.field_72450_a - startOpposite.field_72450_a, 2.0) + Math.pow(sv.field_72449_c - startOpposite.field_72449_c, 2.0)) / 2.0;
        Vec3d vec = new Vec3d((sv.field_72450_a - startOpposite.field_72450_a) * d, 0.0, (sv.field_72449_c - startOpposite.field_72449_c) * d);
        double d1 = 1.0 / Math.sqrt(Math.pow(ev.field_72450_a - endOpposite.field_72450_a, 2.0) + Math.pow(ev.field_72449_c - endOpposite.field_72449_c, 2.0)) / 2.0;
        Vec3d vec1 = new Vec3d((ev.field_72450_a - endOpposite.field_72450_a) * d, 0.0, (ev.field_72449_c - endOpposite.field_72449_c) * d);
        float sl = world.func_175724_o(position);
        float el = world.func_175724_o(endPosition);
        float sa = start.getAlpha(partialTicks);
        float ea = end.getAlpha(partialTicks);
        double offset = (double)(n + 2) * 1.0E-4;
        buffer.func_181662_b(sv.field_72450_a + vec.field_72450_a / 2.0, sv.field_72448_b + offset, sv.field_72449_c + vec.field_72449_c / 2.0).func_187315_a(0.0, 0.0).func_181666_a(sl, sl, sl, sa).func_181675_d();
        buffer.func_181662_b(sv.field_72450_a - vec.field_72450_a / 2.0, sv.field_72448_b + offset, sv.field_72449_c - vec.field_72449_c / 2.0).func_187315_a(0.0, 1.0).func_181666_a(sl, sl, sl, sa).func_181675_d();
        buffer.func_181662_b(ev.field_72450_a - vec1.field_72450_a / 2.0, ev.field_72448_b + offset, ev.field_72449_c - vec1.field_72449_c / 2.0).func_187315_a(1.0, 1.0).func_181666_a(el, el, el, ea).func_181675_d();
        buffer.func_181662_b(ev.field_72450_a + vec1.field_72450_a / 2.0, ev.field_72448_b + offset, ev.field_72449_c + vec1.field_72449_c / 2.0).func_187315_a(1.0, 0.0).func_181666_a(el, el, el, ea).func_181675_d();
        buffer.func_181662_b(sv.field_72450_a + vec.field_72450_a / 2.0, sv.field_72448_b + offset, sv.field_72449_c + vec.field_72449_c / 2.0).func_187315_a(0.0, 0.0).func_181666_a(sl, sl, sl, sa).func_181675_d();
        buffer.func_181662_b(ev.field_72450_a + vec1.field_72450_a / 2.0, ev.field_72448_b + offset, ev.field_72449_c + vec1.field_72449_c / 2.0).func_187315_a(1.0, 0.0).func_181666_a(el, el, el, ea).func_181675_d();
        buffer.func_181662_b(ev.field_72450_a - vec1.field_72450_a / 2.0, ev.field_72448_b + offset, ev.field_72449_c - vec1.field_72449_c / 2.0).func_187315_a(1.0, 1.0).func_181666_a(el, el, el, ea).func_181675_d();
        buffer.func_181662_b(sv.field_72450_a - vec.field_72450_a / 2.0, sv.field_72448_b + offset, sv.field_72449_c - vec.field_72449_c / 2.0).func_187315_a(0.0, 1.0).func_181666_a(sl, sl, sl, sa).func_181675_d();
    }
}

