/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class ThirdPersonViewRenderer {
    private static ThirdPersonViewRenderer INSTANCE;
    private Minecraft mc = Minecraft.func_71410_x();
    private final float maxThirdPersonDistance = 20.0f;
    private final float minThirdPersonDistance = 4.0f;
    private float thirdPersonDistance = 4.0f;

    public void transformThirdPersonViewRender(double renderPartialTicks) {
        if (this.mc.field_71474_y.field_74320_O > 0) {
            Entity entity = this.mc.func_175606_aa();
            float yaw = entity.field_70177_z;
            float pitch = entity.field_70125_A;
            GlStateManager.func_179114_b((float)(entity.field_70125_A - pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(entity.field_70177_z - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)this.getDist(entity, 4.0, renderPartialTicks));
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-this.getDist(entity, this.thirdPersonDistance, renderPartialTicks)));
            GlStateManager.func_179114_b((float)(yaw - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(pitch - entity.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private double getDist(Entity entity, double max, double partialTicks) {
        float yaw = entity.field_70177_z * ((float)Math.PI / 180);
        float pitch = entity.field_70125_A * ((float)Math.PI / 180);
        double ex = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks;
        double ey = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * partialTicks + (double)entity.func_70047_e();
        double ez = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks;
        if (this.mc.field_71474_y.field_74320_O == 2) {
            pitch += 180.0f;
        }
        double cx = (double)(-MathHelper.func_76126_a((float)yaw) * MathHelper.func_76134_b((float)pitch)) * max;
        double cy = (double)(MathHelper.func_76134_b((float)yaw) * MathHelper.func_76134_b((float)pitch)) * max;
        double cz = (double)(-MathHelper.func_76126_a((float)pitch)) * max;
        for (int i = 0; i < 8; ++i) {
            double dist;
            float mx = (float)((i & 1) * 2 - 1) / 10.0f;
            float my = (float)((i >> 1 & 1) * 2 - 1) / 10.0f;
            float mz = (float)((i >> 2 & 1) * 2 - 1) / 10.0f;
            RayTraceResult r = this.mc.field_71441_e.func_72933_a(new Vec3d(ex + (double)mx, ey + (double)my, ez + (double)mz), new Vec3d(ex - cx + (double)mx + (double)mz, ey - cz + (double)my, ez - cy + (double)mz));
            if (r == null || !((dist = r.field_72307_f.func_72438_d(new Vec3d(ex, ey, ez))) < max)) continue;
            max = dist;
        }
        return max;
    }

    public static ThirdPersonViewRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThirdPersonViewRenderer();
        }
        return INSTANCE;
    }

    public void setThirdPersonViewDistance(float distance) {
        this.thirdPersonDistance = distance < this.minThirdPersonDistance ? this.minThirdPersonDistance : (distance > this.maxThirdPersonDistance ? this.maxThirdPersonDistance : distance);
    }

    public float getThirdPersonViewDistance() {
        return this.thirdPersonDistance;
    }

    public float getMinThirdPersonViewDistance() {
        return this.minThirdPersonDistance;
    }

    public float getMaxThirdPersonViewDistance() {
        return this.maxThirdPersonDistance;
    }

    public float getDefaultThirdPersonDistance() {
        return this.minThirdPersonDistance;
    }
}

