/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.block;

import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.jurassicraft.client.model.ResetControlTabulaModel;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.machine.FeederBlock;
import org.jurassicraft.server.tabula.TabulaModelHelper;

public class FeederRenderer
extends TileEntitySpecialRenderer<FeederBlockEntity> {
    private ResetControlTabulaModel model;
    private ResourceLocation texture;

    public FeederRenderer() {
        try {
            this.model = new ResetControlTabulaModel(TabulaModelHelper.loadTabulaModel(new ResourceLocation("jurassicraft", "models/block/feeder")));
            this.model.setResetEachFrame(false);
            this.texture = new ResourceLocation("jurassicraft", "textures/blocks/feeder.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(FeederBlockEntity tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState blockState = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() == BlockHandler.FEEDER) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FeederBlock.FACING);
            float rotation = facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? -90.0f : 90.0f;
            EnumFacing.Axis axis = facing.func_176740_k();
            if (axis == EnumFacing.Axis.Y) {
                GlStateManager.func_179114_b((float)(rotation - 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (axis == EnumFacing.Axis.X) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (axis == EnumFacing.Axis.Z) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            double scale = 1.0;
            GlStateManager.func_179139_a((double)1.0, (double)-1.0, (double)1.0);
            ClientProxy.MC.func_110434_K().func_110577_a(this.texture);
            float openAnimation = Math.max(0.0f, Math.min(20.0f, (float)tile.openAnimation + LLibrary.PROXY.getPartialTicks() * (float)(tile.openAnimation - tile.prevOpenAnimation)));
            this.model.getCube((String)"Lid 1").field_78795_f = (float)Math.toRadians(openAnimation / 20.0f * 99.13f);
            this.model.getCube((String)"Lid 2").field_78795_f = (float)Math.toRadians(openAnimation / 20.0f * -99.13f);
            this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }
}

