/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModelHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.MultipartStateMap;
import org.jurassicraft.client.model.animation.EntityAnimator;
import org.jurassicraft.client.model.animation.entity.BrachiosaurusAnimator;
import org.jurassicraft.client.model.animation.entity.CoelacanthAnimator;
import org.jurassicraft.client.model.animation.entity.DilophosaurusAnimator;
import org.jurassicraft.client.model.animation.entity.GallimimusAnimator;
import org.jurassicraft.client.model.animation.entity.MicroraptorAnimator;
import org.jurassicraft.client.model.animation.entity.MussaurusAnimator;
import org.jurassicraft.client.model.animation.entity.ParasaurolophusAnimator;
import org.jurassicraft.client.model.animation.entity.TriceratopsAnimator;
import org.jurassicraft.client.model.animation.entity.TyrannosaurusAnimator;
import org.jurassicraft.client.model.animation.entity.VelociraptorAnimator;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.client.render.block.AncientItemHoldingBlockRenderer;
import org.jurassicraft.client.render.block.CleaningStationRenderer;
import org.jurassicraft.client.render.block.DNAExtractorRenderer;
import org.jurassicraft.client.render.block.DNASequencerRenderer;
import org.jurassicraft.client.render.block.DisplayBlockRenderer;
import org.jurassicraft.client.render.block.ElectricFencePoleRenderer;
import org.jurassicraft.client.render.block.FeederRenderer;
import org.jurassicraft.client.render.block.IncubatorRenderer;
import org.jurassicraft.client.render.block.SkullDisplayRenderer;
import org.jurassicraft.client.render.entity.AttractionSignRenderer;
import org.jurassicraft.client.render.entity.DinosaurEggRenderer;
import org.jurassicraft.client.render.entity.FordExplorerRenderer;
import org.jurassicraft.client.render.entity.GoatRenderer;
import org.jurassicraft.client.render.entity.HeliRenderer;
import org.jurassicraft.client.render.entity.JeepWranglerRenderer;
import org.jurassicraft.client.render.entity.MuralRenderer;
import org.jurassicraft.client.render.entity.NullRenderer;
import org.jurassicraft.client.render.entity.OverridenEntityRenderer;
import org.jurassicraft.client.render.entity.PaddockSignRenderer;
import org.jurassicraft.client.render.entity.VenomRenderer;
import org.jurassicraft.client.render.entity.dinosaur.DinosaurRenderInfo;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.EncasedFossilBlock;
import org.jurassicraft.server.block.FossilBlock;
import org.jurassicraft.server.block.FossilizedTrackwayBlock;
import org.jurassicraft.server.block.NestFossilBlock;
import org.jurassicraft.server.block.TourRailBlock;
import org.jurassicraft.server.block.entity.AncientItemHoldingBlockEntity;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DisplayBlockEntity;
import org.jurassicraft.server.block.entity.ElectricFencePoleBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.block.entity.SkullDisplayEntity;
import org.jurassicraft.server.block.plant.AncientCoralBlock;
import org.jurassicraft.server.block.tree.AncientLeavesBlock;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.conf.JurassiCraftConfig;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.GoatEntity;
import org.jurassicraft.server.entity.TranquilizerDartEntity;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.item.AttractionSignEntity;
import org.jurassicraft.server.entity.item.DinosaurEggEntity;
import org.jurassicraft.server.entity.item.MuralEntity;
import org.jurassicraft.server.entity.item.PaddockSignEntity;
import org.jurassicraft.server.entity.vehicle.FordExplorerEntity;
import org.jurassicraft.server.entity.vehicle.JeepWranglerEntity;
import org.jurassicraft.server.entity.vehicle.TransportHelicopterEntity;
import org.jurassicraft.server.item.Dart;
import org.jurassicraft.server.item.DinosaurSpawnEggItem;
import org.jurassicraft.server.item.DisplayBlockItem;
import org.jurassicraft.server.item.FossilItem;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.item.JournalItem;
import org.jurassicraft.server.item.VehicleItem;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="jurassicraft", value={Side.CLIENT})
public enum RenderingHandler {
    INSTANCE;

    private final Minecraft mc = Minecraft.func_71410_x();
    private static Map<Dinosaur, DinosaurRenderInfo> renderInfos;
    public static OverridenEntityRenderer entityRenderer;

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelEvent(ModelRegistryEvent event) {
        void var4_37;
        void var4_35;
        void var4_33;
        void var4_29;
        void var4_27;
        void var4_25;
        String name;
        void var4_23;
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            RenderingHandler.registerItemRenderer(Item.func_150898_a((Block)BlockHandler.CULTIVATOR_BOTTOM), enumDyeColor.func_176765_a(), "cultivate/cultivate_bottom_" + enumDyeColor.func_176610_l().toLowerCase(Locale.ENGLISH));
        }
        for (TreeType treeType : TreeType.values()) {
            ModelLoader.setCustomStateMapper((Block)((Block)BlockHandler.ANCIENT_FENCES.get((Object)treeType)), (IStateMapper)new MultipartStateMap());
            ModelLoader.setCustomStateMapper((Block)((Block)BlockHandler.ANCIENT_FENCE_GATES.get((Object)treeType)), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
            ModelLoader.setCustomStateMapper((Block)((Block)BlockHandler.ANCIENT_DOORS.get((Object)treeType)), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        }
        ModelLoader.setCustomStateMapper((Block)BlockHandler.ENALLHELIA, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.AULOPORA, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.GRACILARIA, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.CLADOCHONUS, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.LITHOSTROTION, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.STYLOPHYLLOPSIS, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.HIPPURITES_RADIOSUS, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AncientCoralBlock.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.LOW_SECURITY_FENCE_BASE, (IStateMapper)new MultipartStateMap());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.LOW_SECURITY_FENCE_POLE, (IStateMapper)new MultipartStateMap());
        ModelLoader.setCustomStateMapper((Block)BlockHandler.LOW_SECURITY_FENCE_WIRE, (IStateMapper)new MultipartStateMap());
        boolean bl = false;
        for (EncasedFossilBlock fossil : BlockHandler.ENCASED_FOSSILS) {
            void var1_4;
            for (int i = 0; i < 16; ++i) {
                RenderingHandler.registerBlockRenderer(fossil, i, "encased_fossil_" + (int)var1_4);
            }
            ++var1_4;
        }
        boolean bl2 = false;
        for (FossilBlock fossil : BlockHandler.FOSSILS) {
            void var1_6;
            for (int i = 0; i < 16; ++i) {
                RenderingHandler.registerBlockRenderer(fossil, i, "fossil_block_" + (int)var1_6);
            }
            ++var1_6;
        }
        RenderingHandler.registerBlockRenderer(BlockHandler.PLANT_FOSSIL, "plant_fossil_block");
        Iterator<Object> iterator = TreeType.values();
        int fossil = ((Iterator<Block>)iterator).length;
        boolean bl3 = false;
        while (var4_23 < fossil) {
            Iterator<Block> iterator2 = iterator[var4_23];
            name = ((Enum)((Object)iterator2)).name().toLowerCase(Locale.ENGLISH);
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_LEAVES.get(iterator2), name + "_leaves");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_SAPLINGS.get(iterator2), name + "_sapling");
            RenderingHandler.registerBlockRenderer(BlockHandler.ANCIENT_PLANKS.get(iterator2), name + "_planks");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_LOGS.get(iterator2), name + "_log");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_STAIRS.get(iterator2), name + "_stairs");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_SLABS.get(iterator2), name + "_slab");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_DOUBLE_SLABS.get(iterator2), name + "_double_slab");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_FENCES.get(iterator2), name + "_fence");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.ANCIENT_FENCE_GATES.get(iterator2), name + "_fence_gate");
            RenderingHandler.registerBlockRenderer((Block)BlockHandler.PETRIFIED_LOGS.get(iterator2), name + "_log_petrified");
            ++var4_23;
        }
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.SCALY_TREE_FERN, "scaly_tree_fern");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.SMALL_ROYAL_FERN, "small_royal_fern");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.SMALL_CHAIN_FERN, "small_chain_fern");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.SMALL_CYCAD, "small_cycad");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CYCADEOIDEA, "bennettitalean_cycadeoidea");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CRY_PANSY, "cry_pansy");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.ZAMITES, "cycad_zamites");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DICKSONIA, "dicksonia");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.WOOLLY_STALKED_BEGONIA, "woolly_stalked_begonia");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LARGESTIPULE_LEATHER_ROOT, "largestipule_leather_root");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.RHACOPHYTON, "rhacophyton");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.GRAMINIDITES_BAMBUSOIDES, "graminidites_bambusoides");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.ENALLHELIA, "enallhelia");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.AULOPORA, "aulopora");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CLADOCHONUS, "cladochonus");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LITHOSTROTION, "lithostrotion");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.STYLOPHYLLOPSIS, "stylophyllopsis");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.HIPPURITES_RADIOSUS, "hippurites_radiosus");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.HELICONIA, "heliconia");
        RenderingHandler.registerBlockRenderer(BlockHandler.REINFORCED_STONE, "reinforced_stone");
        RenderingHandler.registerBlockRenderer(BlockHandler.REINFORCED_BRICKS, "reinforced_bricks");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CULTIVATOR_BOTTOM, "cultivate_bottom");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CULTIVATOR_TOP, "cultivate_top");
        RenderingHandler.registerBlockRenderer(BlockHandler.AMBER_ORE, "amber_ore");
        RenderingHandler.registerBlockRenderer(BlockHandler.ICE_SHARD, "ice_shard");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CLEANING_STATION, "cleaning_station");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.FOSSIL_GRINDER, "fossil_grinder");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DNA_SEQUENCER, "dna_sequencer");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DNA_COMBINATOR_HYBRIDIZER, "dna_combinator_hybridizer");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DNA_SYNTHESIZER, "dna_synthesizer");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.EMBRYONIC_MACHINE, "embryonic_machine");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.EMBRYO_CALCIFICATION_MACHINE, "embryo_calcification_machine");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.INCUBATOR, "incubator");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DNA_EXTRACTOR, "dna_extractor");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.FEEDER, "feeder");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.SKULL_DISPLAY, "skull_display");
        RenderingHandler.registerBlockRenderer(BlockHandler.SKELETON_ASSEMBLY, "skeleton_assembly");
        RenderingHandler.registerBlockRenderer(BlockHandler.GYPSUM_STONE, "gypsum_stone");
        RenderingHandler.registerBlockRenderer(BlockHandler.GYPSUM_COBBLESTONE, "gypsum_cobblestone");
        RenderingHandler.registerBlockRenderer(BlockHandler.GYPSUM_BRICKS, "gypsum_bricks");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DISPLAY_BLOCK, "display_block");
        RenderingHandler.registerBlockRenderer(BlockHandler.MOSS, "moss");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CLEAR_GLASS, "clear_glass");
        RenderingHandler.registerBlockRenderer(BlockHandler.CLEAR_GLASS_PANE, "clear_glass_pane");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.REINFORCED_GLASS, "reinforced_glass");
        RenderingHandler.registerBlockRenderer(BlockHandler.REINFORCED_GLASS_PANE, "reinforced_glass_pane");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.WILD_ONION, "wild_onion_plant");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.GRACILARIA, "gracilaria_seaweed");
        RenderingHandler.registerBlockRenderer(BlockHandler.PEAT, "peat");
        RenderingHandler.registerBlockRenderer(BlockHandler.PEAT_MOSS, "peat_moss");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DICROIDIUM_ZUBERI, "dicroidium_zuberi");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.WEST_INDIAN_LILAC, "west_indian_lilac");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.DICTYOPHYLLUM, "dictyophyllum");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.SERENNA_VERIFORMANS, "serenna_veriformans");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LADINIA_SIMPLEX, "ladinia_simplex");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.ORONTIUM_MACKII, "orontium_mackii");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.UMALTOLEPIS, "umaltolepis");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LIRIODENDRITES, "liriodendrites");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.RAPHAELIA, "raphaelia");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.ENCEPHALARTOS, "encephalartos");
        iterator = FossilizedTrackwayBlock.TrackwayType.values();
        fossil = ((Iterator<Block>)iterator).length;
        boolean bl4 = false;
        while (var4_25 < fossil) {
            Iterator<Block> iterator3 = iterator[var4_25];
            RenderingHandler.registerBlockRenderer(BlockHandler.FOSSILIZED_TRACKWAY, ((Enum)((Object)iterator3)).ordinal(), "fossilized_trackway_" + ((FossilizedTrackwayBlock.TrackwayType)((Object)iterator3)).func_176610_l());
            ++var4_25;
        }
        iterator = NestFossilBlock.Variant.values();
        fossil = ((Iterator<Block>)iterator).length;
        boolean bl5 = false;
        while (var4_27 < fossil) {
            Iterator<Block> iterator4 = iterator[var4_27];
            RenderingHandler.registerBlockRenderer(BlockHandler.NEST_FOSSIL, ((Enum)((Object)iterator4)).ordinal(), "nest_fossil_" + (((Enum)((Object)iterator4)).ordinal() + 1));
            RenderingHandler.registerBlockRenderer(BlockHandler.ENCASED_NEST_FOSSIL, ((Enum)((Object)iterator4)).ordinal(), "encased_nest_fossil");
            ++var4_27;
        }
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.PALEO_BALE_CYCADEOIDEA, "paleo_bale_cycadeoidea");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.PALEO_BALE_CYCAD, "paleo_bale_cycad");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.PALEO_BALE_FERN, "paleo_bale_fern");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.PALEO_BALE_LEAVES, "paleo_bale_leaves");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.PALEO_BALE_OTHER, "paleo_bale_other");
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.AJUGINUCULA_SMITHII);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.BUG_CRATE);
        RenderingHandler.registerBlockRenderer(BlockHandler.PLANKTON_SWARM);
        RenderingHandler.registerBlockRenderer(BlockHandler.KRILL_SWARM);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LOW_SECURITY_FENCE_POLE);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LOW_SECURITY_FENCE_BASE);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.LOW_SECURITY_FENCE_WIRE);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.WILD_POTATO_PLANT);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.RHAMNUS_SALICIFOLIUS_PLANT);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.TEMPSKYA);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.CINNAMON_FERN);
        RenderingHandler.registerBlockRenderer((Block)BlockHandler.BRISTLE_FERN);
        RenderingHandler.registerBlockRenderer(BlockHandler.TOUR_RAIL, "tour_rail.tbl_jurassicraft");
        RenderingHandler.registerBlockRenderer(BlockHandler.TOUR_RAIL_SLOW, "tour_rail_stripe.tbl_jurassicraft");
        RenderingHandler.registerBlockRenderer(BlockHandler.TOUR_RAIL_MEDIUM, "tour_rail_stripe.tbl_jurassicraft");
        RenderingHandler.registerBlockRenderer(BlockHandler.TOUR_RAIL_FAST, "tour_rail_stripe.tbl_jurassicraft");
        RenderingHandler.registerItemRenderer(ItemHandler.TRACKER);
        RenderingHandler.registerItemRenderer(ItemHandler.PLANT_CELLS_PETRI_DISH);
        RenderingHandler.registerItemRenderer(ItemHandler.PLANT_CELLS);
        RenderingHandler.registerItemRenderer(ItemHandler.GROWTH_SERUM);
        RenderingHandler.registerItemRenderer(ItemHandler.BREEDING_WAND);
        RenderingHandler.registerItemRenderer(ItemHandler.BIRTHING_WAND);
        RenderingHandler.registerItemRenderer(ItemHandler.PREGNANCY_TEST);
        RenderingHandler.registerItemRenderer(ItemHandler.IRON_ROD);
        RenderingHandler.registerItemRenderer(ItemHandler.IRON_BLADES);
        RenderingHandler.registerItemRenderer(ItemHandler.PETRI_DISH);
        RenderingHandler.registerItemRenderer(ItemHandler.PETRI_DISH_AGAR);
        RenderingHandler.registerItemRenderer(ItemHandler.PLASTER_AND_BANDAGE);
        RenderingHandler.registerItemRenderer((Item)ItemHandler.FUN_FRIES);
        RenderingHandler.registerItemRenderer((Item)ItemHandler.OILED_POTATO_STRIPS);
        RenderingHandler.registerItemRenderer(ItemHandler.LUNCH_BOX);
        RenderingHandler.registerItemRenderer(ItemHandler.STAMP_SET);
        RenderingHandler.registerItemRenderer(ItemHandler.INGEN_JOURNAL);
        for (Integer id : EntityHandler.getDinosaurs().keySet()) {
            RenderingHandler.registerItemRenderer(ItemHandler.SPAWN_EGG, id, "dino_spawn_egg");
        }
        RenderingHandler.registerItemRenderer(ItemHandler.PADDOCK_SIGN);
        iterator = AttractionSignEntity.AttractionSignType.values();
        int id = ((Iterator<Object>)iterator).length;
        boolean bl6 = false;
        while (var4_29 < id) {
            Iterator<Object> iterator5 = iterator[var4_29];
            RenderingHandler.registerItemRenderer(ItemHandler.ATTRACTION_SIGN, ((Enum)((Object)iterator5)).ordinal(), "attraction_sign_" + ((Enum)((Object)iterator5)).name().toLowerCase(Locale.ENGLISH));
            ++var4_29;
        }
        RenderingHandler.registerItemRenderer(ItemHandler.EMPTY_TEST_TUBE);
        RenderingHandler.registerItemRenderer(ItemHandler.EMPTY_SYRINGE);
        RenderingHandler.registerItemRenderer(ItemHandler.STORAGE_DISC);
        RenderingHandler.registerItemRenderer(ItemHandler.DISC_DRIVE, "disc_reader");
        RenderingHandler.registerItemRenderer(ItemHandler.LASER);
        RenderingHandler.registerItemRenderer(ItemHandler.DNA_NUCLEOTIDES, "dna_base_material");
        RenderingHandler.registerItemRenderer(ItemHandler.SEA_LAMPREY);
        RenderingHandler.registerItemRenderer(ItemHandler.AMBER, 0, "amber_mosquito");
        RenderingHandler.registerItemRenderer(ItemHandler.AMBER, 1, "amber_aphid");
        RenderingHandler.registerItemRenderer((Item)ItemHandler.JURASSICRAFT_THEME_DISC, "disc_jurassicraft_theme");
        RenderingHandler.registerItemRenderer((Item)ItemHandler.DONT_MOVE_A_MUSCLE_DISC, "disc_dont_move_a_muscle");
        RenderingHandler.registerItemRenderer((Item)ItemHandler.TROODONS_AND_RAPTORS_DISC, "disc_troodons_and_raptors");
        RenderingHandler.registerItemRenderer(ItemHandler.AMBER_KEYCHAIN, "amber_keychain");
        RenderingHandler.registerItemRenderer(ItemHandler.AMBER_CANE, "amber_cane");
        RenderingHandler.registerItemRenderer(ItemHandler.MR_DNA_KEYCHAIN, "mr_dna_keychain");
        RenderingHandler.registerItemRenderer(ItemHandler.DINO_SCANNER, "dino_scanner");
        RenderingHandler.registerItemRenderer(ItemHandler.BASIC_CIRCUIT, "basic_circuit");
        RenderingHandler.registerItemRenderer(ItemHandler.ADVANCED_CIRCUIT, "advanced_circuit");
        RenderingHandler.registerItemRenderer(ItemHandler.GYPSUM_POWDER, "gypsum_powder");
        RenderingHandler.registerItemRenderer(ItemHandler.AJUGINUCULA_SMITHII_SEEDS, "ajuginucula_smithii_seeds");
        RenderingHandler.registerItemRenderer(ItemHandler.AJUGINUCULA_SMITHII_LEAVES, "ajuginucula_smithii_leaves");
        RenderingHandler.registerItemRenderer(ItemHandler.AJUGINUCULA_SMITHII_OIL, "ajuginucula_smithii_oil");
        RenderingHandler.registerItemRenderer(ItemHandler.WILD_ONION, "wild_onion");
        RenderingHandler.registerItemRenderer(ItemHandler.GRACILARIA);
        RenderingHandler.registerItemRenderer(ItemHandler.AULOPORA, "aulopora_coral");
        RenderingHandler.registerItemRenderer(ItemHandler.STYLOPHYLLOPSIS, "stylophyllopsis_coral");
        RenderingHandler.registerItemRenderer(ItemHandler.CLADOCHONUS, "cladochonus_coral");
        RenderingHandler.registerItemRenderer(ItemHandler.ENALLHELIA, "enallhelia_coral");
        RenderingHandler.registerItemRenderer(ItemHandler.HIPPURITES_RADIOSUS, "hippurites_radiosus_coral");
        RenderingHandler.registerItemRenderer(ItemHandler.LITHOSTROTION, "lithostrotion_coral");
        RenderingHandler.registerItemRenderer(ItemHandler.LIQUID_AGAR, "liquid_agar");
        RenderingHandler.registerItemRenderer(ItemHandler.PLANT_FOSSIL, "plant_fossil");
        RenderingHandler.registerItemRenderer(ItemHandler.TWIG_FOSSIL, "twig_fossil");
        RenderingHandler.registerItemRenderer(ItemHandler.KEYBOARD, "keyboard");
        RenderingHandler.registerItemRenderer(ItemHandler.COMPUTER_SCREEN, "computer_screen");
        RenderingHandler.registerItemRenderer(ItemHandler.DNA_ANALYZER, "dna_analyzer");
        RenderingHandler.registerItemRenderer((Item)ItemHandler.CHILEAN_SEA_BASS, "chilean_sea_bass");
        RenderingHandler.registerItemRenderer(ItemHandler.FIELD_GUIDE, "field_guide");
        RenderingHandler.registerItemRenderer(ItemHandler.CAR_CHASSIS, "car_chassis");
        RenderingHandler.registerItemRenderer(ItemHandler.ENGINE_SYSTEM, "engine_system");
        RenderingHandler.registerItemRenderer(ItemHandler.CAR_SEATS, "car_seats");
        RenderingHandler.registerItemRenderer(ItemHandler.CAR_TIRE, "car_tire");
        RenderingHandler.registerItemRenderer(ItemHandler.CAR_WINDSCREEN, "car_windscreen");
        RenderingHandler.registerItemRenderer(ItemHandler.UNFINISHED_CAR, "unfinished_car");
        for (int x = 0; x < VehicleItem.variants.length; ++x) {
            RenderingHandler.registerItemRenderer(ItemHandler.VEHICLE_ITEM, x, VehicleItem.variants[x]);
            RenderingHandler.registerItemRenderer(ItemHandler.VEHICLE_ITEM, x, VehicleItem.variants[x]);
            RenderingHandler.registerItemRenderer(ItemHandler.VEHICLE_ITEM, x, VehicleItem.variants[x]);
        }
        RenderingHandler.registerItemRenderer(ItemHandler.MURAL, "mural");
        for (Dinosaur dinosaur : EntityHandler.getDinosaurs().values()) {
            int n = EntityHandler.getDinosaurId(dinosaur);
            String string = dinosaur.getIdentifier().func_110623_a();
            RenderingHandler.registerItemRenderer(ItemHandler.DISPLAY_BLOCK_ITEM, DisplayBlockItem.getMetadata(n, false, false), "action_figure/action_figure_" + string);
            RenderingHandler.registerItemRenderer(ItemHandler.DISPLAY_BLOCK_ITEM, DisplayBlockItem.getMetadata(n, true, true), "skeleton/fossil/skeleton_fossil_" + string);
            RenderingHandler.registerItemRenderer(ItemHandler.DISPLAY_BLOCK_ITEM, DisplayBlockItem.getMetadata(n, false, true), "skeleton/fresh/skeleton_fresh_" + string);
            ItemHandler.FOSSILS.forEach((type, item) -> {
                List<Dinosaur> dinosaursForType = FossilItem.fossilDinosaurs.get(type);
                if (dinosaursForType.contains(dinosaur)) {
                    RenderingHandler.registerItemRenderer(item, meta3, "bones/" + formattedName + "_" + type);
                }
            });
            ItemHandler.FRESH_FOSSILS.forEach((type, item) -> {
                List<Dinosaur> dinosaursForType = FossilItem.fossilDinosaurs.get(type);
                if (dinosaursForType.contains(dinosaur)) {
                    RenderingHandler.registerItemRenderer(item, meta3, "fresh_bones/" + formattedName + "_" + type);
                }
            });
            RenderingHandler.registerItemRenderer(ItemHandler.DNA, n, "dna/dna_" + string);
            RenderingHandler.registerItemRenderer((Item)ItemHandler.DINOSAUR_MEAT, n, "meat/meat_" + string);
            RenderingHandler.registerItemRenderer((Item)ItemHandler.DINOSAUR_STEAK, n, "meat/steak_" + string);
            RenderingHandler.registerItemRenderer(ItemHandler.SOFT_TISSUE, n, "soft_tissue/soft_tissue_" + string);
            RenderingHandler.registerItemRenderer(ItemHandler.SYRINGE, n, "syringe/syringe_" + string);
            if (!dinosaur.getMetadata().givesDirectBirth()) {
                RenderingHandler.registerItemRenderer(ItemHandler.EGG, n, "egg/egg_" + string);
            }
            RenderingHandler.registerItemRenderer(ItemHandler.HATCHED_EGG, n, "hatched_egg/egg_" + string);
        }
        for (Plant plant : PlantHandler.getPrehistoricPlantsAndTrees()) {
            int n = PlantHandler.getPlantId(plant);
            String string = plant.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
            RenderingHandler.registerItemRenderer(ItemHandler.PLANT_DNA, n, "dna/plants/dna_" + string);
            RenderingHandler.registerItemRenderer(ItemHandler.PLANT_SOFT_TISSUE, n, "soft_tissue/plants/soft_tissue_" + string);
            RenderingHandler.registerItemRenderer(ItemHandler.PLANT_CALLUS, n, "plant_callus");
        }
        Iterator<Comparable<Dinosaur>> iterator6 = JournalItem.JournalType.values();
        int n = ((Iterator<Comparable<Dinosaur>>)iterator6).length;
        boolean bl7 = false;
        while (var4_33 < n) {
            Iterator<Comparable<Dinosaur>> iterator7 = iterator6[var4_33];
            RenderingHandler.registerItemRenderer(ItemHandler.INGEN_JOURNAL, ((JournalItem.JournalType)((Object)iterator7)).getMetadata(), "ingen_journal");
            ++var4_33;
        }
        iterator6 = NestFossilBlock.Variant.values();
        n = ((Iterator<Comparable<Dinosaur>>)iterator6).length;
        boolean bl8 = false;
        while (var4_35 < n) {
            Iterator<Comparable<Dinosaur>> iterator8 = iterator6[var4_35];
            RenderingHandler.registerItemRenderer(ItemHandler.FOSSILIZED_EGG, ((Enum)((Object)iterator8)).ordinal(), "fossilized_egg_" + (((Enum)((Object)iterator8)).ordinal() + 1));
            ++var4_35;
        }
        iterator6 = TreeType.values();
        n = ((Iterator<Comparable<Dinosaur>>)iterator6).length;
        boolean bl9 = false;
        while (var4_37 < n) {
            Iterator<Comparable<Dinosaur>> iterator9 = iterator6[var4_37];
            name = ((Enum)((Object)iterator9)).name().toLowerCase(Locale.ENGLISH);
            RenderingHandler.registerItemRenderer((Item)ItemHandler.ANCIENT_DOORS.get(iterator9), name + "_door_item");
            ++var4_37;
        }
        RenderingHandler.registerItemRenderer(ItemHandler.PHOENIX_SEEDS);
        RenderingHandler.registerItemRenderer((Item)ItemHandler.PHOENIX_FRUIT);
        RenderingHandler.registerItemRenderer(ItemHandler.CRICKETS);
        RenderingHandler.registerItemRenderer(ItemHandler.COCKROACHES);
        RenderingHandler.registerItemRenderer(ItemHandler.MEALWORM_BEETLES);
        RenderingHandler.registerItemRenderer(ItemHandler.FINE_NET);
        RenderingHandler.registerItemRenderer(ItemHandler.PLANKTON);
        RenderingHandler.registerItemRenderer(ItemHandler.KRILL);
        RenderingHandler.registerItemRenderer(ItemHandler.WILD_POTATO_SEEDS);
        RenderingHandler.registerItemRenderer(ItemHandler.WILD_POTATO);
        RenderingHandler.registerItemRenderer(ItemHandler.WILD_POTATO_COOKED);
        RenderingHandler.registerItemRenderer(ItemHandler.RHAMNUS_SEEDS);
        RenderingHandler.registerItemRenderer(ItemHandler.RHAMNUS_BERRIES);
        RenderingHandler.registerItemRenderer((Item)ItemHandler.GOAT_RAW);
        RenderingHandler.registerItemRenderer((Item)ItemHandler.GOAT_COOKED);
        RenderingHandler.registerItemRenderer(ItemHandler.DART_GUN);
        RenderingHandler.registerItemRenderer(ItemHandler.DART_TRANQUILIZER, "dart_colored");
        RenderingHandler.registerItemRenderer(ItemHandler.DART_POISON_CYCASIN, "dart_colored");
        RenderingHandler.registerItemRenderer(ItemHandler.DART_POISON_EXECUTIONER_CONCOCTION, "dart_colored");
        RenderingHandler.registerItemRenderer(ItemHandler.DART_TIPPED_POTION, "dart_colored");
        RenderingHandler.registerItemRenderer(ItemHandler.WEST_INDIAN_LILAC_BERRIES);
    }

    public void preInit() {
        TabulaModelHandler.INSTANCE.addDomain("jurassicraft");
        RenderingHandler.registerRenderInfo(EntityHandler.BRACHIOSAURUS, new BrachiosaurusAnimator(), 1.5f);
        RenderingHandler.registerRenderInfo(EntityHandler.COELACANTH, new CoelacanthAnimator(), 0.0f);
        RenderingHandler.registerRenderInfo(EntityHandler.DILOPHOSAURUS, new DilophosaurusAnimator(), 0.65f);
        RenderingHandler.registerRenderInfo(EntityHandler.GALLIMIMUS, new GallimimusAnimator(), 0.65f);
        RenderingHandler.registerRenderInfo(EntityHandler.PARASAUROLOPHUS, new ParasaurolophusAnimator(), 0.65f);
        RenderingHandler.registerRenderInfo(EntityHandler.MICRORAPTOR, new MicroraptorAnimator(), 0.45f);
        RenderingHandler.registerRenderInfo(EntityHandler.MUSSAURUS, new MussaurusAnimator(), 0.8f);
        RenderingHandler.registerRenderInfo(EntityHandler.TRICERATOPS, new TriceratopsAnimator(), 0.65f);
        RenderingHandler.registerRenderInfo(EntityHandler.TYRANNOSAURUS, new TyrannosaurusAnimator(), 0.65f);
        RenderingHandler.registerRenderInfo(EntityHandler.VELOCIRAPTOR, new VelociraptorAnimator(), 0.45f);
        RenderingRegistry.registerEntityRenderingHandler(PaddockSignEntity.class, (IRenderFactory)new PaddockSignRenderer());
        RenderingRegistry.registerEntityRenderingHandler(AttractionSignEntity.class, (IRenderFactory)new AttractionSignRenderer());
        RenderingRegistry.registerEntityRenderingHandler(DinosaurEggEntity.class, (IRenderFactory)new DinosaurEggRenderer());
        RenderingRegistry.registerEntityRenderingHandler(VenomEntity.class, (IRenderFactory)new VenomRenderer());
        RenderingRegistry.registerEntityRenderingHandler(JeepWranglerEntity.class, JeepWranglerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(FordExplorerEntity.class, FordExplorerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TransportHelicopterEntity.class, HeliRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MuralEntity.class, MuralRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(GoatEntity.class, GoatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TranquilizerDartEntity.class, NullRenderer::new);
    }

    public void init() {
        BlockColors blockColors = ClientProxy.MC.func_184125_al();
        blockColors.func_186722_a((state, access, pos, tintIndex) -> pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)access, (BlockPos)pos) : 0xFFFFFF, new Block[]{BlockHandler.MOSS});
        for (AncientLeavesBlock block : BlockHandler.ANCIENT_LEAVES.values()) {
            blockColors.func_186722_a((state, access, pos, tintIndex) -> pos == null ? ColorizerFoliage.func_77468_c() : BiomeColorHelper.func_180287_b((IBlockAccess)access, (BlockPos)pos), new Block[]{block});
        }
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pos) : -1;
            }
        }, new Block[]{BlockHandler.STYLOPHYLLOPSIS, BlockHandler.ENALLHELIA, BlockHandler.AULOPORA, BlockHandler.CLADOCHONUS, BlockHandler.LITHOSTROTION, BlockHandler.HIPPURITES_RADIOSUS, BlockHandler.GRACILARIA});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> pos == null ? ColorizerFoliage.func_77468_c() : BiomeColorHelper.func_180287_b((IBlockAccess)access, (BlockPos)pos), new Block[]{BlockHandler.MOSS});
        if (JurassiCraftConfig.VEHICLES.tourRailBlockEnabled) {
            blockColors.func_186722_a((state, access, pos, tintIndex) -> tintIndex == 1 ? ((TourRailBlock)state.func_177230_c()).getSpeedType().getColor() : -1, new Block[]{BlockHandler.TOUR_RAIL_SLOW, BlockHandler.TOUR_RAIL_MEDIUM, BlockHandler.TOUR_RAIL_FAST});
        }
        ItemColors itemColors = ClientProxy.MC.getItemColors();
        if (JurassiCraftConfig.VEHICLES.tourRailBlockEnabled) {
            itemColors.func_186731_a((stack, tintIndex) -> tintIndex == 1 ? ((TourRailBlock)((ItemBlock)stack.func_77973_b()).func_179223_d()).getSpeedType().getColor() : -1, new Block[]{BlockHandler.TOUR_RAIL_SLOW, BlockHandler.TOUR_RAIL_MEDIUM, BlockHandler.TOUR_RAIL_FAST});
        }
        for (AncientLeavesBlock block : BlockHandler.ANCIENT_LEAVES.values()) {
            itemColors.func_186731_a((stack, tintIndex) -> ColorizerFoliage.func_77468_c(), new Block[]{block});
        }
        itemColors.func_186730_a((stack, tintIndex) -> {
            Dinosaur dino = DinosaurSpawnEggItem.getDinosaur(stack);
            if (dino != null) {
                DinosaurMetadata metadata = dino.getMetadata();
                int mode = DinosaurSpawnEggItem.getMode(stack);
                if (mode == 0) {
                    int n = mode = JurassiCraft.timerTicks % 64L > 32L ? 1 : 2;
                }
                if (mode == 1) {
                    return tintIndex == 0 ? metadata.getEggPrimaryColorMale() : metadata.getEggSecondaryColorMale();
                }
                return tintIndex == 0 ? metadata.getEggPrimaryColorFemale() : metadata.getEggSecondaryColorFemale();
            }
            return 0xFFFFFF;
        }, new Item[]{ItemHandler.SPAWN_EGG});
        itemColors.func_186730_a((stack, tintIndex) -> tintIndex == 1 ? ((Dart)stack.func_77973_b()).getDartColor(stack) : -1, new Item[]{ItemHandler.DART_POISON_CYCASIN, ItemHandler.DART_POISON_EXECUTIONER_CONCOCTION, ItemHandler.DART_TIPPED_POTION, ItemHandler.DART_TRANQUILIZER});
        if (JurassiCraftConfig.VEHICLES.helicopterZoomout && this.mc.field_71460_t.getClass() == EntityRenderer.class) {
            entityRenderer = new OverridenEntityRenderer(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_110442_L());
            Minecraft.func_71410_x().field_71460_t = entityRenderer;
        }
    }

    public void postInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(DNAExtractorBlockEntity.class, (TileEntitySpecialRenderer)new DNAExtractorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DisplayBlockEntity.class, (TileEntitySpecialRenderer)new DisplayBlockRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DNASequencerBlockEntity.class, (TileEntitySpecialRenderer)new DNASequencerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(IncubatorBlockEntity.class, (TileEntitySpecialRenderer)new IncubatorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(FeederBlockEntity.class, (TileEntitySpecialRenderer)new FeederRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SkullDisplayEntity.class, (TileEntitySpecialRenderer)new SkullDisplayRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ElectricFencePoleBlockEntity.class, (TileEntitySpecialRenderer)new ElectricFencePoleRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CleaningStationBlockEntity.class, (TileEntitySpecialRenderer)new CleaningStationRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(AncientItemHoldingBlockEntity.class, (TileEntitySpecialRenderer)new AncientItemHoldingBlockRenderer());
    }

    public static void registerItemRenderer(Item item) {
        RenderingHandler.registerItemRenderer(item, item.func_77658_a().substring("item.".length()));
    }

    public static void registerBlockRenderer(Block block) {
        RenderingHandler.registerBlockRenderer(block, block.func_149739_a().substring("tile.".length()));
    }

    public static void registerItemRenderer(Item item, int meta, String path) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("jurassicraft:" + path, "inventory"));
    }

    public static void registerItemRenderer(Item item, String path) {
        RenderingHandler.registerItemRenderer(item, 0, path);
    }

    public static void registerBlockRenderer(Block block, int meta, String path) {
        RenderingHandler.registerItemRenderer(Item.func_150898_a((Block)block), meta, path);
    }

    public static void registerBlockRenderer(Block block, String path) {
        RenderingHandler.registerBlockRenderer(block, 0, path);
    }

    private static void registerRenderInfo(Dinosaur dinosaur, EntityAnimator<?> animator, float shadowSize) {
        RenderingHandler.registerRenderInfo(new DinosaurRenderInfo(dinosaur, animator, shadowSize));
    }

    private static void registerRenderInfo(DinosaurRenderInfo renderInfo) {
        renderInfos.put(renderInfo.getDinosaur(), renderInfo);
        DinosaurMetadata metadata = renderInfo.getDinosaur().getMetadata();
        RenderingRegistry.registerEntityRenderingHandler(metadata.getDinosaurClass(), (IRenderFactory)renderInfo);
    }

    public static DinosaurRenderInfo getRenderInfo(Dinosaur dino) {
        return renderInfos.get(dino);
    }

    public void setThirdPersonViewDistance(float distance) {
        if (entityRenderer != null) {
            entityRenderer.setThirdPersonViewDistance(distance);
        }
    }

    public float getThirdPersonViewDistance() {
        if (entityRenderer != null) {
            return entityRenderer.getThirdPersonViewDistance();
        }
        return this.getDefaultThirdPersonViewDistance();
    }

    public void resetThirdPersonViewDistance() {
        this.setThirdPersonViewDistance(this.getDefaultThirdPersonViewDistance());
    }

    public float getDefaultThirdPersonViewDistance() {
        if (entityRenderer != null) {
            return entityRenderer.getMinThirdPersonViewDistance();
        }
        return 4.0f;
    }

    static {
        renderInfos = Maps.newHashMap();
    }
}

