/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.ilexiconn.llibrary.client.lang.LanguageHandler;
import net.ilexiconn.llibrary.server.util.WebUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.event.ClientEventHandler;
import org.jurassicraft.client.gui.BugCrateGui;
import org.jurassicraft.client.gui.CleaningStationGui;
import org.jurassicraft.client.gui.CultivateGui;
import org.jurassicraft.client.gui.CultivateProcessGui;
import org.jurassicraft.client.gui.DNACombinatorHybridizerGui;
import org.jurassicraft.client.gui.DNAExtractorGui;
import org.jurassicraft.client.gui.DNASequencerGui;
import org.jurassicraft.client.gui.DNASynthesizerGui;
import org.jurassicraft.client.gui.EmbryoCalcificationMachineGui;
import org.jurassicraft.client.gui.EmbryonicMachineGui;
import org.jurassicraft.client.gui.FeederGui;
import org.jurassicraft.client.gui.FieldGuideGui;
import org.jurassicraft.client.gui.FossilGrinderGui;
import org.jurassicraft.client.gui.IncubatorGui;
import org.jurassicraft.client.gui.JournalGui;
import org.jurassicraft.client.gui.OrderDinosaurGui;
import org.jurassicraft.client.gui.SelectDinoGui;
import org.jurassicraft.client.gui.SkeletonAssemblyGui;
import org.jurassicraft.client.model.JurassicraftTabulaModelHandler;
import org.jurassicraft.client.render.RenderingHandler;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.client.sound.VehicleSound;
import org.jurassicraft.server.block.entity.BugCrateBlockEntity;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DNASynthesizerBlockEntity;
import org.jurassicraft.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import org.jurassicraft.server.block.entity.EmbryonicMachineBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.FossilGrinderBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.particle.VenomParticle;
import org.jurassicraft.server.entity.vehicle.VehicleEntity;
import org.jurassicraft.server.event.KeyBindingHandler;
import org.jurassicraft.server.item.JournalItem;
import org.jurassicraft.server.proxy.ServerProxy;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ServerProxy {
    public static final Minecraft MC = Minecraft.func_71410_x();
    private static KeyBindingHandler keyHandler = new KeyBindingHandler();
    public static final List<UUID> PATRONS = new ArrayList<UUID>();

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        super.onPreInit(event);
        KeyBindingHandler.init();
        try {
            LanguageHandler.INSTANCE.loadRemoteLocalization("jurassicraft");
        }
        catch (Exception e) {
            JurassiCraft.getLogger().error("Failed to load remote localizations", (Throwable)e);
        }
        MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)RenderingHandler.INSTANCE);
        RenderingHandler.INSTANCE.preInit();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)JurassicraftTabulaModelHandler.INSTANCE);
        JurassicraftTabulaModelHandler.INSTANCE.addDomain("jurassicraft");
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"org.jurassicraft.server.plugin.waila.BlockDataProvider.init");
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"org.jurassicraft.server.plugin.waila.EntityDataProvider.init");
        RenderingHandler.INSTANCE.init();
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        super.onPostInit(event);
        RenderingHandler.INSTANCE.postInit();
        new Thread(() -> {
            List patrons = WebUtils.readPastebinAsList((String)"G8AVxw6A");
            if (patrons != null) {
                for (String patron : patrons) {
                    PATRONS.add(UUID.fromString(patron));
                }
            }
        }).start();
    }

    @Override
    public EntityPlayer getPlayer() {
        return ClientProxy.MC.field_71439_g;
    }

    @Override
    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? this.getPlayer() : super.getPlayerEntityFromContext(ctx);
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof CleaningStationBlockEntity && id == 0) {
                return new CleaningStationGui(player.field_71071_by, (IInventory)((CleaningStationBlockEntity)tile));
            }
            if (tile instanceof FossilGrinderBlockEntity && id == 1) {
                return new FossilGrinderGui(player.field_71071_by, (IInventory)((FossilGrinderBlockEntity)tile));
            }
            if (tile instanceof DNASequencerBlockEntity && id == 2) {
                return new DNASequencerGui(player.field_71071_by, (IInventory)((DNASequencerBlockEntity)tile));
            }
            if (tile instanceof EmbryonicMachineBlockEntity && id == 3) {
                return new EmbryonicMachineGui(player.field_71071_by, (IInventory)((EmbryonicMachineBlockEntity)tile));
            }
            if (tile instanceof EmbryoCalcificationMachineBlockEntity && id == 4) {
                return new EmbryoCalcificationMachineGui(player.field_71071_by, (IInventory)((EmbryoCalcificationMachineBlockEntity)tile));
            }
            if (tile instanceof DNASynthesizerBlockEntity && id == 5) {
                return new DNASynthesizerGui(player.field_71071_by, (IInventory)((DNASynthesizerBlockEntity)tile));
            }
            if (tile instanceof IncubatorBlockEntity && id == 6) {
                return new IncubatorGui(player.field_71071_by, (IncubatorBlockEntity)tile);
            }
            if (tile instanceof DNACombinatorHybridizerBlockEntity && id == 7) {
                return new DNACombinatorHybridizerGui(player.field_71071_by, (DNACombinatorHybridizerBlockEntity)tile);
            }
            if (tile instanceof DNAExtractorBlockEntity && id == 8) {
                return new DNAExtractorGui(player.field_71071_by, (IInventory)((DNAExtractorBlockEntity)tile));
            }
            if (tile instanceof CultivatorBlockEntity && id == 9) {
                CultivatorBlockEntity cultivator = (CultivatorBlockEntity)tile;
                if (cultivator.isProcessing(0)) {
                    return new CultivateProcessGui(player.field_71071_by, cultivator);
                }
                return new CultivateGui(player.field_71071_by, cultivator);
            }
            if (tile instanceof FeederBlockEntity && id == 10) {
                return new FeederGui(player.field_71071_by, (IInventory)((FeederBlockEntity)tile));
            }
            if (tile instanceof BugCrateBlockEntity && id == 11) {
                return new BugCrateGui(player.field_71071_by, (BugCrateBlockEntity)tile);
            }
        }
        if (id == 12) {
            return new SkeletonAssemblyGui(SkeletonAssemblyGui.createContainer(player.field_71071_by, world, pos));
        }
        return null;
    }

    public static KeyBindingHandler getKeyHandler() {
        return keyHandler;
    }

    @Override
    public void openSelectDino(BlockPos pos, EnumFacing facing, EnumHand hand) {
        MC.func_147108_a((GuiScreen)new SelectDinoGui(pos, facing, hand));
    }

    @Override
    public void openOrder(DinosaurEntity entity) {
        MC.func_147108_a((GuiScreen)new OrderDinosaurGui(entity));
    }

    @Override
    public void openFieldGuide(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo fieldGuideInfo) {
        MC.func_147108_a((GuiScreen)new FieldGuideGui(entity, fieldGuideInfo));
    }

    @Override
    public void openJournal(JournalItem.JournalType type) {
        MC.func_147108_a((GuiScreen)new JournalGui(type));
    }

    public static void playCarSound(VehicleEntity entity) {
        MC.func_147118_V().func_147682_a((ISound)new VehicleSound(entity, SoundHandler.CAR_MOVE));
    }

    public static void playHelicopterSound(VehicleEntity entity) {
        MC.func_147118_V().func_147682_a((ISound)new VehicleSound(entity, SoundHandler.CAR_MOVE));
    }

    public static void stopSound(ISound sound) {
        MC.func_147118_V().func_147683_b(sound);
    }

    public static void spawnVenomParticles(VenomEntity entity) {
        ParticleManager particleManager = ClientProxy.MC.field_71452_i;
        float size = 0.35f;
        for (int i = 0; i < 16; ++i) {
            particleManager.func_78873_a((Particle)new VenomParticle(entity.field_70170_p, (double)size * Math.random() - (double)(size / 2.0f), (double)size * Math.random() - (double)(size / 2.0f), (double)size * Math.random() - (double)(size / 2.0f), 0.0, 0.0, 0.0, 1.0f, entity));
        }
    }

    private static void registerEntity(Class<? extends Entity> entity, String name) {
        String formattedName = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        ResourceLocation registryName = new ResourceLocation("jurassicraft:entities." + formattedName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entity, (String)("jurassicraft." + formattedName), (int)2055, (Object)JurassiCraft.INSTANCE, (int)1024, (int)1, (boolean)true);
    }
}

