/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation.entity.vehicle;

import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.entity.vehicle.HelicopterEntity;

@SideOnly(value=Side.CLIENT)
public class HelicopterAnimator
implements ITabulaModelAnimator<HelicopterEntity> {
    public void setRotationAngles(TabulaModel model, HelicopterEntity entity, float f, float f1, float rotation, float rotationYaw, float rotationPitch, float partialTicks) {
        AdvancedModelRenderer rotor = model.getCube("rotorbase_rotatehere");
        AdvancedModelRenderer tailrotor = model.getCube("tailrotor_rotatehere");
        rotor.field_78796_g = (float)entity.rotAmount;
        tailrotor.field_78795_f = (float)entity.rotAmount;
        AdvancedModelRenderer ctrl1 = model.getCube("controlstick1");
        AdvancedModelRenderer ctrl2 = model.getCube("controlstick2");
        AdvancedModelRenderer gearL1 = model.getCube("gearL1");
        AdvancedModelRenderer gearL2 = model.getCube("gearL2");
        AdvancedModelRenderer gearR1 = model.getCube("gearR1");
        AdvancedModelRenderer gearR2 = model.getCube("gearR2");
        AdvancedModelRenderer gearFront = model.getCube("gearFront1");
        AdvancedModelRenderer exhaustL = model.getCube("body79");
        AdvancedModelRenderer exhaustR = model.getCube("body80");
        if (entity.isFlying) {
            gearL1.field_82908_p = entity.gearLift;
            gearR1.field_82908_p = entity.gearLift;
            gearFront.field_82908_p = entity.gearLift;
        }
        ctrl1.field_78795_f = (float)Math.toRadians(entity.interpRotationPitch.getValueForRendering(partialTicks) * -1.0);
        ctrl1.field_78808_h = (float)Math.toRadians(entity.interpRotationRoll.getValueForRendering(partialTicks) * 1.0);
        float angleX = -15.0f + entity.pitch / 25.0f * 15.0f;
        if (entity.pitch > 25.0f) {
            angleX = 0.0f;
        } else if (entity.pitch < -25.0f) {
            angleX = -30.0f;
        }
        float angleZ = entity.roll / 20.0f * 15.0f;
        if (entity.roll > 20.0f) {
            angleZ = 15.0f;
        } else if (entity.roll < -20.0f) {
            angleZ = -15.0f;
        }
        ctrl1.field_78795_f = (float)Math.toRadians(angleX);
        ctrl1.field_78808_h = (float)Math.toRadians(angleZ);
    }
}

