/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation.entity;

import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.proxy.ClientProxy;

@SideOnly(value=Side.CLIENT)
public class FixedChainBuffer {
    private int yawTimer;
    private float yawVariation;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;
    private float prevPartialTicks;

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityLivingBase entity) {
        this.prevYawVariation = this.yawVariation;
        if (entity.field_70761_aq != entity.field_70760_ar && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += (entity.field_70760_ar - entity.field_70761_aq) / divisor;
        }
        if (this.yawVariation > 0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(ModelRenderer ... boxes) {
        float rotateAmount;
        if (ClientProxy.MC.func_147113_T()) {
            rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)this.prevPartialTicks) / (float)boxes.length;
        } else {
            rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
            this.prevPartialTicks = LLibrary.PROXY.getPartialTicks();
        }
        for (ModelRenderer box : boxes) {
            box.field_78796_g += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevPitchVariation, (float)this.pitchVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78795_f += rotateAmount;
        }
    }
}

