/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import java.io.IOException;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.AnimatableModel;
import org.jurassicraft.client.model.animation.AnimationPass;
import org.jurassicraft.client.model.animation.MovementAnimationPass;
import org.jurassicraft.client.model.animation.OnLandAnimationPass;
import org.jurassicraft.client.model.animation.PosedCuboid;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.entity.AnimalMetadata;
import org.jurassicraft.server.tabula.TabulaModelHelper;

@SideOnly(value=Side.CLIENT)
public class JabelarAnimationHandler<ENTITY extends EntityLivingBase> {
    private final AnimationPass DEFAULT_PASS;
    private final AnimationPass MOVEMENT_PASS;
    private final AnimationPass ON_LAND_PASS;

    public JabelarAnimationHandler(ENTITY entity, AnimatableModel model, PosedCuboid[][] poses, Map<Animation, float[][][]> poseSequences, Map<Animation, byte[]> poseCount, boolean useInertialTweens) {
        this.DEFAULT_PASS = new AnimationPass(poseSequences, poses, poseCount, useInertialTweens);
        this.MOVEMENT_PASS = new MovementAnimationPass(poseSequences, poses, poseCount, useInertialTweens);
        this.ON_LAND_PASS = new OnLandAnimationPass(poseSequences, poses, poseCount, useInertialTweens);
        this.init(entity, model);
    }

    public static AnimatableModel loadModel(ResourceLocation model, AnimalMetadata animal) {
        try {
            return new AnimatableModel(TabulaModelHelper.loadTabulaModel(model), animal, null);
        }
        catch (IOException | NullPointerException e) {
            JurassiCraft.getLogger().error("Could not load Tabula model " + model, (Throwable)e);
            return null;
        }
    }

    private void init(ENTITY entity, AnimatableModel model) {
        AdvancedModelRenderer[] parts = this.getParts(model);
        this.DEFAULT_PASS.init(parts, (Animatable)entity);
        this.MOVEMENT_PASS.init(parts, (Animatable)entity);
        if (((Animatable)entity).isMarineCreature()) {
            this.ON_LAND_PASS.init(parts, (Animatable)entity);
        }
    }

    public void performAnimations(ENTITY entity, float limbSwing, float limbSwingAmount, float ticks) {
        this.DEFAULT_PASS.performAnimations((Animatable)entity, limbSwing, limbSwingAmount, ticks);
        if (!((Animatable)entity).isCarcass()) {
            this.MOVEMENT_PASS.performAnimations((Animatable)entity, limbSwing, limbSwingAmount, ticks);
            if (((Animatable)entity).isMarineCreature()) {
                this.ON_LAND_PASS.performAnimations((Animatable)entity, limbSwing, limbSwingAmount, ticks);
            }
        }
    }

    private AdvancedModelRenderer[] getParts(AnimatableModel model) {
        AdvancedModelRenderer[] parts = new AdvancedModelRenderer[model.getIdentifierCubes().size()];
        int i = 0;
        for (AdvancedModelRenderer part : model.getIdentifierCubes().values()) {
            parts[i++] = part;
        }
        return parts;
    }
}

