/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.model.AnimatableModel;
import org.jurassicraft.client.model.animation.JabelarAnimationHandler;
import org.jurassicraft.server.api.Animatable;
import org.jurassicraft.server.entity.GrowthStage;

@SideOnly(value=Side.CLIENT)
public abstract class EntityAnimator<ENTITY extends EntityLivingBase>
implements ITabulaModelAnimator<ENTITY> {
    protected EnumMap<GrowthStage, Map<ENTITY, JabelarAnimationHandler<ENTITY>>> animationHandlers = new EnumMap(GrowthStage.class);

    private JabelarAnimationHandler<ENTITY> getAnimationHelper(ENTITY entity, AnimatableModel model, boolean useInertialTweens) {
        JabelarAnimationHandler<ENTITY> render;
        GrowthStage growth = ((Animatable)entity).getGrowthStage();
        Map<ENTITY, JabelarAnimationHandler<ENTITY>> growthToRender = this.animationHandlers.get((Object)growth);
        if (growthToRender == null) {
            growthToRender = new WeakHashMap<ENTITY, JabelarAnimationHandler<ENTITY>>();
            this.animationHandlers.put(growth, growthToRender);
        }
        if ((render = growthToRender.get(entity)) == null) {
            render = ((Animatable)entity).getPoseHandler().createAnimationHandler(entity, model, growth, useInertialTweens);
            growthToRender.put(entity, render);
        }
        return render;
    }

    public final void setRotationAngles(TabulaModel model, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        this.getAnimationHelper(entity, (AnimatableModel)model, ((Animatable)entity).shouldUseInertia()).performAnimations(entity, limbSwing, limbSwingAmount, ticks);
        this.performAnimations((AnimatableModel)model, entity, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, scale);
    }

    protected void performAnimations(AnimatableModel parModel, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
    }
}

