/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.container.CultivateContainer;
import org.jurassicraft.server.dinosaur.Dinosaur;

@SideOnly(value=Side.CLIENT)
public class CultivateProcessGui
extends GuiScreen {
    private CultivatorBlockEntity cultivator;
    private CultivateContainer container;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/gui/cultivator_progress.png");

    public CultivateProcessGui(InventoryPlayer inventory, CultivatorBlockEntity entity) {
        this.container = new CultivateContainer(inventory, (TileEntity)entity);
        this.cultivator = entity;
        this.xSize = 176;
        this.ySize = 107;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.add(new GuiButton(0, this.guiLeft + (this.xSize - 100) / 2, this.guiTop + 70, 100, 20, I18n.func_135052_a((String)"container.close.name", (Object[])new Object[0])));
        this.field_146297_k.field_71439_g.field_71070_bA = this.container;
    }

    public void func_73876_c() {
        if (!this.cultivator.isProcessing(0)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.func_73729_b(this.guiLeft + 13, this.guiTop + 49, 0, 107, this.getScaled(this.cultivator.func_174887_a_(0), this.cultivator.func_174887_a_(1), 150), 9);
        Dinosaur dinosaur = this.cultivator.getDinosaur();
        String name = dinosaur != null ? dinosaur.getLocalizedName() : "Unknown";
        String cultivatingLang = I18n.func_135052_a((String)"container.cultivator.cultivating", (Object[])new Object[0]);
        String progressLang = I18n.func_135052_a((String)"container.cultivator.progress", (Object[])new Object[0]);
        String progress = progressLang + ": " + this.getScaled(this.cultivator.func_174887_a_(0), this.cultivator.func_174887_a_(1), 100) + "%";
        String cultivating = cultivatingLang + ": " + name;
        this.field_146289_q.func_78276_b(cultivating, this.guiLeft + (this.xSize - this.field_146289_q.func_78256_a(cultivating)) / 2, this.guiTop + 10, 0x404040);
        this.field_146289_q.func_78276_b(progress, this.guiLeft + (this.xSize - this.field_146289_q.func_78256_a(progress)) / 2, this.guiTop + 40, 0x404040);
        super.func_73863_a(x, y, f);
    }

    private int getScaled(int value, int maxValue, int scale) {
        return maxValue != 0 && value != 0 ? value * scale / maxValue : 0;
    }
}

