/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.container.CultivateContainer;
import org.jurassicraft.server.message.ChangeTemperatureMessage;

@SideOnly(value=Side.CLIENT)
public class CultivateGui
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/gui/cultivator.png");
    private static final ResourceLocation NUTRIENTS_TEXTURE = new ResourceLocation("jurassicraft", "textures/gui/cultivator_nutrients.png");
    private final InventoryPlayer playerInventory;
    private CultivatorBlockEntity cultivator;

    public CultivateGui(InventoryPlayer inventoryPlayer, CultivatorBlockEntity entity) {
        super((Container)new CultivateContainer(inventoryPlayer, (TileEntity)entity));
        this.playerInventory = inventoryPlayer;
        this.cultivator = entity;
        this.field_146999_f = 352;
        this.field_147000_g = 188;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.dragTemperatureSlider(mouseX, mouseY);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.dragTemperatureSlider(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int i, int j) {
        String name = this.cultivator.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2 - 45, 10, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"cultivator.proximates.name", (Object[])new Object[0]), 200, 48, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"cultivator.minerals.name", (Object[])new Object[0]), 200, 74, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"cultivator.vitamins.name", (Object[])new Object[0]), 200, 100, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"cultivator.lipids.name", (Object[])new Object[0]), 200, 126, 0x404040);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_146294_l / 2 - this.field_146999_f / 2, this.field_146295_m / 2 - this.field_147000_g / 2, 0, 0, 176, 188);
        this.func_73729_b(this.field_147003_i + 48, this.field_147009_r + 18, 0, 188, 42, 67 - this.getScaled(this.cultivator.getWaterLevel(), 2, 67));
        this.drawTemperatureSlider();
        this.field_146297_k.field_71446_o.func_110577_a(NUTRIENTS_TEXTURE);
        this.func_73729_b(this.field_146294_l / 2 + 1, this.field_146295_m / 2 - this.field_147000_g / 2, 0, 0, 176, 166);
        int maxNutrients = this.cultivator.getMaxNutrients();
        int nutrientsX = this.field_147003_i + 190;
        this.func_73729_b(nutrientsX, this.field_147009_r + 56, 0, 166, this.getScaled(this.cultivator.getProximates(), maxNutrients, 150), 9);
        this.func_73729_b(nutrientsX, this.field_147009_r + 82, 0, 175, this.getScaled(this.cultivator.getMinerals(), maxNutrients, 150), 9);
        this.func_73729_b(nutrientsX, this.field_147009_r + 108, 0, 184, this.getScaled(this.cultivator.getVitamins(), maxNutrients, 150), 9);
        this.func_73729_b(nutrientsX, this.field_147009_r + 134, 0, 193, this.getScaled(this.cultivator.getLipids(), maxNutrients, 150), 9);
    }

    private void drawTemperatureSlider() {
        int screenX = (this.field_146294_l - this.field_146999_f) / 2;
        int screenY = (this.field_146295_m - this.field_147000_g) / 2;
        int x = screenX + 59;
        int y = screenY + 88;
        int temperature = this.cultivator.getTemperature(0) * 20 / 100;
        this.func_73729_b(x + temperature, y, 176, 0, 3, 5);
    }

    private void dragTemperatureSlider(int mouseX, int mouseY) {
        int mouseTemperature;
        int screenX = (this.field_146294_l - this.field_146999_f) / 2;
        int screenY = (this.field_146295_m - this.field_147000_g) / 2;
        int x = screenX + 59;
        int y = screenY + 88;
        if (mouseX > x && mouseY > y && mouseX < x + 21 && mouseY < y + 5 && (mouseTemperature = (mouseX - x + 1) * 4) != this.cultivator.getTemperature(0)) {
            this.cultivator.setTemperature(0, mouseTemperature);
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new ChangeTemperatureMessage(this.cultivator.func_174877_v(), 0, mouseTemperature, this.cultivator.func_145831_w().field_73011_w.getDimension()));
        }
    }

    private int getScaled(int value, int maxValue, int scale) {
        return maxValue != 0 && value != 0 ? value * scale / maxValue : 0;
    }
}

