/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.event;

import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.event.CustomModelPlayer;
import org.jurassicraft.client.event.ModelPlayerRenderEvent;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.client.render.overlay.HelicopterHUDRenderer;
import org.jurassicraft.server.block.SkullDisplay;
import org.jurassicraft.server.block.entity.SkullDisplayEntity;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.vehicle.HelicopterEntity;
import org.jurassicraft.server.entity.vehicle.MultiSeatedEntity;
import org.jurassicraft.server.entity.vehicle.VehicleEntity;
import org.jurassicraft.server.event.KeyBindingHandler;
import org.jurassicraft.server.item.DartGun;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.message.AttemptMoveToSeatMessage;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    private static final ResourceLocation PATREON_BADGE = new ResourceLocation("jurassicraft", "textures/items/patreon_badge.png");
    private static boolean isGUI;
    public static boolean replacedPlayerModel;

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        ++JurassiCraft.timerTicks;
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!replacedPlayerModel) {
            Render render = Minecraft.func_71410_x().func_175598_ae().func_78715_a(AbstractClientPlayer.class);
            Map skinMap = render.func_177068_d().getSkinMap();
            ClientEventHandler.fixPlayerRenderers((RenderPlayer)skinMap.get("default"), false);
            ClientEventHandler.fixPlayerRenderers((RenderPlayer)skinMap.get("slim"), true);
            replacedPlayerModel = true;
        }
    }

    @SubscribeEvent
    public static void onPlayerModelRender(ModelPlayerRenderEvent.Render.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = player.func_184187_bx();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            vehicle.doPlayerRotations(player, event.getPartialTicks());
        }
    }

    private static void fixPlayerRenderers(RenderPlayer player, boolean slimArms) {
        CustomModelPlayer model = new CustomModelPlayer(0.0f, slimArms);
        List layers = (List)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)player, (String[])new String[]{(Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? "layerRenderers" : "field_177097_h"});
        if (layers != null) {
            for (int i = 0; i < layers.size(); ++i) {
                LayerRenderer layer = (LayerRenderer)layers.get(i);
                if (!(layer instanceof LayerCustomHead)) continue;
                layers.remove(layer);
            }
            layers.add(new LayerCustomHead(((ModelBiped)model).field_78116_c));
        }
        ObfuscationReflectionHelper.setPrivateValue(RenderLivingBase.class, (Object)player, (Object)((Object)model), (String[])new String[]{(Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? "mainModel" : "field_77045_g"});
    }

    @SubscribeEvent
    public static void onGUIRender(GuiScreenEvent.DrawScreenEvent.Pre event) {
        isGUI = true;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            isGUI = false;
        }
    }

    @SubscribeEvent
    public static void hightlightEvent(DrawBlockHighlightEvent e) {
        BlockPos blockpos;
        IBlockState iblockstate;
        if (e.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && (iblockstate = e.getPlayer().field_70170_p.func_180495_p(blockpos = e.getTarget().func_178782_a())).func_177230_c() instanceof SkullDisplay) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            if (iblockstate.func_185904_a() != Material.field_151579_a && e.getPlayer().field_70170_p.func_175723_af().func_177746_a(blockpos)) {
                double x = e.getPlayer().field_70142_S + (e.getPlayer().field_70165_t - e.getPlayer().field_70142_S) * (double)e.getPartialTicks();
                double y = e.getPlayer().field_70137_T + (e.getPlayer().field_70163_u - e.getPlayer().field_70137_T) * (double)e.getPartialTicks();
                double z = e.getPlayer().field_70136_U + (e.getPlayer().field_70161_v - e.getPlayer().field_70136_U) * (double)e.getPartialTicks();
                Vec3d pos = new Vec3d((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5).func_178788_d(new Vec3d(x, y, z));
                GL11.glPushMatrix();
                GL11.glTranslated((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
                TileEntity tile = e.getPlayer().field_70170_p.func_175625_s(blockpos);
                if (tile != null && tile instanceof SkullDisplayEntity && ((SkullDisplayEntity)tile).hasData()) {
                    GlStateManager.func_179114_b((float)((SkullDisplayEntity)tile).getAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
                RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185890_d((IBlockAccess)e.getPlayer().field_70170_p, blockpos).func_186662_g(0.002), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GL11.glPopMatrix();
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameOverlay(RenderGameOverlayEvent.Post event) {
        HelicopterEntity heli;
        Minecraft MC = ClientProxy.MC;
        EntityPlayerSP player = MC.field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof HelicopterEntity && player.func_184187_bx().func_70089_S() && (heli = (HelicopterEntity)player.func_184187_bx()).isController((EntityPlayer)player)) {
            HelicopterHUDRenderer.render(heli, event.getPartialTicks());
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() != ItemHandler.DART_GUN) continue;
            ItemStack dartItem = DartGun.getDartItem(stack);
            if (dartItem.func_190926_b()) break;
            RenderItem renderItem = MC.func_175599_af();
            FontRenderer fontRenderer = MC.field_71466_p;
            ScaledResolution scaledResolution = new ScaledResolution(MC);
            int xPosition = scaledResolution.func_78326_a() - 18;
            int yPosition = scaledResolution.func_78328_b() - 18;
            renderItem.func_180450_b(dartItem, xPosition, yPosition);
            String count = String.valueOf(dartItem.func_190916_E());
            GlStateManager.func_179097_i();
            fontRenderer.func_175063_a(count, (float)(xPosition + 17 - fontRenderer.func_78256_a(count)), (float)(yPosition + 9), -1);
            GlStateManager.func_179126_j();
            break;
        }
    }

    @SubscribeEvent
    public static void keyInputEvent(InputEvent.KeyInputEvent event) {
        int i = 0;
        for (KeyBinding binding : KeyBindingHandler.VEHICLE_KEY_BINDINGS) {
            if (binding.func_151468_f()) {
                int fromSeat;
                EntityPlayerSP player = ClientProxy.MC.field_71439_g;
                Entity entity = player.func_184187_bx();
                if (!(entity instanceof MultiSeatedEntity) || (fromSeat = ((MultiSeatedEntity)entity).getSeatForEntity((Entity)player)) == -1) break;
                JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new AttemptMoveToSeatMessage(entity, fromSeat, i));
                break;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        if (ClientProxy.PATRONS.contains(player.func_110124_au()) && !player.func_70608_bn() && player.field_70725_aQ <= 0 && !player.func_82150_aj() && !player.func_98034_c((EntityPlayer)ClientProxy.MC.field_71439_g)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (isGUI) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            }
            RenderPlayer renderer = event.getRenderer();
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_179114_b((float)(-ClientUtils.interpolate((float)(isGUI ? player.field_70761_aq : player.field_70760_ar), (float)player.field_70761_aq, (float)LLibrary.PROXY.getPartialTicks())), (float)0.0f, (float)1.0f, (float)0.0f);
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(-renderer.func_177087_b().field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(0.5)), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-0.15f, (float)-0.665f);
            } else {
                renderer.func_177087_b().field_78115_e.func_78794_c(0.0625f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(-renderer.func_177087_b().field_78115_e.field_78796_g) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179109_b((float)-0.1f, (float)1.4f, (float)0.14f);
            float scale = 0.35f;
            GlStateManager.func_179152_a((float)0.35f, (float)-0.35f, (float)0.35f);
            GlStateManager.func_179129_p();
            ClientProxy.MC.func_110434_K().func_110577_a(PATREON_BADGE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            if (isGUI) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!Minecraft.func_71382_s()) {
            return;
        }
        Entity cameraEntity = ClientProxy.MC.func_175606_aa();
        Frustum frustrum = new Frustum();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)event.getPartialTicks();
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)event.getPartialTicks();
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)event.getPartialTicks();
        frustrum.func_78547_a(viewX, viewY, viewZ);
        List loadedEntities = ClientProxy.MC.field_71441_e.func_72910_y();
        for (Entity entity : loadedEntities) {
            if (entity == null || !(entity instanceof DinosaurEntity)) continue;
            if (entity.func_145770_h((double)cameraEntity.func_180425_c().func_177958_n(), (double)cameraEntity.func_180425_c().func_177956_o(), (double)cameraEntity.func_180425_c().func_177952_p()) && frustrum.func_78546_a(entity.func_184177_bl().func_186662_g(0.5)) && entity.func_70089_S()) {
                ((DinosaurEntity)entity).isRendered = true;
                continue;
            }
            ((DinosaurEntity)entity).isRendered = false;
        }
    }
}

