/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.tileEntities;

import com.mjr.planetprogression.blocks.BlockCustomLandingPadFull;
import com.mjr.planetprogression.blocks.BlockSatelliteRocketLauncher;
import com.mjr.planetprogression.entities.EntitySatelliteRocket;
import com.mjr.planetprogression.tileEntities.TileEntitySatelliteLandingPad;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntitySatelliteRocketLauncher
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable {
    public static final int WATTS_PER_TICK = 1;
    private List<BlockPos> connectedPads = new ArrayList<BlockPos>();
    public Object attachedDock = null;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int launchDropdownSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchEnabled;

    public TileEntitySatelliteRocketLauncher() {
        super("container.satellite_rocket_launcher.name");
        this.storage.setMaxExtract(6.0f);
        this.noRedstoneControl = true;
        this.launchDropdownSelection = 0;
        this.launchEnabled = false;
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public boolean canRun() {
        return this.hasEnoughEnergyToRun && this.launchEnabled;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.ticks % 20 == 0 && this.canRun()) {
            if (this.connectedPads.size() == 0) {
                for (int x = -4; x <= 4; ++x) {
                    for (int z = -4; z <= 4; ++z) {
                        Block blockID = this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(x, 0, z)).func_177230_c();
                        if (!(blockID instanceof BlockCustomLandingPadFull)) continue;
                        this.connectedPads.add(new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z));
                    }
                }
            } else {
                this.updateRocketOnDockSettings();
            }
        }
    }

    public boolean shouldUseEnergy() {
        return this.canRun();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 0;
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    this.disableCooldown = 10;
                }
            }
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
        }
        return true;
    }

    public boolean canAttachToLandingPad(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntitySatelliteLandingPad;
    }

    public void setLaunchDropdownSelection(int newvalue) {
        if (newvalue != this.launchDropdownSelection) {
            this.launchDropdownSelection = newvalue;
            this.storage.extractEnergyGC(25.0f, false);
            this.updateRocketOnDockSettings();
        }
    }

    public void updateRocketOnDockSettings() {
        TileEntitySatelliteLandingPad pad;
        IDockable rocket;
        if (this.attachedDock instanceof TileEntitySatelliteLandingPad && (rocket = (pad = (TileEntitySatelliteLandingPad)((Object)this.attachedDock)).getDockedEntity()) instanceof EntitySatelliteRocket && this.canRun()) {
            ((EntitySatelliteRocket)rocket).updateControllerSettings(pad);
        }
    }

    public void setAttachedPad(IFuelDock pad) {
        this.attachedDock = pad;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockSatelliteRocketLauncher) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockSatelliteRocketLauncher.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.UP;
    }
}

