/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.tileEntities;

import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.planetprogression.Config;
import com.mjr.planetprogression.blocks.BlockSatelliteController;
import com.mjr.planetprogression.data.SatelliteData;
import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import com.mjr.planetprogression.item.ItemDishKeycard;
import com.mjr.planetprogression.item.PlanetProgression_Items;
import com.mjr.planetprogression.item.ResearchPaper;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.core.blocks.BlockDish;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntitySatelliteController
extends TileBaseElectricBlockWithInventory
implements ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED = (int)((double)SatelliteData.getMAX_DATA() * Config.satelliteControllerModifier);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    public SatelliteData currentSatellite = null;
    public boolean markForSatelliteUpdate = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int currentSatelliteNum = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String currentSatelliteID = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String currentSatelliteResearchBody = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String owner = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean ownerOnline = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerUsername = "";
    public String lastReseached = "";
    public ItemStack producingStack = null;

    public TileEntitySatelliteController() {
        super("container.satellite.controller.name");
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.owner != "") {
            if (this.ticks % 50 == 0) {
                try {
                    if (this.owner != "") {
                        this.ownerOnline = PlayerUtilties.isPlayerOnlineByUUID((String)this.owner);
                    }
                    if (this.ownerOnline && this.ownerUsername == "") {
                        this.ownerUsername = PlayerUtilties.getUsernameFromUUID((String)this.owner);
                    }
                }
                catch (Exception e) {
                    this.ownerOnline = false;
                }
            }
            IStatsCapability stats = null;
            if (this.ownerOnline && PlayerUtilties.getPlayerFromUUID((String)this.owner) != null) {
                stats = (IStatsCapability)PlayerUtilties.getPlayerFromUUID((String)this.owner).getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
            }
            if (this.ownerOnline && stats != null) {
                if (this.markForSatelliteUpdate) {
                    int size;
                    if (this.currentSatellite != null) {
                        this.currentSatellite.setDataAmount(this.currentSatellite.getDataAmount());
                    }
                    int n = size = stats.getSatellites().size() == 0 ? 0 : stats.getSatellites().size() - 1;
                    if (this.currentSatelliteNum > size) {
                        this.currentSatelliteNum = size;
                    }
                    if (stats.getSatellites() != null && stats.getSatellites().size() != 0) {
                        this.currentSatellite = stats.getSatellites().get(this.currentSatelliteNum);
                        this.markForSatelliteUpdate = false;
                    }
                    this.currentSatelliteResearchBody = "";
                }
                if (this.currentSatellite != null) {
                    this.currentSatellite.setDataAmount(this.processTicks);
                    String string = this.currentSatelliteID = this.currentSatellite != null ? this.currentSatellite.getUuid() : "No Satellites Found!";
                    if (this.currentSatelliteResearchBody.equals("") || this.currentSatelliteResearchBody.equals("Nothing!") || this.currentSatelliteResearchBody.equals("Completed All!")) {
                        this.currentSatelliteResearchBody = this.currentSatellite.getCurrentResearchItem() == null || this.currentSatellite.getCurrentResearchItem().func_77973_b() == null ? (stats.getUnlockedPlanets().size() == PlanetProgression_Items.researchPapers.size() ? "Completed All!" : "Nothing!") : ((ResearchPaper)this.currentSatellite.getCurrentResearchItem().func_77973_b()).getBodyName();
                    }
                    if (this.currentSatellite.getCurrentResearchItem() != null && this.currentSatellite.getDataAmount() < PROCESS_TIME_REQUIRED) {
                        this.producingStack = this.currentSatellite.getCurrentResearchItem();
                    } else if (this.currentSatellite.getCurrentResearchItem() == null) {
                        this.setupNewResearch(stats, null);
                    }
                    if (this.canProcess() && this.canOutput() && this.hasEnoughEnergyToRun) {
                        if (this.processTicks == 0) {
                            this.processTicks = PROCESS_TIME_REQUIRED;
                        } else if (--this.processTicks <= 0) {
                            this.smeltItem();
                            this.processTicks = this.canProcess() ? PROCESS_TIME_REQUIRED : 0;
                        }
                    } else {
                        this.processTicks = 0;
                    }
                }
            }
        }
    }

    public boolean hasKeyCard() {
        ItemStack stack = (ItemStack)this.getInventory().get(2);
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemDishKeycard) {
            if (!stack.func_77942_o()) {
                return false;
            }
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z")) {
                return true;
            }
        }
        return false;
    }

    public boolean doesDishExist() {
        ItemStack stack = (ItemStack)this.getInventory().get(2);
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z") && this.field_145850_b.func_180495_p(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))).func_177230_c() instanceof BlockDish;
    }

    public boolean canProcess() {
        if (!this.hasKeyCard()) {
            return false;
        }
        if (!this.doesDishExist()) {
            return false;
        }
        if (this.currentSatelliteResearchBody.equalsIgnoreCase("Nothing")) {
            return false;
        }
        if (this.lastReseached.equalsIgnoreCase(this.currentSatelliteResearchBody)) {
            this.currentSatelliteResearchBody = "Nothing";
            if (this.currentSatellite != null) {
                this.currentSatellite.setCurrentResearchItem(null);
            }
            return false;
        }
        return !this.getDisabled(0);
    }

    public boolean canOutput() {
        if (!((ItemStack)this.getInventory().get(1)).func_190926_b()) {
            return false;
        }
        return this.producingStack != null && this.currentSatellite.getCurrentResearchItem() != null;
    }

    public boolean hasInputs() {
        return true;
    }

    public void smeltItem() {
        ItemStack resultItemStack = this.producingStack;
        if (this.canProcess() && this.canOutput() && this.hasInputs()) {
            if (((ItemStack)this.getInventory().get(1)).func_190926_b()) {
                this.getInventory().set(1, (Object)resultItemStack.func_77946_l());
            } else if (((ItemStack)this.getInventory().get(1)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.getInventory().get(1)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                    for (int i = 0; i < ((ItemStack)this.getInventory().get(1)).func_190916_E() + resultItemStack.func_190916_E() - 64; ++i) {
                        float var = 0.7f;
                        double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + dx, (double)this.func_174877_v().func_177956_o() + dy, (double)this.func_174877_v().func_177952_p() + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77952_i()));
                        entityitem.func_174867_a(10);
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                    ((ItemStack)this.getInventory().get(1)).func_190920_e(64);
                } else {
                    ((ItemStack)this.getInventory().get(1)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
            this.lastReseached = this.currentSatelliteResearchBody;
            this.producingStack = null;
            this.currentSatelliteResearchBody = "";
            IStatsCapability stats = null;
            if (this.ownerOnline && PlayerUtilties.getPlayerFromUUID((String)this.owner) != null) {
                stats = (IStatsCapability)PlayerUtilties.getPlayerFromUUID((String)this.owner).getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
            }
            ItemStack oldItem = this.currentSatellite.getCurrentResearchItem();
            this.setupNewResearch(stats, oldItem);
        }
    }

    public void setupNewResearch(IStatsCapability stats, ItemStack oldItem) {
        ArrayList<String> temp = new ArrayList<String>();
        for (SatelliteData sat : stats.getSatellites()) {
            if (sat.getCurrentResearchItem() == null) continue;
            temp.add(((ResearchPaper)sat.getCurrentResearchItem().func_77973_b()).getBodyName().toLowerCase());
        }
        for (CelestialBody body : stats.getUnlockedPlanets()) {
            temp.add(body.getUnlocalizedName().toLowerCase());
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (temp.contains(moon.getParentPlanet().getUnlocalizedName())) continue;
            temp.add(moon.getUnlocalizedName().toLowerCase());
        }
        if (temp.size() != PlanetProgression_Items.researchPapers.size()) {
            boolean skip = false;
            for (int i = 0; i < PlanetProgression_Items.researchPapers.size(); ++i) {
                skip = false;
                ItemStack newItem = new ItemStack(PlanetProgression_Items.researchPapers.get(i), 1, 0);
                if (temp.size() == 0) {
                    this.producingStack = newItem;
                    this.currentSatellite.setCurrentResearchItem(this.producingStack);
                    return;
                }
                if (oldItem == null) {
                    String newName = ((ResearchPaper)newItem.func_77973_b()).getBodyName().toLowerCase();
                    if (temp.contains(newName)) {
                        skip = true;
                    }
                    if (skip) continue;
                    this.producingStack = newItem;
                    this.currentSatellite.setCurrentResearchItem(this.producingStack);
                    this.currentSatellite.setDataAmount(0);
                    return;
                }
                String oldName = ((ResearchPaper)oldItem.func_77973_b()).getBodyName().toLowerCase();
                String newName = ((ResearchPaper)newItem.func_77973_b()).getBodyName().toLowerCase();
                if (temp.contains(newName) || oldName.equalsIgnoreCase(newName)) {
                    skip = true;
                }
                if (skip) continue;
                this.producingStack = newItem;
                this.currentSatellite.setCurrentResearchItem(this.producingStack);
                this.currentSatellite.setDataAmount(0);
                this.markForSatelliteUpdate = true;
                return;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.currentSatelliteNum = nbt.func_74762_e("currentSatelliteNum");
        this.currentSatelliteID = nbt.func_74779_i("currentSatelliteID");
        this.currentSatelliteResearchBody = nbt.func_74779_i("currentSatelliteResearchBody");
        this.markForSatelliteUpdate = nbt.func_74767_n("markForSatelliteUpdate");
        this.setOwner(nbt.func_74779_i("owner"));
        this.ownerUsername = nbt.func_74779_i("ownerUsername");
        this.ownerOnline = nbt.func_74767_n("ownerOnline");
        this.lastReseached = nbt.func_74779_i("lastReseached");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        nbt.func_74768_a("currentSatelliteNum", this.currentSatelliteNum);
        nbt.func_74778_a("currentSatelliteID", this.currentSatelliteID);
        nbt.func_74778_a("currentSatelliteResearchBody", this.currentSatelliteResearchBody);
        nbt.func_74757_a("markForSatelliteUpdate", true);
        nbt.func_74778_a("owner", this.getOwner());
        nbt.func_74778_a("ownerUsername", this.ownerUsername);
        nbt.func_74757_a("ownerOnline", false);
        nbt.func_74778_a("lastReseached", this.lastReseached);
        return nbt;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{1};
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.UP;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockSatelliteController) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockSatelliteController.FACING);
        }
        return EnumFacing.NORTH;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }
}

