/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.item;

import com.mjr.mjrlegendslib.util.TranslateUtilities;
import com.mjr.planetprogression.PlanetProgression;
import com.mjr.planetprogression.blocks.PlanetProgression_Blocks;
import com.mjr.planetprogression.entities.EntitySatelliteRocket;
import com.mjr.planetprogression.tileEntities.TileEntitySatelliteLandingPad;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSatelliteRocket
extends Item
implements IHoldableItem {
    public ItemSatelliteRocket(String assetName) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b(assetName);
        this.func_77637_a(PlanetProgression.tab);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean padFound = false;
        TileEntity tile = null;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1 = pos.func_177982_a(i, 0, j);
                IBlockState state = worldIn.func_180495_p(pos1);
                Block id = state.func_177230_c();
                int meta = id.func_176201_c(state);
                if (id != PlanetProgression_Blocks.ADVANCED_LAUCHPAD_FULL || meta != 0) continue;
                padFound = true;
                tile = worldIn.func_175625_s(pos.func_177982_a(i, 0, j));
                centerX = (float)(pos.func_177958_n() + i) + 0.5f;
                centerY = (float)pos.func_177956_o() + 0.4f;
                centerZ = (float)(pos.func_177952_p() + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (padFound) {
            if (!ItemSatelliteRocket.placeRocketOnPad(stack, worldIn, tile, centerX, centerY, centerZ, playerIn)) {
                return EnumActionResult.FAIL;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (int i = 1; i < 2; ++i) {
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> par2List, ITooltipFlag flagIn) {
        par2List.add(EnumColor.DARK_AQUA + "\u00a7o" + TranslateUtilities.translate((String)"gui.satellite_pad_use.desc"));
        par2List.add(EnumColor.ORANGE + "\u00a7o" + TranslateUtilities.translate((String)"gui.satellite_pad_extras.1.desc"));
        par2List.add(EnumColor.ORANGE + "\u00a7o" + TranslateUtilities.translate((String)"gui.satellite_pad_extras.2.desc"));
        IRocketType.EnumRocketType type = par1ItemStack.func_77952_i() < 10 ? IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()] : IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            par2List.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            par2List.add(EnumColor.RED + "\u00a7o" + TranslateUtilities.translate((String)"gui.creative_only.desc"));
        }
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("RocketFuel")) {
            EntitySatelliteRocket rocket = new EntitySatelliteRocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()]);
            par2List.add(TranslateUtilities.translate((String)"gui.message.fuel.name") + ": " + par1ItemStack.func_77978_p().func_74762_e("RocketFuel") + " / " + rocket.fuelTank.getCapacity());
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + ".rocket";
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public static boolean placeRocketOnPad(ItemStack stack, World worldIn, TileEntity tile, float centerX, float centerY, float centerZ, EntityPlayer playerIn) {
        if (tile instanceof TileEntitySatelliteLandingPad) {
            if (((TileEntitySatelliteLandingPad)tile).getDockedEntity() != null) {
                return false;
            }
        } else {
            return false;
        }
        EntitySatelliteRocket rocket = new EntitySatelliteRocket(worldIn, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i()], playerIn);
        rocket.field_70177_z += 45.0f;
        rocket.func_70107_b(rocket.field_70165_t, rocket.field_70163_u + rocket.getOnPadYOffset(), rocket.field_70161_v);
        worldIn.func_72838_d((Entity)rocket);
        if (rocket.getType().getPreFueled()) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, rocket.getMaxFuel()), true);
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
            rocket.fuelTank.fill(new FluidStack(GCFluids.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
        }
        return true;
    }
}

