/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.handlers.capabilities;

import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import java.lang.ref.WeakReference;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityProviderStats
implements ICapabilitySerializable<NBTTagCompound> {
    private EntityPlayerMP owner;
    private IStatsCapability statsCapability;

    public CapabilityProviderStats(EntityPlayerMP owner) {
        this.owner = owner;
        this.statsCapability = (IStatsCapability)CapabilityStatsHandler.PP_STATS_CAPABILITY.getDefaultInstance();
        this.statsCapability.setPlayer(new WeakReference<EntityPlayerMP>(this.owner));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityStatsHandler.PP_STATS_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityStatsHandler.PP_STATS_CAPABILITY != null && capability == CapabilityStatsHandler.PP_STATS_CAPABILITY) {
            return (T)CapabilityStatsHandler.PP_STATS_CAPABILITY.cast((Object)this.statsCapability);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.statsCapability.saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.statsCapability.loadNBTData(nbt);
    }
}

