/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.handlers;

import com.google.common.collect.Lists;
import com.mjr.mjrlegendslib.network.IPacket;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import com.mjr.planetprogression.Config;
import com.mjr.planetprogression.PlanetProgression;
import com.mjr.planetprogression.client.handlers.capabilities.CapabilityProviderStatsClient;
import com.mjr.planetprogression.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.planetprogression.data.SatelliteData;
import com.mjr.planetprogression.handlers.capabilities.CapabilityProviderStats;
import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import com.mjr.planetprogression.item.PlanetProgression_Items;
import com.mjr.planetprogression.item.ResearchPaper;
import com.mjr.planetprogression.network.PacketSimplePP;
import com.mjr.planetprogression.network.PlanetProgressionPacketHandler;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MainHandlerServer {
    private static List<PlanetProgressionPacketHandler> packetHandlers = Lists.newCopyOnWriteArrayList();

    public static void addPacketHandler(PlanetProgressionPacketHandler handler) {
        packetHandlers.add(handler);
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        for (PlanetProgressionPacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            for (PlanetProgressionPacketHandler handler : packetHandlers) {
                handler.tick((World)world);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        IStatsCapability oldStats = (IStatsCapability)event.getOriginal().getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
        IStatsCapability newStats = (IStatsCapability)event.getEntityPlayer().getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
        newStats.copyFrom(oldStats, !event.isWasDeath() || event.getOriginal().field_70170_p.func_82736_K().func_82766_b("keepInventory"));
    }

    @SubscribeEvent
    public void onEntityDealth(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            Object stats = null;
            if (entityLiving != null) {
                IStatsCapability iStatsCapability = (IStatsCapability)entityLiving.getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(CapabilityStatsHandler.PP_PLAYER_PROP, (ICapabilityProvider)new CapabilityProviderStats((EntityPlayerMP)event.getObject()));
        } else if (event.getObject() instanceof EntityPlayer && ((EntityPlayer)event.getObject()).field_70170_p.field_72995_K) {
            this.onAttachCapabilityClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAttachCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerSP) {
            event.addCapability(CapabilityStatsClientHandler.PP_PLAYER_CLIENT_PROP, (ICapabilityProvider)new CapabilityProviderStatsClient((EntityPlayerSP)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            int tick = player.field_70173_aa - 1;
            IStatsCapability stats = (IStatsCapability)player.getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
            if (tick % 30 == 0) {
                this.sendUnlockedPlanetsPacket(player, stats);
                MainHandlerServer.sendSatellitePacket(player, stats);
                SchematicRegistry.addUnlockedPage((EntityPlayerMP)player, (ISchematicPage)SchematicRegistry.getMatchingRecipeForID((int)2535));
            }
            if (event.getEntityLiving().field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                CelestialBody temp = GalaxyRegistry.getCelestialBodyFromDimensionID((int)event.getEntityLiving().field_70170_p.field_73011_w.getDimension());
                if (temp != null && !stats.getUnlockedPlanets().contains(temp)) {
                    stats.addUnlockedPlanets(temp);
                    player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.discovered.name") + temp.getLocalizedName() + "!"));
                    player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.howto.name")));
                }
            } else if (!stats.getUnlockedPlanets().contains(GalacticraftCore.planetOverworld)) {
                stats.addUnlockedPlanets((CelestialBody)GalacticraftCore.planetOverworld);
                if (Config.showOverworldSpawnMessage) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.discovered.earth.name")));
                    player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.howto.name")));
                }
            }
            List<String> list = Arrays.asList(Config.preReseachedBodies);
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                if (!list.contains(PlanetProgression.getBodyName(planet.getUnlocalizedName())) || planet == null || stats.getUnlockedPlanets().contains(planet)) continue;
                stats.addUnlockedPlanets((CelestialBody)planet);
                player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.discovered.name") + planet.getLocalizedName() + "!"));
                player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.howto.name")));
            }
            for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
                if (!list.contains(PlanetProgression.getBodyName(moon.getUnlocalizedName())) || moon == null || stats.getUnlockedPlanets().contains(moon)) continue;
                stats.addUnlockedPlanets((CelestialBody)moon);
                player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.discovered.name") + moon.getLocalizedName() + "!"));
                player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"research.howto.name")));
            }
        }
    }

    protected void sendUnlockedPlanetsPacket(EntityPlayerMP player, IStatsCapability stats) {
        String[] planets;
        if (stats.getUnlockedPlanets().isEmpty()) {
            planets = new String[]{};
        } else {
            int size = stats.getUnlockedPlanets().size();
            planets = new String[size];
            for (int i = 0; i < size; ++i) {
                planets[i] = stats.getUnlockedPlanets().get(i) != null ? stats.getUnlockedPlanets().get(i).getUnlocalizedName() : "";
            }
        }
        PlanetProgression.packetPipeline.sendTo((IPacket)new PacketSimplePP(PacketSimplePP.EnumSimplePacket.C_UPDATE_UNLOCKED_PLANET_LIST, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{planets}), player);
    }

    public static void sendSatellitePacket(EntityPlayerMP player, IStatsCapability stats) {
        for (SatelliteData sat : stats.getSatellites()) {
            int type = sat.getType();
            String uuid = sat.getUuid();
            int dataAmount = sat.getDataAmount();
            ItemStack item = sat.getCurrentResearchItem();
            PlanetProgression.packetPipeline.sendTo((IPacket)new PacketSimplePP(PacketSimplePP.EnumSimplePacket.C_UPDATE_SATELLITE_LIST, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{type, uuid, dataAmount, item == null ? "null" : "planetprogression:" + item.func_77977_a().substring(5) + ":" + item.func_77960_j()}), player);
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (event.getName().toString().equals("minecraft:chests/simple_dungeon") && Config.generateResearchPaperInLoot) {
            for (Item item : PlanetProgression_Items.researchPapers) {
                if (Arrays.asList(Config.dungeonPaperBlacklist).contains(PlanetProgression.getBodyName(((ResearchPaper)item).getBodyName()))) continue;
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(item, 50, 1, new LootFunction[0], new LootCondition[0], item.func_77658_a() + "_" + ((ResearchPaper)item).getBodyName()));
            }
        }
    }
}

