/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression;

import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.NetworkUtilities;
import com.mjr.mjrlegendslib.util.RegisterUtilities;
import com.mjr.planetprogression.Config;
import com.mjr.planetprogression.blocks.PlanetProgression_Blocks;
import com.mjr.planetprogression.client.gui.GuiHandler;
import com.mjr.planetprogression.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.planetprogression.command.CommandAddSatellite;
import com.mjr.planetprogression.command.CommandRemoveAllSatellites;
import com.mjr.planetprogression.command.CommandRemoveAllUnlockedCelestialBody;
import com.mjr.planetprogression.command.CommandRemoveUnlockedCelestialBody;
import com.mjr.planetprogression.command.CommandUnlockAllCelestialBody;
import com.mjr.planetprogression.command.CommandUnlockCelestialBody;
import com.mjr.planetprogression.entities.EntitySatelliteRocket;
import com.mjr.planetprogression.handlers.MainHandlerServer;
import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.item.PlanetProgression_Items;
import com.mjr.planetprogression.item.SchematicSatelliteRocket;
import com.mjr.planetprogression.network.PlanetProgressionChannelHandler;
import com.mjr.planetprogression.proxy.CommonProxy;
import com.mjr.planetprogression.recipes.PlanetProgression_RecipeGeneration;
import com.mjr.planetprogression.recipes.PlanetProgression_Recipes;
import com.mjr.planetprogression.world.WorldGenerater;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="planetprogression", name="Planet Progression", version="1.12.2-0.4.2", dependencies="required-after:forge@[13.20.1.2513,); required-after:mjrlegendslib@[1.12.2-1.1.6,); required-after:galacticraftcore@[4.0.2.211,); required-after:galacticraftplanets@[4.0.2.211,); after:extraplanets; after:moreplanets; after:blankplanet; after:zollerngalaxy;", certificateFingerprint="b02331787272ec3515ebe63ecdeea0d746653468", acceptedMinecraftVersions="[1.12.2]")
public class PlanetProgression {
    @SidedProxy(clientSide="com.mjr.planetprogression.proxy.ClientProxy", serverSide="com.mjr.planetprogression.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="planetprogression")
    public static PlanetProgression instance;
    public static PlanetProgressionChannelHandler packetPipeline;
    public static boolean generateRecipes;
    public static List<Item> itemList;
    public static List<Block> blocksList;
    public static CreativeTabs tab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load();
        RegisterUtilities.registerEventHandler((Object)new MainHandlerServer());
        PlanetProgression_Blocks.init();
        PlanetProgression_Items.init();
        RegisterUtilities.registerEventHandler((Object)new RegistrationHandler());
        PlanetProgression_Recipes.initRocketRecipes();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline = PlanetProgressionChannelHandler.init();
        this.registerNonMobEntities();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        CapabilityStatsHandler.register();
        CapabilityStatsClientHandler.register();
        NetworkUtilities.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicSatelliteRocket());
        if (Config.generateResearchPaperInStructure) {
            RegisterUtilities.registerWorldGenerator((IWorldGenerator)new WorldGenerater());
        }
        if (generateRecipes) {
            PlanetProgression_RecipeGeneration.generate();
            PlanetProgression_RecipeGeneration.generateConstants();
        }
        proxy.postInit(event);
    }

    private void registerNonMobEntities() {
        if (Config.researchMode == 2 || Config.researchMode == 3) {
            RegisterUtilities.registerNonMobEntity((String)"planetprogression", (Object)instance, EntitySatelliteRocket.class, (String)"EntitySatelliteRocket", (int)150, (int)1, (boolean)false);
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandAddSatellite());
        event.registerServerCommand((ICommand)new CommandRemoveAllSatellites());
        event.registerServerCommand((ICommand)new CommandUnlockCelestialBody());
        event.registerServerCommand((ICommand)new CommandUnlockAllCelestialBody());
        event.registerServerCommand((ICommand)new CommandRemoveUnlockedCelestialBody());
        event.registerServerCommand((ICommand)new CommandRemoveAllUnlockedCelestialBody());
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        MessageUtilities.fatalErrorMessageToLog((String)"planetprogression", (String)("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported!"));
    }

    public static String getBodyName(String input) {
        if ((input = input.toLowerCase()).endsWith("ep")) {
            input = input.substring(0, input.length() - 2);
        }
        return input;
    }

    static {
        generateRecipes = false;
        itemList = new ArrayList<Item>();
        blocksList = new ArrayList<Block>();
        tab = new CreativeTabs("PlanetProgressionTab"){

            public ItemStack func_78016_d() {
                if (Config.researchMode == 2) {
                    return new ItemStack(PlanetProgression_Items.satelliteBasic);
                }
                return new ItemStack(PlanetProgression_Items.researchPapers.get(0));
            }
        };
    }

    @Mod.EventBusSubscriber(modid="planetprogression")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocksEvent(RegistryEvent.Register<Block> event) {
            for (Block block : blocksList) {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemsEvent(RegistryEvent.Register<Item> event) {
            PlanetProgression_Items.initResearchPaperItems();
            PlanetProgression_Items.registerResearchPaperItems();
            for (Item item : itemList) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipesEvent(RegistryEvent.Register<IRecipe> event) {
            PlanetProgression_Recipes.init();
        }
    }
}

