/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.AEColor;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolMemoryCard
extends AEBaseItem
implements IMemoryCard {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public ToolMemoryCard() {
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        lines.add(this.getLocalizedName(this.getSettingsName(stack) + ".name", this.getSettingsName(stack)));
        NBTTagCompound data = this.getData(stack);
        if (data.func_74764_b("tooltip")) {
            lines.add(I18n.func_74838_a((String)this.getLocalizedName(data.func_74779_i("tooltip") + ".name", data.func_74779_i("tooltip"))));
        }
        if (data.func_74764_b("freq")) {
            short freq = data.func_74765_d("freq");
            String freqTooltip = TextFormatting.BOLD + Platform.p2p().toHexString(freq);
            lines.add(I18n.func_74837_a((String)"gui.tooltips.appliedenergistics2.P2PFrequency", (Object[])new Object[]{freqTooltip}));
        }
    }

    private String getLocalizedName(String ... name) {
        for (String n3 : name) {
            String l = I18n.func_74838_a((String)n3);
            if (l.equals(n3)) continue;
            return l;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData(is);
        c.func_74778_a("Config", settingsName);
        c.func_74782_a("Data", (NBTBase)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        String name = c.func_74779_i("Config");
        return name == null || name.isEmpty() ? GuiText.Blank.getUnlocalized() : name;
    }

    @Override
    public NBTTagCompound getData(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        NBTTagCompound o = c.func_74775_l("Data");
        if (o == null) {
            o = new NBTTagCompound();
        }
        return o.func_74737_b();
    }

    @Override
    public AEColor[] getColorCode(ItemStack is) {
        NBTTagCompound tag = this.getData(is);
        if (tag.func_74764_b("colorCode")) {
            int[] frequency = tag.func_74759_k("colorCode");
            AEColor[] colorArray = AEColor.values();
            return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(EntityPlayer player, MemoryCardMessages msg) {
        if (Platform.isClient()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.func_145747_a(PlayerMessages.SettingCleared.get());
                break;
            }
            case INVALID_MACHINE: {
                player.func_145747_a(PlayerMessages.InvalidMachine.get());
                break;
            }
            case SETTINGS_LOADED: {
                player.func_145747_a(PlayerMessages.LoadedSettings.get());
                break;
            }
            case SETTINGS_SAVED: {
                player.func_145747_a(PlayerMessages.SavedSettings.get());
                break;
            }
            case SETTINGS_RESET: {
                player.func_145747_a(PlayerMessages.ResetSettings.get());
                break;
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hx, float hy, float hz) {
        if (player.func_70093_af()) {
            if (!w.field_72995_K) {
                this.clearCard(player, w, hand);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, w, pos, hand, side, hx, hy, hz);
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && !w.field_72995_K) {
            this.clearCard(player, w, hand);
        }
        return super.func_77659_a(w, player, hand);
    }

    public boolean doesSneakBypassUse(ItemStack itemstack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    private void clearCard(EntityPlayer player, World w, EnumHand hand) {
        IMemoryCard mem = (IMemoryCard)player.func_184586_b(hand).func_77973_b();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.func_184586_b(hand).func_77982_d(null);
    }
}

