/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketFluidSlot
extends AppEngPacket {
    private final Map<Integer, IAEFluidStack> list;

    public PacketFluidSlot(ByteBuf stream) {
        this.list = new HashMap<Integer, IAEFluidStack>();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)stream);
        for (String key : tag.func_150296_c()) {
            this.list.put(Integer.parseInt(key), AEFluidStack.fromNBT(tag.func_74775_l(key)));
        }
    }

    public PacketFluidSlot(Map<Integer, IAEFluidStack> list) {
        this.list = list;
        NBTTagCompound sendTag = new NBTTagCompound();
        for (Map.Entry<Integer, IAEFluidStack> fs : list.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            if (fs.getValue() != null) {
                fs.getValue().writeToNBT(tag);
            }
            sendTag.func_74782_a(fs.getKey().toString(), (NBTBase)tag);
        }
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)sendTag);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        Container c = player.field_71070_bA;
        if (c instanceof IFluidSyncContainer) {
            ((IFluidSyncContainer)c).receiveFluidSlots(this.list);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        Container c = player.field_71070_bA;
        if (c instanceof IFluidSyncContainer) {
            ((IFluidSyncContainer)c).receiveFluidSlots(this.list);
        }
    }
}

