/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

class ColorApplicatorBakedModel
implements IBakedModel {
    private final IBakedModel baseModel;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final EnumMap<EnumFacing, List<BakedQuad>> quadsBySide;
    private final List<BakedQuad> generalQuads;

    ColorApplicatorBakedModel(IBakedModel baseModel, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map, TextureAtlasSprite texDark, TextureAtlasSprite texMedium, TextureAtlasSprite texBright) {
        this.baseModel = baseModel;
        this.transforms = map;
        this.generalQuads = this.fixQuadTint(null, texDark, texMedium, texBright);
        this.quadsBySide = new EnumMap(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            this.quadsBySide.put(facing, this.fixQuadTint(facing, texDark, texMedium, texBright));
        }
    }

    private List<BakedQuad> fixQuadTint(EnumFacing facing, TextureAtlasSprite texDark, TextureAtlasSprite texMedium, TextureAtlasSprite texBright) {
        List quads = this.baseModel.func_188616_a(null, facing, 0L);
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            int tint;
            if (quad.func_187508_a() == texDark) {
                tint = 1;
            } else if (quad.func_187508_a() == texMedium) {
                tint = 2;
            } else if (quad.func_187508_a() == texBright) {
                tint = 3;
            } else {
                result.add(quad);
                continue;
            }
            BakedQuad newQuad = new BakedQuad(quad.func_178209_a(), tint, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
            result.add(newQuad);
        }
        return result;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.generalQuads;
        }
        return this.quadsBySide.get(side);
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
    }
}

