/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.client.render.FacingToRotation;
import appeng.core.AELog;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;

public class QuadRotator {
    public List<BakedQuad> rotateQuads(List<BakedQuad> quads, EnumFacing newForward, EnumFacing newUp) {
        if (newForward == EnumFacing.NORTH && newUp == EnumFacing.UP) {
            return quads;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            result.add(this.rotateQuad(quad, newForward, newUp));
        }
        return result;
    }

    private BakedQuad rotateQuad(BakedQuad quad, EnumFacing forward, EnumFacing up) {
        int i;
        if (forward.func_176740_k() == up.func_176740_k()) {
            up = up.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.UP;
        }
        FacingToRotation rotation = FacingToRotation.get(forward, up);
        Matrix4f mat = rotation.getMat();
        int[] newData = (int[])quad.func_178209_a().clone();
        VertexFormat format = quad.getFormat();
        int posIdx = this.findPositionOffset(format) / 4;
        int stride = format.func_177338_f() / 4;
        int normalIdx = format.func_177342_c();
        VertexFormatElement.EnumType normalType = null;
        if (normalIdx != -1) {
            for (i = 0; i < format.func_177343_g().size(); ++i) {
                VertexFormatElement element = format.func_177348_c(i);
                if (element.func_177375_c() != VertexFormatElement.EnumUsage.NORMAL) continue;
                normalType = element.func_177367_b();
            }
        }
        for (i = 0; i < 4; ++i) {
            Point3f pos = new Point3f(Float.intBitsToFloat(newData[i * stride + posIdx]) - 0.5f, Float.intBitsToFloat(newData[i * stride + posIdx + 1]) - 0.5f, Float.intBitsToFloat(newData[i * stride + posIdx + 2]) - 0.5f);
            mat.transform(pos);
            newData[i * stride + posIdx] = Float.floatToIntBits(pos.getX() + 0.5f);
            newData[i * stride + posIdx + 1] = Float.floatToIntBits(pos.getY() + 0.5f);
            newData[i * stride + posIdx + 2] = Float.floatToIntBits(pos.getZ() + 0.5f);
            if (normalIdx == -1) continue;
            if (normalType == VertexFormatElement.EnumType.FLOAT) {
                Vector3f normal = new Vector3f(Float.intBitsToFloat(newData[i * stride + normalIdx]), Float.intBitsToFloat(newData[i * stride + normalIdx + 1]), Float.intBitsToFloat(newData[i * stride + normalIdx + 2]));
                mat.transform(normal);
                newData[i * stride + normalIdx] = Float.floatToIntBits(normal.getX());
                newData[i * stride + normalIdx + 1] = Float.floatToIntBits(normal.getY());
                newData[i * stride + normalIdx + 2] = Float.floatToIntBits(normal.getZ());
                continue;
            }
            if (normalType == VertexFormatElement.EnumType.BYTE) {
                int idx = i * stride * 4 + normalIdx;
                Vector3f normal = new Vector3f((float)QuadRotator.getByte(newData, idx) / 127.0f, (float)QuadRotator.getByte(newData, idx + 1) / 127.0f, (float)QuadRotator.getByte(newData, idx + 2) / 127.0f);
                mat.transform(normal);
                QuadRotator.setByte(newData, idx, (int)(normal.getX() * 127.0f));
                QuadRotator.setByte(newData, idx + 1, (int)(normal.getY() * 127.0f));
                QuadRotator.setByte(newData, idx + 2, (int)(normal.getZ() * 127.0f));
                continue;
            }
            AELog.warn("Unsupported normal format: {}", normalType);
        }
        EnumFacing newFace = rotation.rotate(quad.func_178210_d());
        return new BakedQuad(newData, quad.func_178211_c(), newFace, quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    private static int getByte(int[] data, int offset) {
        int idx = offset / 4;
        int subOffset = offset % 4;
        return (byte)(data[idx] >> subOffset * 8);
    }

    private static void setByte(int[] data, int offset, int value) {
        int idx = offset / 4;
        int subOffset = offset % 4;
        int mask = 255 << subOffset * 8;
        data[idx] = data[idx] & ~mask | (value & 0xFF) << subOffset * 8;
    }

    private int findPositionOffset(VertexFormat format) {
        List elements = format.func_177343_g();
        for (int i = 0; i < elements.size(); ++i) {
            VertexFormatElement e = (VertexFormatElement)elements.get(i);
            if (!e.func_177374_g()) continue;
            if (e.func_177367_b() != VertexFormatElement.EnumType.FLOAT) {
                throw new IllegalArgumentException("Only floating point positions are supported");
            }
            return i;
        }
        throw new IllegalArgumentException("Vertex format " + format + " has no position attribute!");
    }
}

